/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.Constants;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;

public abstract class ManagerBase
implements Manager,
MBeanRegistration {
    protected Logger log = Logger.getLogger(ManagerBase.class);
    private static final char[] SESSION_ID_ALPHABET = System.getProperty("org.apache.catalina.session.ManagerBase.SESSION_ID_ALPHABET", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-_").toCharArray();
    protected Container container;
    protected boolean distributable;
    private static final String info = "ManagerBase/2.0";
    protected int maxInactiveInterval = 60;
    protected int sessionIdLength = 18;
    protected static String name = "ManagerBase";
    protected int sessionMaxAliveTime;
    protected int sessionAverageAliveTime;
    protected int expiredSessions = 0;
    protected Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    protected int sessionCounter = 0;
    protected int maxActive = 0;
    protected int duplicates = 0;
    protected boolean initialized = false;
    protected long processingTime = 0L;
    private int count = 0;
    protected int processExpiresFrequency = 6;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.session");
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", new Boolean(oldDistributable), new Boolean(this.distributable));
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        int oldMaxInactiveInterval = this.maxInactiveInterval;
        this.maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", new Integer(oldMaxInactiveInterval), new Integer(this.maxInactiveInterval));
    }

    @Override
    public int getSessionIdLength() {
        return this.sessionIdLength;
    }

    @Override
    public void setSessionIdLength(int idLength) {
        int oldSessionIdLength = this.sessionIdLength;
        this.sessionIdLength = idLength;
        this.support.firePropertyChange("sessionIdLength", new Integer(oldSessionIdLength), new Integer(this.sessionIdLength));
    }

    public String getName() {
        return name;
    }

    @Override
    public int getExpiredSessions() {
        return this.expiredSessions;
    }

    @Override
    public void setExpiredSessions(int expiredSessions) {
        this.expiredSessions = expiredSessions;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public int getProcessExpiresFrequency() {
        return this.processExpiresFrequency;
    }

    public void setProcessExpiresFrequency(int processExpiresFrequency) {
        if (processExpiresFrequency <= 0) {
            return;
        }
        int oldProcessExpiresFrequency = this.processExpiresFrequency;
        this.processExpiresFrequency = processExpiresFrequency;
        this.support.firePropertyChange("processExpiresFrequency", new Integer(oldProcessExpiresFrequency), new Integer(this.processExpiresFrequency));
    }

    @Override
    public void backgroundProcess() {
        this.count = (this.count + 1) % this.processExpiresFrequency;
        if (this.count == 0) {
            this.processExpires();
        }
    }

    public void processExpires() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireHere = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Start expire sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length));
        }
        for (int i = 0; i < sessions.length; ++i) {
            if (sessions[i] == null || sessions[i].isValid()) continue;
            ++expireHere;
        }
        long timeEnd = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("End expire sessions " + this.getName() + " processingTime " + (timeEnd - timeNow) + " expired sessions: " + expireHere));
        }
        this.processingTime += timeEnd - timeNow;
    }

    public void destroy() {
        if (Constants.ENABLE_MODELER && this.oname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
        }
        this.initialized = false;
        this.oname = null;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.log = Logger.getLogger(ManagerBase.class);
        StandardContext ctx = (StandardContext)this.getContainer();
        this.distributable = ctx.getDistributable();
        if (Constants.ENABLE_MODELER && this.oname == null) {
            try {
                Engine eng = (Engine)ctx.getParent().getParent();
                this.domain = ctx.getEngineName();
                StandardHost hst = (StandardHost)ctx.getParent();
                String path = ctx.getPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.oname = new ObjectName(this.domain + ":type=Manager,path=" + path + ",host=" + hst.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                this.log.error((Object)"Error registering ", (Throwable)e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering " + this.oname));
        }
    }

    @Override
    public void add(Session session) {
        this.sessions.put(session.getIdInternal(), session);
        int size = this.sessions.size();
        if (size > this.maxActive) {
            this.maxActive = size;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void changeSessionId(Session session, Random random) {
        session.setId(this.generateSessionId(random));
    }

    @Override
    public Session createSession(String sessionId, Random random) {
        Session session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        if (sessionId == null) {
            sessionId = this.generateSessionId(random);
        }
        session.setId(sessionId);
        ++this.sessionCounter;
        return session;
    }

    @Override
    public Session createEmptySession() {
        return this.getNewSession();
    }

    @Override
    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    @Override
    public Session[] findSessions() {
        return this.sessions.values().toArray(new Session[0]);
    }

    @Override
    public void remove(Session session) {
        this.sessions.remove(session.getIdInternal());
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected StandardSession getNewSession() {
        return new StandardSession(this);
    }

    protected String generateSessionId(Random random) {
        byte[] bytes = new byte[this.sessionIdLength];
        random.nextBytes(bytes);
        char[] id = ManagerBase.encode(bytes);
        String jvmRoute = this.getJvmRoute();
        if (this.appendJVMRoute() && jvmRoute != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(id).append('.').append(jvmRoute);
            return buffer.toString();
        }
        return String.valueOf(id);
    }

    protected boolean appendJVMRoute() {
        return true;
    }

    public static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        char[] alphabet = SESSION_ID_ALPHABET;
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (c == null || !(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        Engine e = this.getEngine();
        return e == null ? null : e.getJvmRoute();
    }

    @Override
    public void setSessionCounter(int sessionCounter) {
        this.sessionCounter = sessionCounter;
    }

    @Override
    public int getSessionCounter() {
        return this.sessionCounter;
    }

    public int getDuplicates() {
        return this.duplicates;
    }

    public void setDuplicates(int duplicates) {
        this.duplicates = duplicates;
    }

    @Override
    public int getActiveSessions() {
        return this.sessions.size();
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    @Override
    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    @Override
    public int getSessionMaxAliveTime() {
        return this.sessionMaxAliveTime;
    }

    @Override
    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
        this.sessionMaxAliveTime = sessionMaxAliveTime;
    }

    @Override
    public int getSessionAverageAliveTime() {
        return this.sessionAverageAliveTime;
    }

    @Override
    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
        this.sessionAverageAliveTime = sessionAverageAliveTime;
    }

    public String listSessionIds() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            sb.append((Object)keys.next()).append(" ");
        }
        return sb.toString();
    }

    public String getSessionAttribute(String sessionId, String key) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Object o = s.getSession().getAttribute(key);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public HashMap getSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return null;
        }
        Enumeration ee = s.getSession().getAttributeNames();
        if (ee == null || !ee.hasMoreElements()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (ee.hasMoreElements()) {
            String attrName = (String)ee.nextElement();
            map.put(attrName, this.getSessionAttribute(sessionId, attrName));
        }
        return map;
    }

    public void expireSession(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return;
        }
        s.expire();
    }

    public String getLastAccessedTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getLastAccessedTime()).toString();
    }

    public String getCreationTime(String sessionId) {
        Session s = this.sessions.get(sessionId);
        if (s == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Session not found " + sessionId));
            }
            return "";
        }
        return new Date(s.getCreationTime()).toString();
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

