/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.lang.reflect.Modifier;
import java.util.List;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.singleton.SingletonComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateless.StatelessComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.deployment.processors.EJBComponentDescriptionFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.ejb.spec.SessionType;
import org.jboss.msc.service.ServiceName;

public class SessionBeanComponentDescriptionFactory
extends EJBComponentDescriptionFactory {
    private static final Logger logger = Logger.getLogger(SessionBeanComponentDescriptionFactory.class);
    private static final DotName STATELESS_ANNOTATION = DotName.createSimple((String)Stateless.class.getName());
    private static final DotName STATEFUL_ANNOTATION = DotName.createSimple((String)Stateful.class.getName());
    private static final DotName SINGLETON_ANNOTATION = DotName.createSimple((String)Singleton.class.getName());

    @Override
    protected void processAnnotations(DeploymentUnit deploymentUnit, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        List sbAnnotations;
        List sfsbAnnotations;
        List slsbAnnotations = compositeIndex.getAnnotations(STATELESS_ANNOTATION);
        if (!slsbAnnotations.isEmpty()) {
            this.processSessionBeans(deploymentUnit, slsbAnnotations, SessionBeanComponentDescription.SessionBeanType.STATELESS);
        }
        if (!(sfsbAnnotations = compositeIndex.getAnnotations(STATEFUL_ANNOTATION)).isEmpty()) {
            this.processSessionBeans(deploymentUnit, sfsbAnnotations, SessionBeanComponentDescription.SessionBeanType.STATEFUL);
        }
        if (!(sbAnnotations = compositeIndex.getAnnotations(SINGLETON_ANNOTATION)).isEmpty()) {
            this.processSessionBeans(deploymentUnit, sbAnnotations, SessionBeanComponentDescription.SessionBeanType.SINGLETON);
        }
    }

    @Override
    protected void processBeanMetaData(DeploymentUnit deploymentUnit, EnterpriseBeanMetaData enterpriseBeanMetaData) throws DeploymentUnitProcessingException {
        if (enterpriseBeanMetaData instanceof SessionBeanMetaData) {
            this.processSessionBeanMetaData(deploymentUnit, (SessionBeanMetaData)enterpriseBeanMetaData);
        }
    }

    private void processSessionBeans(DeploymentUnit deploymentUnit, List<AnnotationInstance> sessionBeanAnnotations, SessionBeanComponentDescription.SessionBeanType annotatedSessionBeanType) {
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EjbJarDescription ejbJarDescription = this.getEjbJarDescription(deploymentUnit);
        ServiceName deploymentUnitServiceName = deploymentUnit.getServiceName();
        for (AnnotationInstance sessionBeanAnnotation : sessionBeanAnnotations) {
            SessionBeanComponentDescription sessionBeanDescription;
            String beanClassName;
            SessionBeanComponentDescription.SessionBeanType sessionBeanType;
            AnnotationTarget target = sessionBeanAnnotation.target();
            if (!(target instanceof ClassInfo)) {
                logger.warn((Object)(sessionBeanAnnotation.name() + " annotation is expected to be applied on class level. " + target + " is not a class"));
                continue;
            }
            ClassInfo sessionBeanClassInfo = (ClassInfo)target;
            if (!SessionBeanComponentDescriptionFactory.assertSessionBeanClassValidity(sessionBeanClassInfo)) continue;
            String ejbName = sessionBeanClassInfo.name().local();
            AnnotationValue nameValue = sessionBeanAnnotation.value("name");
            String beanName = nameValue == null || nameValue.asString().isEmpty() ? ejbName : nameValue.asString();
            SessionBeanMetaData beanMetaData = this.getEnterpriseBeanMetaData(deploymentUnit, beanName, SessionBeanMetaData.class);
            if (beanMetaData != null) {
                sessionBeanType = SessionBeanComponentDescriptionFactory.override(annotatedSessionBeanType, SessionBeanComponentDescriptionFactory.descriptionOf(beanMetaData.getSessionType()));
                beanClassName = SessionBeanComponentDescriptionFactory.override(sessionBeanClassInfo.name().toString(), beanMetaData.getEjbClass());
            } else {
                sessionBeanType = annotatedSessionBeanType;
                beanClassName = sessionBeanClassInfo.name().toString();
            }
            switch (sessionBeanType) {
                case STATELESS: {
                    sessionBeanDescription = new StatelessComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName);
                    break;
                }
                case STATEFUL: {
                    sessionBeanDescription = new StatefulComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName);
                    break;
                }
                case SINGLETON: {
                    sessionBeanDescription = new SingletonComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnitServiceName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown session bean type: " + (Object)((Object)sessionBeanType));
                }
            }
            ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)sessionBeanDescription);
        }
        EjbDeploymentMarker.mark(deploymentUnit);
    }

    private static SessionBeanComponentDescription.SessionBeanType descriptionOf(SessionType sessionType) {
        if (sessionType == null) {
            return null;
        }
        switch (sessionType) {
            case Stateless: {
                return SessionBeanComponentDescription.SessionBeanType.STATELESS;
            }
            case Stateful: {
                return SessionBeanComponentDescription.SessionBeanType.STATEFUL;
            }
            case Singleton: {
                return SessionBeanComponentDescription.SessionBeanType.SINGLETON;
            }
        }
        throw new IllegalArgumentException("Unknown session bean type: " + sessionType);
    }

    private static boolean assertSessionBeanClassValidity(ClassInfo sessionBeanClass) {
        short flags = sessionBeanClass.flags();
        String className = sessionBeanClass.name().toString();
        if (Modifier.isInterface(flags)) {
            logger.warn((Object)("[EJB3.1 spec, section 4.9.2] Session bean implementation class MUST NOT be a interface - " + className + " is an interface, hence won't be considered as a session bean"));
            return false;
        }
        if (!Modifier.isPublic(flags) || Modifier.isAbstract(flags) || Modifier.isFinal(flags)) {
            logger.warn((Object)("[EJB3.1 spec, section 4.9.2] Session bean implementation class MUST be public, not abstract and not final - " + className + " won't be considered as a session bean, since it doesn't meet that requirement"));
            return false;
        }
        return true;
    }

    private void processSessionBeanMetaData(DeploymentUnit deploymentUnit, SessionBeanMetaData sessionBean) throws DeploymentUnitProcessingException {
        SessionBeanComponentDescription sessionBeanDescription;
        String beanName;
        EjbJarDescription ejbJarDescription = this.getEjbJarDescription(deploymentUnit);
        if (ejbJarDescription.hasComponent(beanName = sessionBean.getName())) {
            return;
        }
        SessionType sessionType = sessionBean.getSessionType();
        if (sessionType == null) {
            throw new DeploymentUnitProcessingException("Unknown session-type for session bean: " + sessionBean.getName() + " in deployment unit: " + deploymentUnit);
        }
        String beanClassName = sessionBean.getEjbClass();
        switch (sessionType) {
            case Stateless: {
                sessionBeanDescription = new StatelessComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
                break;
            }
            case Stateful: {
                sessionBeanDescription = new StatefulComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
                break;
            }
            case Singleton: {
                sessionBeanDescription = new SingletonComponentDescription(beanName, beanClassName, ejbJarDescription, deploymentUnit.getServiceName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown session bean type: " + sessionType);
            }
        }
        ejbJarDescription.getEEModuleDescription().addComponent((ComponentDescription)sessionBeanDescription);
    }
}

