/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.ha;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.ha.framework.interfaces.CachableMarshalledValue;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HAServiceKeyProvider;
import org.jboss.ha.framework.interfaces.HASingletonElectionPolicy;
import org.jboss.ha.framework.interfaces.ResponseFilter;
import org.jboss.ha.framework.server.EventFactory;
import org.jboss.ha.framework.server.HAServiceEvent;
import org.jboss.ha.framework.server.HAServiceEventFactory;
import org.jboss.ha.framework.server.HAServiceRpcHandler;
import org.jboss.ha.framework.server.HASingletonImpl;
import org.jboss.ha.framework.server.SimpleCachableMarshalledValue;
import org.jboss.modcluster.Connector;
import org.jboss.modcluster.ContainerEventHandler;
import org.jboss.modcluster.Context;
import org.jboss.modcluster.Engine;
import org.jboss.modcluster.Host;
import org.jboss.modcluster.ModClusterService;
import org.jboss.modcluster.Server;
import org.jboss.modcluster.Strings;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.advertise.AdvertiseListenerFactory;
import org.jboss.modcluster.advertise.impl.AdvertiseListenerFactoryImpl;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.config.ha.HAConfiguration;
import org.jboss.modcluster.config.ha.HAModClusterConfig;
import org.jboss.modcluster.ha.ClusteredMCMPHandler;
import org.jboss.modcluster.ha.ClusteredMCMPHandlerImpl;
import org.jboss.modcluster.ha.ClusteredResetRequestSource;
import org.jboss.modcluster.ha.HAModClusterServiceMBean;
import org.jboss.modcluster.ha.ModClusterServiceDRMEntry;
import org.jboss.modcluster.ha.rpc.ClusteredMCMPHandlerRpcHandler;
import org.jboss.modcluster.ha.rpc.DefaultRpcResponse;
import org.jboss.modcluster.ha.rpc.MCMPServerDiscoveryEvent;
import org.jboss.modcluster.ha.rpc.ModClusterServiceRpcHandler;
import org.jboss.modcluster.ha.rpc.ModClusterServiceStatus;
import org.jboss.modcluster.ha.rpc.PeerMCMPDiscoveryStatus;
import org.jboss.modcluster.ha.rpc.ResetRequestSourceRpcHandler;
import org.jboss.modcluster.ha.rpc.RpcResponse;
import org.jboss.modcluster.ha.rpc.RpcResponseFilter;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.LoadBalanceFactorProviderFactory;
import org.jboss.modcluster.load.SimpleLoadBalanceFactorProviderFactory;
import org.jboss.modcluster.mcmp.ContextFilter;
import org.jboss.modcluster.mcmp.MCMPConnectionListener;
import org.jboss.modcluster.mcmp.MCMPHandler;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPResponseParser;
import org.jboss.modcluster.mcmp.MCMPServer;
import org.jboss.modcluster.mcmp.MCMPServerState;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPHandler;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPRequestFactory;
import org.jboss.modcluster.mcmp.impl.DefaultMCMPResponseParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HAModClusterService
extends HASingletonImpl<HAServiceEvent>
implements HAModClusterServiceMBean,
ContainerEventHandler,
LoadBalanceFactorProvider,
MCMPConnectionListener,
ContextFilter {
    static final Object[] NULL_ARGS = new Object[0];
    static final Class<?>[] NULL_TYPES = new Class[0];
    static final Class<?>[] STRING_TYPES = new Class[]{String.class};
    static final Class<?>[] STOP_TYPES = new Class[]{String.class, Long.TYPE, TimeUnit.class};
    static final Class<?>[] CLUSTER_STATUS_COMPLETE_TYPES = new Class[]{Map.class};
    static final Class<?>[] GET_CLUSTER_COORDINATOR_STATE_TYPES = new Class[]{Set.class};
    final ClusteredModClusterService service;
    private final HAServiceRpcHandler<HAServiceEvent> rpcHandler;
    final ModClusterServiceRpcHandler<List<RpcResponse<ModClusterServiceStatus>>, MCMPServerState, List<RpcResponse<Boolean>>> rpcStub = new RpcStub();
    final MCMPRequestFactory requestFactory;
    private final MCMPResponseParser responseParser;
    final MCMPHandler localHandler;
    final ClusteredMCMPHandler clusteredHandler;
    final ResetRequestSource resetRequestSource;
    final Map<ClusterNode, MCMPServerDiscoveryEvent> proxyChangeDigest = new ConcurrentHashMap<ClusterNode, MCMPServerDiscoveryEvent>();
    final ModClusterServiceDRMEntry drmEntry;
    final String loadBalancingGroup;
    private final boolean masterPerLoadBalancingGroup;
    private final AtomicReference<Set<CachableMarshalledValue>> replicantView = new AtomicReference(Collections.emptySet());
    volatile int processStatusFrequency = 1;
    volatile int latestLoad;
    volatile int statusCount = 0;

    @Deprecated
    public HAModClusterService(HAPartition partition, HAModClusterConfig config, LoadBalanceFactorProvider loadBalanceFactorProvider) {
        this(config, loadBalanceFactorProvider, partition);
        this.deprecatedConstructor(new Class[]{HAPartition.class, HAModClusterConfig.class, LoadBalanceFactorProvider.class}, new Class[]{HAModClusterConfig.class, LoadBalanceFactorProvider.class, HAPartition.class});
    }

    @Deprecated
    public HAModClusterService(HAPartition partition, HAModClusterConfig config, LoadBalanceFactorProvider loadBalanceFactorProvider, HASingletonElectionPolicy electionPolicy) {
        this(config, loadBalanceFactorProvider, partition, electionPolicy);
        this.deprecatedConstructor(new Class[]{HAPartition.class, HAModClusterConfig.class, LoadBalanceFactorProvider.class, HASingletonElectionPolicy.class}, new Class[]{HAModClusterConfig.class, LoadBalanceFactorProvider.class, HAPartition.class, HASingletonElectionPolicy.class});
    }

    private void deprecatedConstructor(Class<?>[] oldConstructorArgs, Class<?>[] newConstructorArgs) {
        try {
            Constructor oldConstructor = HAModClusterService.class.getConstructor(oldConstructorArgs);
            Constructor newConstructor = HAModClusterService.class.getConstructor(newConstructorArgs);
            this.log.warn((Object)Strings.DEPRECATED.getString(oldConstructor, newConstructor));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public HAModClusterService(HAModClusterConfig config, LoadBalanceFactorProvider loadBalanceFactorProvider, HAPartition partition) {
        this(config, loadBalanceFactorProvider, partition, null);
    }

    public HAModClusterService(HAModClusterConfig config, LoadBalanceFactorProvider loadBalanceFactorProvider, HAPartition partition, HASingletonElectionPolicy electionPolicy) {
        super((EventFactory)new HAServiceEventFactory());
        this.setHAPartition(partition);
        this.setElectionPolicy(electionPolicy);
        this.rpcHandler = new RpcHandler();
        this.requestFactory = new DefaultMCMPRequestFactory();
        this.responseParser = new DefaultMCMPResponseParser();
        this.resetRequestSource = new ClusteredResetRequestSource(config, config, this.requestFactory, this, (HAServiceKeyProvider)this);
        this.localHandler = new DefaultMCMPHandler(config, this.resetRequestSource, this.requestFactory, this.responseParser);
        this.clusteredHandler = new ClusteredMCMPHandlerImpl(this.localHandler, this, (HAServiceKeyProvider)this);
        this.drmEntry = new ModClusterServiceDRMEntry(partition.getClusterNode(), null);
        this.service = new ClusteredModClusterService(config, config, config, new SimpleLoadBalanceFactorProviderFactory(loadBalanceFactorProvider), this.requestFactory, this.responseParser, this.resetRequestSource, this.clusteredHandler, new AdvertiseListenerFactoryImpl());
        this.loadBalancingGroup = config.getLoadBalancingGroup();
        this.masterPerLoadBalancingGroup = config.isMasterPerLoadBalancingGroup();
    }

    protected HAModClusterService(EventFactory<HAServiceEvent> eventFactory, HAConfiguration haConfig, NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory, HAPartition partition, HASingletonElectionPolicy electionPolicy, MCMPRequestFactory requestFactory, MCMPResponseParser responseParser, ResetRequestSource resetRequestSource, MCMPHandler localHandler, ClusteredMCMPHandler clusteredHandler, AdvertiseListenerFactory advertiseListenerFactory) {
        super(eventFactory);
        this.setHAPartition(partition);
        this.setElectionPolicy(electionPolicy);
        this.rpcHandler = new RpcHandler();
        this.requestFactory = requestFactory;
        this.responseParser = responseParser;
        this.resetRequestSource = resetRequestSource;
        this.localHandler = localHandler;
        this.clusteredHandler = clusteredHandler;
        this.drmEntry = new ModClusterServiceDRMEntry(partition.getClusterNode(), null);
        this.service = new ClusteredModClusterService(nodeConfig, balancerConfig, mcmpConfig, loadBalanceFactorProviderFactory, requestFactory, responseParser, resetRequestSource, clusteredHandler, advertiseListenerFactory);
        this.loadBalancingGroup = nodeConfig.getLoadBalancingGroup();
        this.masterPerLoadBalancingGroup = haConfig.isMasterPerLoadBalancingGroup();
    }

    @Override
    public int getProcessStatusFrequency() {
        return this.processStatusFrequency;
    }

    @Override
    public void setProcessStatusFrequency(int processStatusFrequency) {
        this.processStatusFrequency = processStatusFrequency;
    }

    @Override
    public boolean disableDomain() {
        return this.conjoin(this.rpcStub.disable(this.loadBalancingGroup));
    }

    @Override
    public boolean enableDomain() {
        return this.conjoin(this.rpcStub.enable(this.loadBalancingGroup));
    }

    @Override
    public boolean stopDomain(long timeout, TimeUnit unit) {
        return this.conjoin(this.rpcStub.stop(this.loadBalancingGroup, timeout, unit));
    }

    private boolean conjoin(List<RpcResponse<Boolean>> responses) {
        boolean success = true;
        for (RpcResponse<Boolean> response : responses) {
            Boolean result = response.getResult();
            success &= result == null || result != false;
        }
        return success;
    }

    @Override
    public Map<Host, Set<String>> getExcludedContexts() {
        return this.service.getExcludedContexts();
    }

    @Override
    public boolean isAutoEnableContexts() {
        return this.service.isAutoEnableContexts();
    }

    @Override
    public boolean isEstablished() {
        return this.service.isEstablished();
    }

    @Override
    public void connectionEstablished(InetAddress localAddress) {
        this.service.connectionEstablished(localAddress);
    }

    @Override
    public int getLoadBalanceFactor() {
        return this.service.getLoadBalanceFactor();
    }

    @Override
    public void add(Context context) {
        this.service.add(context);
    }

    @Override
    public void init(Server server) {
        this.service.init(server);
    }

    @Override
    public void remove(Context context) {
        this.service.remove(context);
    }

    @Override
    public void shutdown() {
        this.service.shutdown();
    }

    @Override
    public void start(Context context) {
        this.service.start(context);
    }

    @Override
    public void start(Server server) {
        this.service.start(server);
    }

    @Override
    public void status(Engine engine) {
        this.service.status(engine);
    }

    @Override
    public void stop(Context context) {
        this.service.stop(context);
    }

    @Override
    public void stop(Server server) {
        this.service.stop(server);
    }

    @Override
    public void addProxy(String host, int port) {
        this.service.addProxy(host, port);
    }

    @Override
    public boolean disable() {
        return this.service.disable();
    }

    @Override
    public boolean disableContext(String host, String path) {
        return this.service.disableContext(host, path);
    }

    @Override
    public Map<InetSocketAddress, String> ping() {
        return this.service.ping();
    }

    @Override
    public Map<InetSocketAddress, String> ping(String jvmRoute) {
        return this.service.ping(jvmRoute);
    }

    @Override
    public Map<InetSocketAddress, String> ping(String scheme, String hostname, int port) {
        return this.service.ping(scheme, hostname, port);
    }

    @Override
    public boolean enable() {
        return this.service.enable();
    }

    @Override
    public boolean enableContext(String host, String path) {
        return this.service.enableContext(host, path);
    }

    @Override
    public Map<InetSocketAddress, String> getProxyConfiguration() {
        return this.service.getProxyConfiguration();
    }

    @Override
    public Map<InetSocketAddress, String> getProxyInfo() {
        return this.service.getProxyInfo();
    }

    @Override
    public void refresh() {
        this.service.refresh();
    }

    @Override
    public void removeProxy(String host, int port) {
        this.service.removeProxy(host, port);
    }

    @Override
    public void reset() {
        this.service.reset();
    }

    @Override
    public boolean stop(long timeout, TimeUnit unit) {
        return this.service.stop(timeout, unit);
    }

    @Override
    public boolean stopContext(String host, String path, long timeout, TimeUnit unit) {
        return this.service.stopContext(host, path, timeout, unit);
    }

    public void startSingleton() {
        this.statusCount = this.processStatusFrequency - 1;
    }

    protected void partitionTopologyChanged(List<?> newReplicants, int newViewId, boolean merge) {
        HashSet replicants = new HashSet(newReplicants);
        Set oldReplicants = this.replicantView.getAndSet(replicants);
        super.partitionTopologyChanged(newReplicants, newViewId, merge);
        if (this.isMasterNode()) {
            oldReplicants.removeAll(replicants);
            for (CachableMarshalledValue replicant : oldReplicants) {
                ModClusterServiceDRMEntry entry = this.extractDRMEntry(replicant);
                for (String jvmRoute : entry.getJvmRoutes()) {
                    MCMPRequest request = this.requestFactory.createPingRequest(jvmRoute);
                    Map<MCMPServerState, String> responses = this.localHandler.sendRequest(request);
                    for (Map.Entry<MCMPServerState, String> response : responses.entrySet()) {
                        MCMPServerState proxy = response.getKey();
                        if (proxy.getState() != MCMPServerState.State.OK || this.responseParser.parsePingResponse(response.getValue())) continue;
                        this.log.info((Object)Strings.ENGINE_REMOVE_CRASHED.getString(jvmRoute, proxy.getSocketAddress(), entry.getPeer()));
                        this.localHandler.sendRequest(this.requestFactory.createRemoveEngineRequest(jvmRoute));
                    }
                }
            }
        }
    }

    @Inject(fromContext=FromContext.NAME)
    public void setServiceHAName(String haName) {
        super.setServiceHAName(haName);
    }

    public String getHAServiceKey() {
        String name = this.getServiceHAName();
        return this.loadBalancingGroup != null && this.masterPerLoadBalancingGroup ? name + ":" + this.loadBalancingGroup : name;
    }

    protected HAServiceRpcHandler<HAServiceEvent> getRpcHandler() {
        return this.rpcHandler;
    }

    protected Serializable getReplicant() {
        return new SimpleCachableMarshalledValue((Serializable)this.drmEntry);
    }

    protected List<ClusterNode> getElectionCandidates() {
        return this.findMasterCandidates(this.lookupDRMEntries());
    }

    List<ClusterNode> findMasterCandidates(Collection<ModClusterServiceDRMEntry> candidates) {
        if (candidates == null) {
            return null;
        }
        ArrayList<ClusterNode> narrowed = new ArrayList<ClusterNode>(candidates.size());
        ModClusterServiceDRMEntry champion = null;
        for (ModClusterServiceDRMEntry candidate : candidates) {
            if (champion == null) {
                champion = candidate;
                narrowed.add(candidate.getPeer());
                continue;
            }
            int compFactor = candidate.compareTo(champion);
            if (compFactor < 0) {
                narrowed.clear();
                champion = candidate;
                narrowed.add(candidate.getPeer());
                continue;
            }
            if (compFactor != 0) continue;
            narrowed.add(candidate.getPeer());
        }
        return narrowed;
    }

    List<ModClusterServiceDRMEntry> lookupDRMEntries() {
        DistributedReplicantManager drm = this.getHAPartition().getDistributedReplicantManager();
        List values = drm.lookupReplicants(this.getHAServiceKey());
        if (values == null) {
            return null;
        }
        ArrayList<ModClusterServiceDRMEntry> entries = new ArrayList<ModClusterServiceDRMEntry>(values.size());
        for (CachableMarshalledValue value : values) {
            entries.add(this.extractDRMEntry(value));
        }
        return entries;
    }

    ModClusterServiceDRMEntry lookupLocalDRMEntry() {
        DistributedReplicantManager drm = this.getHAPartition().getDistributedReplicantManager();
        return this.extractDRMEntry((CachableMarshalledValue)drm.lookupLocalReplicant(this.getHAServiceKey()));
    }

    void updateLocalDRM(ModClusterServiceDRMEntry entry) {
        DistributedReplicantManager drm = this.getHAPartition().getDistributedReplicantManager();
        try {
            drm.add(this.getHAServiceKey(), this.createReplicant(entry));
        }
        catch (Exception e) {
            throw Utils.convertToUnchecked(e);
        }
    }

    private Serializable createReplicant(ModClusterServiceDRMEntry entry) {
        return new SimpleCachableMarshalledValue((Serializable)entry);
    }

    private ModClusterServiceDRMEntry extractDRMEntry(CachableMarshalledValue replicant) {
        if (replicant == null) {
            return null;
        }
        try {
            Object entry = replicant.get();
            if (!(entry instanceof ModClusterServiceDRMEntry)) {
                replicant.toByteArray();
                entry = replicant.get();
            }
            return (ModClusterServiceDRMEntry)entry;
        }
        catch (Exception e) {
            throw Utils.convertToUnchecked(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClusteredModClusterService
    extends ModClusterService {
        public ClusteredModClusterService(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPHandlerConfiguration mcmpConfig, LoadBalanceFactorProviderFactory loadBalanceFactorProviderFactory, MCMPRequestFactory requestFactory, MCMPResponseParser responseParser, ResetRequestSource resetRequestSource, MCMPHandler mcmpHandler, AdvertiseListenerFactory advertiseListenerFactory) {
            super(nodeConfig, balancerConfig, mcmpConfig, loadBalanceFactorProviderFactory, requestFactory, responseParser, resetRequestSource, mcmpHandler, advertiseListenerFactory);
        }

        @Override
        public Map<InetSocketAddress, String> getProxyConfiguration() {
            if (HAModClusterService.this.isMasterNode()) {
                return super.getProxyConfiguration();
            }
            return HAModClusterService.this.rpcStub.getProxyConfiguration().getResult();
        }

        @Override
        public Map<InetSocketAddress, String> getProxyInfo() {
            if (HAModClusterService.this.isMasterNode()) {
                return super.getProxyInfo();
            }
            return HAModClusterService.this.rpcStub.getProxyInfo().getResult();
        }

        @Override
        public Map<InetSocketAddress, String> ping(String jvmRoute) {
            if (HAModClusterService.this.isMasterNode()) {
                return super.ping(jvmRoute);
            }
            return HAModClusterService.this.rpcStub.ping(jvmRoute).getResult();
        }

        @Override
        protected void establishJvmRoute(Engine engine) {
            super.establishJvmRoute(engine);
            HAModClusterService.this.drmEntry.addJvmRoute(engine.getJvmRoute());
            HAModClusterService.this.updateLocalDRM(HAModClusterService.this.drmEntry);
        }

        @Override
        protected void removeAll(Engine engine) {
            super.removeAll(engine);
            HAModClusterService.this.drmEntry.removeJvmRoute(engine.getJvmRoute());
            HAModClusterService.this.updateLocalDRM(HAModClusterService.this.drmEntry);
        }

        @Override
        public void status(Engine engine) {
            this.log.debug((Object)Strings.ENGINE_STATUS.getString(engine));
            if (this.isEstablished()) {
                Connector connector = engine.getProxyConnector();
                HAModClusterService.this.latestLoad = connector != null && connector.isAvailable() ? this.getLoadBalanceFactor() : -1;
            }
            if (HAModClusterService.this.isMasterNode()) {
                HAModClusterService.this.statusCount = (HAModClusterService.this.statusCount + 1) % HAModClusterService.this.processStatusFrequency;
                if (HAModClusterService.this.statusCount == 0) {
                    this.updateClusterStatus();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateClusterStatus() {
            Set<MCMPServerState> masterStates = null;
            HashMap<ClusterNode, MCMPServerDiscoveryEvent> latestEvents = null;
            HashMap<ClusterNode, ModClusterServiceDRMEntry> nonresponsive = new HashMap<ClusterNode, ModClusterServiceDRMEntry>();
            HashMap<String, Integer> loadBalanceFactors = new HashMap<String, Integer>();
            HashMap<ClusterNode, PeerMCMPDiscoveryStatus> statuses = new HashMap<ClusterNode, PeerMCMPDiscoveryStatus>();
            ArrayList<MCMPRequest> resetRequests = new ArrayList<MCMPRequest>();
            boolean resync = false;
            do {
                resync = false;
                HAModClusterService.this.localHandler.status();
                Map<ClusterNode, MCMPServerDiscoveryEvent> map = HAModClusterService.this.proxyChangeDigest;
                synchronized (map) {
                    masterStates = HAModClusterService.this.localHandler.getProxyStates();
                    latestEvents = new HashMap<ClusterNode, MCMPServerDiscoveryEvent>(HAModClusterService.this.proxyChangeDigest);
                }
                List<ModClusterServiceDRMEntry> replicants = HAModClusterService.this.lookupDRMEntries();
                nonresponsive.clear();
                for (ModClusterServiceDRMEntry modClusterServiceDRMEntry : replicants) {
                    nonresponsive.put(modClusterServiceDRMEntry.getPeer(), modClusterServiceDRMEntry);
                }
                nonresponsive.remove(HAModClusterService.this.getHAPartition().getClusterNode());
                List<RpcResponse<ModClusterServiceStatus>> responses = HAModClusterService.this.rpcStub.getClusterCoordinatorState(masterStates);
                resetRequests.clear();
                loadBalanceFactors.clear();
                for (String string : HAModClusterService.this.drmEntry.getJvmRoutes()) {
                    loadBalanceFactors.put(string, HAModClusterService.this.latestLoad);
                }
                statuses.clear();
                for (RpcResponse<ModClusterServiceStatus> rpcResponse : responses) {
                    if (rpcResponse == null) continue;
                    ClusterNode node = rpcResponse.getSender();
                    try {
                        ModClusterServiceDRMEntry removed;
                        ModClusterServiceStatus state = rpcResponse.getResult();
                        MCMPServerDiscoveryEvent latestEvent = (MCMPServerDiscoveryEvent)latestEvents.get(node);
                        for (MCMPServerDiscoveryEvent event : state.getUnacknowledgedEvents()) {
                            if (latestEvent != null && latestEvent.compareTo(event) >= 0) continue;
                            InetSocketAddress socketAddress = event.getMCMPServer();
                            if (event.isAddition()) {
                                HAModClusterService.this.localHandler.addProxy(socketAddress);
                            } else {
                                HAModClusterService.this.localHandler.removeProxy(socketAddress);
                            }
                            resync = true;
                        }
                        if (resync) continue;
                        statuses.put(node, new PeerMCMPDiscoveryStatus(node, state.getStates(), latestEvent));
                        List<MCMPRequest> toAdd = state.getResetRequests();
                        if (toAdd != null) {
                            resetRequests.addAll(toAdd);
                        }
                        if ((removed = (ModClusterServiceDRMEntry)nonresponsive.remove(node)) == null) continue;
                        Integer lbf = state.getLoadBalanceFactor();
                        for (String jvmRoute : removed.getJvmRoutes()) {
                            loadBalanceFactors.put(jvmRoute, lbf);
                        }
                    }
                    catch (Exception e) {
                        this.log.warn((Object)Strings.ERROR_RPC_KNOWN.getString("getClusterCoordinatorState", node), (Throwable)e);
                    }
                }
            } while (resync);
            Integer lbf = 0;
            for (Map.Entry entry : nonresponsive.entrySet()) {
                ClusterNode clusterNode = (ClusterNode)entry.getKey();
                statuses.put((ClusterNode)entry.getKey(), new PeerMCMPDiscoveryStatus(clusterNode, null, (MCMPServerDiscoveryEvent)latestEvents.get(clusterNode)));
                for (String jvmRoute : ((ModClusterServiceDRMEntry)entry.getValue()).getJvmRoutes()) {
                    loadBalanceFactors.put(jvmRoute, lbf);
                }
            }
            HAModClusterService.this.localHandler.sendRequests(resetRequests);
            ArrayList<MCMPRequest> statusRequests = new ArrayList<MCMPRequest>();
            for (Map.Entry entry : loadBalanceFactors.entrySet()) {
                statusRequests.add(HAModClusterService.this.requestFactory.createStatusRequest((String)entry.getKey(), (Integer)entry.getValue()));
            }
            HAModClusterService.this.localHandler.sendRequests(statusRequests);
            this.notifyClusterStatusComplete(masterStates, statuses);
        }

        private void notifyClusterStatusComplete(Set<MCMPServerState> masterList, Map<ClusterNode, PeerMCMPDiscoveryStatus> statuses) {
            boolean updated;
            HashSet<ModClusterServiceDRMEntry> allStatuses = new HashSet<ModClusterServiceDRMEntry>(statuses.values());
            ModClusterServiceDRMEntry ourCurrentStatus = HAModClusterService.this.lookupLocalDRMEntry();
            allStatuses.add((PeerMCMPDiscoveryStatus)ourCurrentStatus);
            ClusterNode node = HAModClusterService.this.getHAPartition().getClusterNode();
            boolean othersFirst = HAModClusterService.this.findMasterCandidates(allStatuses).contains(node);
            ModClusterServiceDRMEntry newStatus = new ModClusterServiceDRMEntry(node, masterList, HAModClusterService.this.drmEntry.getJvmRoutes());
            boolean bl = updated = !((Object)newStatus.getMCMPServerStates()).equals(ourCurrentStatus.getMCMPServerStates());
            if (othersFirst) {
                HAModClusterService.this.rpcStub.clusterStatusComplete(statuses);
            }
            if (updated) {
                HAModClusterService.this.updateLocalDRM(newStatus);
            }
            if (!othersFirst) {
                HAModClusterService.this.rpcStub.clusterStatusComplete(statuses);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RpcHandler
    extends HASingletonImpl.RpcHandler
    implements ModClusterServiceRpcHandler<RpcResponse<ModClusterServiceStatus>, MCMPServer, RpcResponse<Boolean>>,
    ClusteredMCMPHandlerRpcHandler,
    ResetRequestSourceRpcHandler<RpcResponse<List<MCMPRequest>>> {
        private final ClusterNode node;
        private final RpcResponse<Void> voidResponse;

        protected RpcHandler() {
            super((HASingletonImpl)HAModClusterService.this);
            this.node = HAModClusterService.this.getHAPartition().getClusterNode();
            this.voidResponse = new DefaultRpcResponse<Void>(this.node);
        }

        @Override
        public void clusterStatusComplete(Map<ClusterNode, PeerMCMPDiscoveryStatus> statuses) {
            ClusterNode node = HAModClusterService.this.getHAPartition().getClusterNode();
            PeerMCMPDiscoveryStatus status = statuses.get(node);
            if (status != null) {
                HAModClusterService.this.clusteredHandler.discoveryEventsReceived(status);
                HAModClusterService.this.clusteredHandler.resetCompleted();
                ModClusterServiceDRMEntry previousStatus = HAModClusterService.this.lookupLocalDRMEntry();
                if (!((Object)status.getMCMPServerStates()).equals(previousStatus.getMCMPServerStates())) {
                    try {
                        HAModClusterService.this.updateLocalDRM(new ModClusterServiceDRMEntry(node, status.getMCMPServerStates(), previousStatus.getJvmRoutes()));
                    }
                    catch (Exception e) {
                        HAModClusterService.this.log.error((Object)Strings.ERROR_DRM.getString(new Object[0]), (Throwable)e);
                    }
                }
            }
        }

        @Override
        public RpcResponse<ModClusterServiceStatus> getClusterCoordinatorState(Set<MCMPServer> masterList) {
            if (HAModClusterService.this.isMasterNode()) {
                return null;
            }
            Set<MCMPServerState> ourStates = HAModClusterService.this.clusteredHandler.updateServersFromMasterNode(masterList);
            boolean needReset = HAModClusterService.this.clusteredHandler.isResetNecessary();
            List<MCMPRequest> resetRequests = needReset ? HAModClusterService.this.resetRequestSource.getResetRequests(Collections.<String, Set<ResetRequestSource.VirtualHost>>emptyMap()) : null;
            List<MCMPServerDiscoveryEvent> events = HAModClusterService.this.clusteredHandler.getPendingDiscoveryEvents();
            DefaultRpcResponse<ModClusterServiceStatus> response = new DefaultRpcResponse<ModClusterServiceStatus>(this.node);
            response.setResult(new ModClusterServiceStatus(HAModClusterService.this.latestLoad, ourStates, events, resetRequests));
            if (needReset) {
                HAModClusterService.this.clusteredHandler.resetInitiated();
            }
            return response;
        }

        @Override
        public RpcResponse<Map<InetSocketAddress, String>> getProxyConfiguration() {
            if (!HAModClusterService.this.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<Map<InetSocketAddress, String>> response = new DefaultRpcResponse<Map<InetSocketAddress, String>>(this.node);
            response.setResult(HAModClusterService.this.getProxyConfiguration());
            return response;
        }

        @Override
        public RpcResponse<Map<InetSocketAddress, String>> getProxyInfo() {
            if (!HAModClusterService.this.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<Map<InetSocketAddress, String>> response = new DefaultRpcResponse<Map<InetSocketAddress, String>>(this.node);
            response.setResult(HAModClusterService.this.getProxyInfo());
            return response;
        }

        @Override
        public RpcResponse<Map<InetSocketAddress, String>> ping(String jvmRoute) {
            if (!HAModClusterService.this.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<Map<InetSocketAddress, String>> response = new DefaultRpcResponse<Map<InetSocketAddress, String>>(this.node);
            response.setResult(HAModClusterService.this.ping(jvmRoute));
            return response;
        }

        @Override
        public RpcResponse<Boolean> isProxyHealthOK() {
            if (!HAModClusterService.this.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<Boolean> response = new DefaultRpcResponse<Boolean>(this.node);
            response.setResult(HAModClusterService.this.localHandler.isProxyHealthOK());
            return response;
        }

        @Override
        public RpcResponse<Void> markProxiesInError() {
            if (!HAModClusterService.this.isMasterNode()) {
                return null;
            }
            HAModClusterService.this.localHandler.markProxiesInError();
            return this.voidResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RpcResponse<Void> mcmpServerDiscoveryEvent(MCMPServerDiscoveryEvent event) {
            if (!HAModClusterService.this.isMasterNode()) {
                return null;
            }
            Map<ClusterNode, MCMPServerDiscoveryEvent> map = HAModClusterService.this.proxyChangeDigest;
            synchronized (map) {
                InetSocketAddress socketAddress = event.getMCMPServer();
                if (event.isAddition()) {
                    HAModClusterService.this.localHandler.addProxy(socketAddress);
                } else {
                    HAModClusterService.this.localHandler.removeProxy(socketAddress);
                }
                HAModClusterService.this.proxyChangeDigest.put(event.getSender(), event);
                return this.voidResponse;
            }
        }

        @Override
        public RpcResponse<Void> reset() {
            if (!HAModClusterService.this.isMasterNode()) {
                return null;
            }
            HAModClusterService.this.localHandler.reset();
            return this.voidResponse;
        }

        @Override
        public RpcResponse<Map<MCMPServerState, String>> sendRequest(MCMPRequest request) {
            if (!HAModClusterService.this.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<Map<MCMPServerState, String>> response = new DefaultRpcResponse<Map<MCMPServerState, String>>(this.node);
            response.setResult(HAModClusterService.this.localHandler.sendRequest(request));
            return response;
        }

        @Override
        public RpcResponse<Map<MCMPServerState, List<String>>> sendRequests(List<MCMPRequest> requests) {
            if (!HAModClusterService.this.isMasterNode()) {
                return null;
            }
            DefaultRpcResponse<Map<MCMPServerState, List<String>>> response = new DefaultRpcResponse<Map<MCMPServerState, List<String>>>(this.node);
            response.setResult(HAModClusterService.this.localHandler.sendRequests(requests));
            return response;
        }

        @Override
        public RpcResponse<List<MCMPRequest>> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> infoResponse) {
            DefaultRpcResponse<List<MCMPRequest>> response = new DefaultRpcResponse<List<MCMPRequest>>(this.node);
            if (HAModClusterService.this.isEstablished()) {
                response.setResult(HAModClusterService.this.resetRequestSource.getResetRequests(infoResponse));
            }
            return response;
        }

        @Override
        public RpcResponse<Boolean> disable(String domain) {
            DefaultRpcResponse<Boolean> response = new DefaultRpcResponse<Boolean>(this.node);
            if (this.sameDomain(domain)) {
                response.setResult(HAModClusterService.this.service.disable());
            }
            return response;
        }

        @Override
        public RpcResponse<Boolean> enable(String domain) {
            DefaultRpcResponse<Boolean> response = new DefaultRpcResponse<Boolean>(this.node);
            if (this.sameDomain(domain)) {
                response.setResult(HAModClusterService.this.service.enable());
            }
            return response;
        }

        @Override
        public RpcResponse<Boolean> stop(String domain, long timeout, TimeUnit unit) {
            DefaultRpcResponse<Boolean> response = new DefaultRpcResponse<Boolean>(this.node);
            if (this.sameDomain(domain)) {
                response.setResult(HAModClusterService.this.service.stop(timeout, unit));
            }
            return response;
        }

        private boolean sameDomain(String domain) {
            return HAModClusterService.this.loadBalancingGroup != null ? HAModClusterService.this.loadBalancingGroup.equals(domain) : domain == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RpcStub
    implements ModClusterServiceRpcHandler<List<RpcResponse<ModClusterServiceStatus>>, MCMPServerState, List<RpcResponse<Boolean>>> {
        RpcStub() {
        }

        @Override
        public RpcResponse<Map<InetSocketAddress, String>> getProxyConfiguration() {
            try {
                return this.invokeRpc("getProxyConfiguration", NULL_ARGS, NULL_TYPES);
            }
            catch (Exception e) {
                throw Utils.convertToUnchecked(e);
            }
        }

        @Override
        public RpcResponse<Map<InetSocketAddress, String>> getProxyInfo() {
            try {
                return this.invokeRpc("getProxyInfo", NULL_ARGS, NULL_TYPES);
            }
            catch (Exception e) {
                throw Utils.convertToUnchecked(e);
            }
        }

        @Override
        public RpcResponse<Map<InetSocketAddress, String>> ping(String jvmRoute) {
            try {
                return this.invokeRpc("ping", new Object[]{jvmRoute}, STRING_TYPES);
            }
            catch (Exception e) {
                throw Utils.convertToUnchecked(e);
            }
        }

        @Override
        public void clusterStatusComplete(Map<ClusterNode, PeerMCMPDiscoveryStatus> statuses) {
            try {
                HAModClusterService.this.callMethodOnPartition("clusterStatusComplete", new Object[]{statuses}, CLUSTER_STATUS_COMPLETE_TYPES);
            }
            catch (Exception e) {
                HAModClusterService.this.log.error((Object)Strings.ERROR_STATUS_COMPLETE.getString(new Object[0]), (Throwable)e);
            }
        }

        @Override
        public List<RpcResponse<ModClusterServiceStatus>> getClusterCoordinatorState(Set<MCMPServerState> masterList) {
            try {
                return HAModClusterService.this.callMethodOnPartition("getClusterCoordinatorState", new Object[]{masterList}, GET_CLUSTER_COORDINATOR_STATE_TYPES);
            }
            catch (Exception e) {
                throw Utils.convertToUnchecked(e);
            }
        }

        private <T> RpcResponse<T> invokeRpc(String methodName, Object[] args, Class<?>[] types) throws Exception {
            ArrayList responses = HAModClusterService.this.getHAPartition().callMethodOnCluster(HAModClusterService.this.getHAServiceKey(), methodName, args, (Class[])types, false, (ResponseFilter)new RpcResponseFilter());
            Throwable thrown = null;
            for (Object obj : responses) {
                if (obj instanceof RpcResponse) {
                    return (RpcResponse)obj;
                }
                if (obj instanceof Throwable) {
                    if (thrown != null) continue;
                    thrown = (Throwable)obj;
                    continue;
                }
                HAModClusterService.this.log.warn((Object)Strings.ERROR_RPC_UNEXPECTED.getString(obj, methodName));
            }
            if (thrown != null) {
                throw Utils.convertToUnchecked(thrown);
            }
            throw new IllegalStateException(Strings.ERROR_RPC_NO_RESPONSE.getString(methodName));
        }

        @Override
        public List<RpcResponse<Boolean>> disable(String domain) {
            try {
                return HAModClusterService.this.callMethodOnPartition("disable", new Object[]{domain}, STRING_TYPES);
            }
            catch (Exception e) {
                throw Utils.convertToUnchecked(e);
            }
        }

        @Override
        public List<RpcResponse<Boolean>> enable(String domain) {
            try {
                return HAModClusterService.this.callMethodOnPartition("enable", new Object[]{domain}, STRING_TYPES);
            }
            catch (Exception e) {
                throw Utils.convertToUnchecked(e);
            }
        }

        @Override
        public List<RpcResponse<Boolean>> stop(String domain, long timeout, TimeUnit unit) {
            try {
                return HAModClusterService.this.callMethodOnPartition("stop", new Object[]{domain, timeout, unit}, STOP_TYPES);
            }
            catch (Exception e) {
                throw Utils.convertToUnchecked(e);
            }
        }
    }
}

