/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.role;

import java.security.Principal;
import java.util.Map;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.mapping.providers.role.AbstractRolesMappingProvider;
import org.jboss.security.mapping.providers.role.Util;
import org.jboss.security.plugins.TransactionManagerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseRolesMappingProvider
extends AbstractRolesMappingProvider {
    protected String dsJndiName;
    protected String rolesQuery;
    protected boolean suspendResume = true;
    protected String TX_MGR_JNDI_NAME = "java:/TransactionManager";
    protected TransactionManager tm = null;

    @Override
    public void init(Map<String, Object> options) {
        this.log = Logger.getLogger(this.getClass());
        if (options != null) {
            this.dsJndiName = (String)options.get("dsJndiName");
            if (this.dsJndiName == null) {
                throw new IllegalArgumentException("Datasource JNDI name can't be null");
            }
            this.rolesQuery = (String)options.get("rolesQuery");
            if (this.rolesQuery == null) {
                throw new IllegalArgumentException("Prepared statement can't be null");
            }
            String option = (String)options.get("suspendResume");
            if (option != null) {
                this.suspendResume = Boolean.valueOf(option.toString());
            }
            if ((option = (String)options.get("transactionManagerJndiName")) != null) {
                this.TX_MGR_JNDI_NAME = option;
            }
            try {
                if (this.suspendResume) {
                    this.tm = this.getTransactionManager();
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Unable to get Transaction Manager", e);
            }
        }
    }

    @Override
    public void performMapping(Map<String, Object> map, RoleGroup mappedObject) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Context Map is null or empty");
        }
        Principal principal = this.getCallerPrincipal(map);
        if (principal != null && this.rolesQuery != null) {
            String username = principal.getName();
            Util.addRolesToGroup(username, mappedObject, this.dsJndiName, this.rolesQuery, this.log, this.suspendResume, this.tm);
            this.result.setMappedObject(mappedObject);
        }
    }

    protected TransactionManager getTransactionManager() throws NamingException {
        TransactionManagerLocator tml = new TransactionManagerLocator();
        return tml.getTM(this.TX_MGR_JNDI_NAME);
    }
}

