/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.Logger;
import org.jboss.security.config.parser.StaxBasedConfigParser;
import org.picketbox.config.SecurityActions;
import org.picketbox.exceptions.ConfigurationFileNullException;
import org.picketbox.exceptions.ConfigurationParsingException;
import org.picketbox.exceptions.ConfigurationStreamNullException;
import org.xml.sax.SAXException;

public class PicketBoxConfiguration {
    private static Logger log = Logger.getLogger(PicketBoxConfiguration.class);

    public void load(String configFileName) throws ConfigurationFileNullException, ConfigurationParsingException {
        if (configFileName == null) {
            throw new ConfigurationFileNullException("configFileName is null");
        }
        InputStream configStream = this.loadStream(configFileName);
        this.load(configStream);
    }

    public void load(InputStream configStream) throws ConfigurationStreamNullException, ConfigurationParsingException {
        if (configStream == null) {
            throw new ConfigurationStreamNullException("configStream is null");
        }
        StaxBasedConfigParser parser = new StaxBasedConfigParser();
        try {
            parser.parse(configStream);
        }
        catch (XMLStreamException e) {
            throw new ConfigurationParsingException(e);
        }
        catch (SAXException s) {
            throw new ConfigurationParsingException(s);
        }
        catch (IOException i) {
            throw new ConfigurationParsingException(i);
        }
    }

    private InputStream loadStream(String configFileName) {
        InputStream configStream;
        block10: {
            block9: {
                block8: {
                    configStream = null;
                    try {
                        ClassLoader tcl = SecurityActions.getContextClassLoader();
                        configStream = tcl.getResourceAsStream(configFileName);
                    }
                    catch (Exception e) {
                        if (!log.isTraceEnabled()) break block8;
                        log.error((Object)("Exception loading " + configFileName + " as tcl resource"), (Throwable)e);
                    }
                }
                try {
                    if (configStream == null) {
                        configStream = SecurityActions.getClassLoader(this.getClass()).getResourceAsStream(configFileName);
                    }
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) break block9;
                    log.error((Object)("Exception loading " + configFileName + " as cl resource"), (Throwable)e);
                }
            }
            try {
                if (configStream == null) {
                    URL url = new URL(configFileName);
                    configStream = url.openStream();
                }
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block10;
                log.error((Object)("Exception loading " + configFileName + " as URL resource"), (Throwable)e);
            }
        }
        return configStream;
    }
}

