/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.util.Locale;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardWrapper;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ServletDeploymentStats {
    static final DescriptionProvider provider = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode();
        }
    };

    public static void register(ManagementResourceRegistration registration) {
        registration.registerMetric("load-time", (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, Wrapper wrapper) {
                response.set(((StandardWrapper)wrapper).getLoadTime());
            }
        });
        registration.registerMetric("max-time", (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, Wrapper wrapper) {
                response.set(((StandardWrapper)wrapper).getMinTime());
            }
        });
        registration.registerMetric("min-time", (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, Wrapper wrapper) {
                response.set(((StandardWrapper)wrapper).getLoadTime());
            }
        });
        registration.registerMetric("processing-time", (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, Wrapper wrapper) {
                response.set(((StandardWrapper)wrapper).getProcessingTime());
            }
        });
        registration.registerMetric("request-count", (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, Wrapper wrapper) {
                response.set(((StandardWrapper)wrapper).getRequestCount());
            }
        });
    }

    static abstract class AbstractMetricsHandler
    implements OperationStepHandler {
        AbstractMetricsHandler() {
        }

        abstract void handle(ModelNode var1, String var2, Wrapper var3);

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource web = context.getRootResource().navigate(address.subAddress(0, address.size() - 1));
            ModelNode subModel = web.getModel();
            final String host = subModel.require("virtual-host").asString();
            final String path = subModel.require("context-root").asString();
            final ModelNode node = web.requireChild(address.getLastElement()).getModel();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(WebSubsystemServices.deploymentServiceName(host, path));
                    if (controller != null) {
                        String name = node.get("servlet-name").asString();
                        Context webContext = (Context)Context.class.cast(controller.getValue());
                        Wrapper wrapper = (Wrapper)Wrapper.class.cast(webContext.findChild(name));
                        AbstractMetricsHandler.this.handle(context.getResult(), address.getLastElement().getValue(), wrapper);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep();
        }
    }
}

