/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;

public class StatefulComponentSessionIdGeneratingInterceptorFactory
implements InterceptorFactory {
    private final Object sessionIdContextKey;

    public StatefulComponentSessionIdGeneratingInterceptorFactory(Object sessionIdContextKey) {
        this.sessionIdContextKey = sessionIdContextKey;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        AtomicReference<Serializable> sessionIdReference = new AtomicReference<Serializable>();
        context.getContextData().put(this.sessionIdContextKey, sessionIdReference);
        Serializable id = (Serializable)context.getContextData().get(StatefulSessionComponent.SESSION_ATTACH_KEY);
        if (id == null) {
            return new StatefulComponentSessionIdGeneratingInterceptor(sessionIdReference);
        }
        sessionIdReference.set(id);
        return Interceptors.getTerminalInterceptor();
    }

    private class StatefulComponentSessionIdGeneratingInterceptor
    implements Interceptor {
        private final AtomicReference<Serializable> sessionIdReference;

        StatefulComponentSessionIdGeneratingInterceptor(AtomicReference<Serializable> sessionIdReference) {
            this.sessionIdReference = sessionIdReference;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            Component component = (Component)context.getPrivateData(Component.class);
            if (!(component instanceof StatefulSessionComponent)) {
                throw new IllegalStateException("Unexpected component: " + component + " Expected " + StatefulSessionComponent.class);
            }
            StatefulSessionComponent statefulComponent = (StatefulSessionComponent)component;
            StatefulSessionComponentInstance statefulSessionComponentInstance = (StatefulSessionComponentInstance)statefulComponent.getCache().create();
            this.sessionIdReference.set(statefulSessionComponentInstance.getId());
            return context.proceed();
        }
    }
}

