/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.ejb3.deployment.processors.AroundTimeoutAnnotationParsingProcessor;
import org.jboss.as.ejb3.deployment.processors.TimerServiceDeploymentProcessor;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemDescriptions;
import org.jboss.as.ejb3.timerservice.TimerServiceFactoryService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.services.path.AbsolutePathService;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class TimerServiceAdd
extends AbstractBoottimeAddStepHandler
implements DescriptionProvider {
    private static final Logger logger = Logger.getLogger(TimerServiceAdd.class);
    public static final TimerServiceAdd INSTANCE = new TimerServiceAdd();

    protected void populateModel(ModelNode operation, ModelNode timerServiceModel) throws OperationFailedException {
        if (operation.hasDefined("max-threads")) {
            int maxThreads = operation.get("max-threads").asInt();
            if (maxThreads <= 0) {
                throw new IllegalArgumentException("Invalid value: " + maxThreads + " for " + "max-threads");
            }
            timerServiceModel.get("max-threads").set(maxThreads);
        }
        if (operation.hasDefined("core-threads")) {
            int coreThreads = operation.get("core-threads").asInt();
            if (coreThreads <= 0) {
                throw new IllegalArgumentException("Invalid value: " + coreThreads + " for " + "core-threads");
            }
            timerServiceModel.get("core-threads").set(coreThreads);
        }
        if (operation.hasDefined("relative-to")) {
            String relativeTo = operation.get("relative-to").asString();
            timerServiceModel.get("relative-to").set(relativeTo);
        }
        if (operation.hasDefined("path")) {
            String dataDir = operation.get("path").asString();
            timerServiceModel.get("path").set(dataDir);
        }
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, final ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        boolean lite;
        ModelNode rootResource = context.getRootResource().getChild(PathElement.pathElement((String)"subsystem", (String)"ejb3")).getModel();
        boolean bl = lite = rootResource.hasDefined("lite") && rootResource.get("lite").asBoolean();
        if (!lite) {
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                protected void execute(DeploymentProcessorTarget processorTarget) {
                    String relativeTo;
                    logger.debug((Object)"Configuring timers");
                    ModelNode timerServiceModel = model;
                    ModelNode pathNode = timerServiceModel.get("path");
                    String path = pathNode.isDefined() ? pathNode.asString() : null;
                    ModelNode relativeToNode = timerServiceModel.get("relative-to");
                    String string = relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
                    if (path != null) {
                        if (relativeTo != null) {
                            RelativePathService.addService((ServiceName)TimerServiceFactoryService.PATH_SERVICE_NAME, (String)path, (String)relativeTo, (ServiceTarget)context.getServiceTarget());
                        } else {
                            AbsolutePathService.addService((ServiceName)TimerServiceFactoryService.PATH_SERVICE_NAME, (String)path, (ServiceTarget)context.getServiceTarget());
                        }
                    }
                    int coreThreadCount = timerServiceModel.get("core-threads").asInt(0);
                    int maxThreadCount = timerServiceModel.get("max-threads").asInt(Runtime.getRuntime().availableProcessors());
                    processorTarget.addDeploymentProcessor(Phase.PARSE, 13312, (DeploymentUnitProcessor)new AroundTimeoutAnnotationParsingProcessor());
                    processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 7424, (DeploymentUnitProcessor)new TimerServiceDeploymentProcessor(coreThreadCount, maxThreadCount, true));
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return EJB3SubsystemDescriptions.getTimerServiceAddDescription(locale);
    }
}

