/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.engine.jdbc.internal.proxy.AbstractProxyHandler;
import org.hibernate.engine.jdbc.spi.JdbcResourceRegistry;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public abstract class AbstractResultSetProxyHandler
extends AbstractProxyHandler {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractResultSetProxyHandler.class.getName());
    private ResultSet resultSet;

    public AbstractResultSetProxyHandler(ResultSet resultSet) {
        super(resultSet.hashCode());
        this.resultSet = resultSet;
    }

    protected abstract JdbcServices getJdbcServices();

    protected abstract JdbcResourceRegistry getResourceRegistry();

    protected abstract Statement getExposableStatement();

    protected final ResultSet getResultSet() {
        this.errorIfInvalid();
        return this.resultSet;
    }

    protected final ResultSet getResultSetWithoutChecks() {
        return this.resultSet;
    }

    @Override
    protected Object continueInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Handling invocation of ResultSet method [" + methodName + "]");
        }
        if ("close".equals(methodName)) {
            this.explicitClose((ResultSet)proxy);
            return null;
        }
        if ("invalidate".equals(methodName)) {
            this.invalidateHandle();
            return null;
        }
        this.errorIfInvalid();
        if ("isWrapperFor".equals(methodName) && args.length == 1) {
            return method.invoke((Object)this.getResultSetWithoutChecks(), args);
        }
        if ("unwrap".equals(methodName) && args.length == 1) {
            return method.invoke((Object)this.getResultSetWithoutChecks(), args);
        }
        if ("getWrappedObject".equals(methodName)) {
            return this.getResultSetWithoutChecks();
        }
        if ("getStatement".equals(methodName)) {
            return this.getExposableStatement();
        }
        try {
            return method.invoke((Object)this.resultSet, args);
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (SQLException.class.isInstance(realException)) {
                throw this.getJdbcServices().getSqlExceptionHelper().convert((SQLException)realException, realException.getMessage());
            }
            throw realException;
        }
    }

    private void explicitClose(ResultSet proxy) {
        if (this.isValid()) {
            this.getResourceRegistry().release(proxy);
        }
    }

    protected void invalidateHandle() {
        this.resultSet = null;
        this.invalidate();
    }
}

