/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.event.internal.ProxyVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class WrapVisitor
extends ProxyVisitor {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)WrapVisitor.class.getName());
    boolean substitute = false;

    boolean isSubstitutionRequired() {
        return this.substitute;
    }

    WrapVisitor(EventSource session) {
        super(session);
    }

    @Override
    Object processCollection(Object collection, CollectionType collectionType) throws HibernateException {
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)collection;
            EventSource session = this.getSession();
            if (coll.setCurrentSession(session)) {
                this.reattachCollection(coll, collectionType);
            }
            return null;
        }
        return this.processArrayOrNewCollection(collection, collectionType);
    }

    final Object processArrayOrNewCollection(Object collection, CollectionType collectionType) throws HibernateException {
        EventSource session = this.getSession();
        if (collection == null) {
            return null;
        }
        CollectionPersister persister = session.getFactory().getCollectionPersister(collectionType.getRole());
        PersistenceContext persistenceContext = session.getPersistenceContext();
        if (collectionType.hasHolder()) {
            if (collection == CollectionType.UNFETCHED_COLLECTION) {
                return null;
            }
            PersistentCollection ah = persistenceContext.getCollectionHolder(collection);
            if (ah == null) {
                ah = collectionType.wrap(session, collection);
                persistenceContext.addNewCollection(persister, ah);
                persistenceContext.addCollectionHolder(ah);
            }
            return null;
        }
        PersistentCollection persistentCollection = collectionType.wrap(session, collection);
        persistenceContext.addNewCollection(persister, persistentCollection);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Wrapped collection in role: " + collectionType.getRole());
        }
        return persistentCollection;
    }

    @Override
    void processValue(int i, Object[] values, Type[] types) {
        Object result = this.processValue(values[i], types[i]);
        if (result != null) {
            this.substitute = true;
            values[i] = result;
        }
    }

    @Override
    Object processComponent(Object component, CompositeType componentType) throws HibernateException {
        if (component != null) {
            Object[] values = componentType.getPropertyValues(component, this.getSession());
            Type[] types = componentType.getSubtypes();
            boolean substituteComponent = false;
            for (int i = 0; i < types.length; ++i) {
                Object result = this.processValue(values[i], types[i]);
                if (result == null) continue;
                values[i] = result;
                substituteComponent = true;
            }
            if (substituteComponent) {
                componentType.setPropertyValues(component, values, EntityMode.POJO);
            }
        }
        return null;
    }

    @Override
    void process(Object object, EntityPersister persister) throws HibernateException {
        Object[] values = persister.getPropertyValues(object);
        Type[] types = persister.getPropertyTypes();
        this.processEntityPropertyValues(values, types);
        if (this.isSubstitutionRequired()) {
            persister.setPropertyValues(object, values);
        }
    }
}

