/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.BasicServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.StandardServiceInitiators;
import org.hibernate.service.internal.BasicServiceRegistryImpl;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.spi.BasicServiceInitiator;

public class ServiceRegistryBuilder {
    public static final String DEFAULT_CFG_RESOURCE_NAME = "hibernate.cfg.xml";
    private final Map settings;
    private final List<BasicServiceInitiator> initiators = ServiceRegistryBuilder.standardInitiatorList();
    private final List<ProvidedService> providedServices = new ArrayList<ProvidedService>();

    public ServiceRegistryBuilder() {
        this(Environment.getProperties());
    }

    public ServiceRegistryBuilder(Map settings) {
        this.settings = settings;
    }

    private static List<BasicServiceInitiator> standardInitiatorList() {
        ArrayList<BasicServiceInitiator> initiators = new ArrayList<BasicServiceInitiator>();
        initiators.addAll(StandardServiceInitiators.LIST);
        return initiators;
    }

    public ServiceRegistryBuilder configure() {
        return this.configure(DEFAULT_CFG_RESOURCE_NAME);
    }

    public ServiceRegistryBuilder configure(String resourceName) {
        return this;
    }

    public ServiceRegistryBuilder applySetting(String settingName, Object value) {
        this.settings.put(settingName, value);
        return this;
    }

    public ServiceRegistryBuilder applySettings(Map settings) {
        this.settings.putAll(settings);
        return this;
    }

    public ServiceRegistryBuilder addInitiator(BasicServiceInitiator initiator) {
        this.initiators.add(initiator);
        return this;
    }

    public ServiceRegistryBuilder addService(Class serviceRole, Service service) {
        this.providedServices.add(new ProvidedService<Service>(serviceRole, service));
        return this;
    }

    public BasicServiceRegistry buildServiceRegistry() {
        HashMap settingsCopy = new HashMap();
        settingsCopy.putAll(this.settings);
        Environment.verifyProperties(settingsCopy);
        ConfigurationHelper.resolvePlaceHolders(settingsCopy);
        return new BasicServiceRegistryImpl(this.initiators, this.providedServices, settingsCopy);
    }

    public static void destroy(BasicServiceRegistry serviceRegistry) {
        ((BasicServiceRegistryImpl)serviceRegistry).destroy();
    }
}

