/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class ModuleInformationServiceProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.hasAttachment(Attachments.OSGI_MANIFEST)) {
            return;
        }
        ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleIdentifier moduleIdentifier = deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
        List<AdditionalModuleSpecification> additionalModules = deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_MODULES);
        if (moduleIdentifier == null || moduleSpec == null) {
            return;
        }
        phaseContext.getServiceTarget().addService(ServiceModuleLoader.moduleInformationServiceName(moduleIdentifier), (Service)new ValueService((Value)new ImmediateValue((Object)moduleSpec))).install();
        for (ModuleDependency dependency : moduleSpec.getAllDependencies()) {
            if (!dependency.getIdentifier().getName().startsWith("deployment.")) continue;
            phaseContext.addDependency(ServiceModuleLoader.moduleInformationServiceName(dependency.getIdentifier()), Attachments.MODULE_DEPENDENCY_INFORMATION);
        }
        for (AdditionalModuleSpecification module : additionalModules) {
            phaseContext.getServiceTarget().addService(ServiceModuleLoader.moduleInformationServiceName(module.getModuleIdentifier()), (Service)new ValueService((Value)new ImmediateValue((Object)module))).install();
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

