/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.ManagedReferenceMethodInjectionInterceptorFactory;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.value.Value;

public final class MethodInjectionTarget
extends InjectionTarget {
    public MethodInjectionTarget(String className, String name, String paramType) {
        super(className, name, paramType);
    }

    @Override
    public InterceptorFactory createInjectionInterceptorFactory(Object targetContextKey, Object valueContextKey, Value<ManagedReferenceFactory> factoryValue, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        ClassReflectionIndex classIndex;
        String name = this.getName();
        String className = this.getClassName();
        String paramType = this.getDeclaredValueClassName();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        try {
            classIndex = reflectionIndex.getClassIndex(Class.forName(className, false, (ClassLoader)classLoader));
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        Collection methods = paramType != null ? ClassReflectionIndexUtil.findMethods((DeploymentReflectionIndex)reflectionIndex, (ClassReflectionIndex)classIndex, (String)name, (String[])new String[]{paramType}) : ClassReflectionIndexUtil.findAllMethods((DeploymentReflectionIndex)reflectionIndex, (ClassReflectionIndex)classIndex, (String)name, (int)1);
        Iterator iterator = methods.iterator();
        if (!iterator.hasNext()) {
            throw new DeploymentUnitProcessingException("No matching method found for method " + name + paramType != null ? "(" + paramType + ")" : " on " + className);
        }
        Method method = (Method)iterator.next();
        if (iterator.hasNext()) {
            throw new DeploymentUnitProcessingException("More than one matching method found for method '" + name + paramType != null ? "(" + paramType + ")" : " on " + className);
        }
        return new ManagedReferenceMethodInjectionInterceptorFactory(targetContextKey, valueContextKey, factoryValue, method);
    }
}

