/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ds;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.JCAMetadata;
import org.jboss.jca.common.api.metadata.ValidatableMetadata;

public interface Driver
extends JCAMetadata,
ValidatableMetadata {
    public String getName();

    public Integer getMajorVersion();

    public Integer getMinorVersion();

    public String getModule();

    public String getDriverClass();

    public String getDataSourceClass();

    public String getXaDataSourceClass();

    public static enum Attribute {
        NAME("name"),
        MAJOR_VERSION("major-version"),
        MINOR_VERSION("minor-version"),
        MODULE("module");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        DRIVERCLASS("driver-class"),
        DATASOURCECLASS("datasource-class"),
        XADATASOURCECLASS("xa-datasource-class");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

