/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RehashControlCommand
extends BaseRpcCommand {
    public static final int COMMAND_ID = 17;
    Type type;
    Address sender;
    int viewId;
    Map<Object, InternalCacheValue> state;
    ConsistentHash oldCH;
    ConsistentHash newCH;
    DistributionManager distributionManager;
    Transport transport;
    Configuration configuration;
    DataContainer dataContainer;
    CommandsFactory commandsFactory;
    private static final Log log = LogFactory.getLog(RehashControlCommand.class);

    public RehashControlCommand() {
    }

    public RehashControlCommand(String cacheName, Type type, Address sender, int viewId, Map<Object, InternalCacheValue> state, ConsistentHash oldConsistentHash, ConsistentHash consistentHash) {
        super(cacheName);
        this.type = type;
        this.sender = sender;
        this.viewId = viewId;
        this.state = state;
        this.oldCH = oldConsistentHash;
        this.newCH = consistentHash;
    }

    public RehashControlCommand(String cacheName, Type type, Address sender, int viewId) {
        super(cacheName);
        this.type = type;
        this.sender = sender;
        this.viewId = viewId;
    }

    public RehashControlCommand(Transport transport) {
        this.transport = transport;
    }

    public void init(DistributionManager distributionManager, Configuration configuration, DataContainer dataContainer, CommandsFactory commandsFactory) {
        if (!configuration.getCacheMode().isDistributed()) {
            log.rehashCommandReceivedOnNonDistributedCache();
            throw new IllegalStateException("Rehash command received on non-distributed cache");
        }
        this.distributionManager = distributionManager;
        this.configuration = configuration;
        this.dataContainer = dataContainer;
        this.commandsFactory = commandsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        LogFactory.pushNDC(this.configuration.getName(), log.isTraceEnabled());
        try {
            switch (this.type) {
                case APPLY_STATE: {
                    this.distributionManager.applyState(this.newCH, this.state, this.sender, this.viewId);
                    Object var2_2 = null;
                    return var2_2;
                }
                case NODE_PUSH_COMPLETED: {
                    this.distributionManager.markNodePushCompleted(this.viewId, this.sender);
                    Object var2_3 = null;
                    return var2_3;
                }
                case REHASH_COMPLETED: {
                    this.distributionManager.markRehashCompleted(this.viewId);
                    Object var2_4 = null;
                    return var2_4;
                }
            }
            throw new CacheException("Unknown rehash control command type " + (Object)((Object)this.type));
        }
        finally {
            LogFactory.popNDC(log.isTraceEnabled());
        }
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public byte getCommandId() {
        return 17;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.cacheName, (byte)this.type.ordinal(), this.sender, this.viewId, this.state, this.oldCH, this.newCH};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.cacheName = (String)parameters[i++];
        this.type = Type.values()[(Byte)parameters[i++]];
        this.sender = (Address)parameters[i++];
        this.viewId = (Integer)parameters[i++];
        this.state = (Map)parameters[i++];
        this.oldCH = (ConsistentHash)parameters[i++];
        this.newCH = (ConsistentHash)parameters[i++];
    }

    @Override
    public String toString() {
        return "RehashControlCommand{cache=" + this.cacheName + ", type=" + (Object)((Object)this.type) + ", sender=" + this.sender + ", viewId=" + this.viewId + ", state=" + (this.state == null ? "N/A" : Integer.valueOf(this.state.size())) + ", oldConsistentHash=" + this.oldCH + ", consistentHash=" + this.newCH + '}';
    }

    public static enum Type {
        APPLY_STATE,
        NODE_PUSH_COMPLETED,
        REHASH_COMPLETED;

    }
}

