/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.jgroups.annotations.Experimental;
import org.jgroups.blocks.Cache;
import org.jgroups.blocks.GridFilesystem;
import org.jgroups.blocks.ReplCache;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

@Experimental
public class GridFile
extends File {
    private static final long serialVersionUID = -6729548421029004260L;
    private final ReplCache<String, Metadata> cache;
    private final GridFilesystem fs;
    private final String name;
    private int chunk_size;

    GridFile(String pathname, ReplCache<String, Metadata> cache, int chunk_size, GridFilesystem fs) {
        super(pathname);
        this.fs = fs;
        this.name = GridFile.trim(pathname);
        this.cache = cache;
        this.chunk_size = chunk_size;
        this.initMetadata();
    }

    GridFile(String parent, String child, ReplCache<String, Metadata> cache, int chunk_size, GridFilesystem fs) {
        super(parent, child);
        this.fs = fs;
        this.name = GridFile.trim(parent + File.separator + child);
        this.cache = cache;
        this.chunk_size = chunk_size;
        this.initMetadata();
    }

    GridFile(File parent, String child, ReplCache<String, Metadata> cache, int chunk_size, GridFilesystem fs) {
        super(parent, child);
        this.fs = fs;
        this.name = GridFile.trim(parent.getAbsolutePath() + File.separator + child);
        this.cache = cache;
        this.chunk_size = chunk_size;
        this.initMetadata();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        int index;
        String my_path = super.getPath();
        if (my_path != null && my_path.endsWith(File.separator) && (index = my_path.lastIndexOf(File.separator)) != -1) {
            my_path = my_path.substring(0, index);
        }
        return my_path;
    }

    @Override
    public long length() {
        Metadata metadata = this.cache.get(this.getPath());
        if (metadata != null) {
            return metadata.length;
        }
        return 0L;
    }

    void setLength(int new_length) {
        Metadata metadata = this.cache.get(this.getPath());
        if (metadata != null) {
            metadata.length = new_length;
            metadata.setModificationTime(System.currentTimeMillis());
            this.cache.put(this.getPath(), metadata, (short)-1, 0L, false);
        } else {
            System.err.println("metadata for " + this.getPath() + " not found !");
        }
    }

    public int getChunkSize() {
        return this.chunk_size;
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (this.exists()) {
            return true;
        }
        if (!this.checkParentDirs(this.getPath(), false)) {
            return false;
        }
        this.cache.put(this.getPath(), new Metadata(0, System.currentTimeMillis(), this.chunk_size, 1), (short)-1, 0L, true);
        return true;
    }

    @Override
    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean synchronous) {
        if (!this.exists()) {
            return false;
        }
        if (this.isFile()) {
            this.fs.remove(this.getPath(), synchronous);
            this.cache.remove(this.getPath(), synchronous);
            return true;
        }
        if (this.isDirectory()) {
            File[] files = this.listFiles();
            if (files != null && files.length > 0) {
                return false;
            }
            this.fs.remove(this.getPath(), synchronous);
            this.cache.remove(this.getPath(), synchronous);
        }
        return true;
    }

    @Override
    public boolean mkdir() {
        try {
            boolean parents_exist = this.checkParentDirs(this.getPath(), false);
            if (!parents_exist) {
                return false;
            }
            this.cache.put(this.getPath(), new Metadata(0, System.currentTimeMillis(), this.chunk_size, 2), (short)-1, 0L, true);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        try {
            boolean parents_exist = this.checkParentDirs(this.getPath(), true);
            if (!parents_exist) {
                return false;
            }
            this.cache.put(this.getPath(), new Metadata(0, System.currentTimeMillis(), this.chunk_size, 2), (short)-1, 0L, true);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean exists() {
        return this.cache.get(this.getPath()) != null;
    }

    @Override
    public String[] list() {
        return this.list(null);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        return this._list(filter);
    }

    @Override
    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        return this._listFiles(filter);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        return this._listFiles(filter);
    }

    @Override
    public boolean isDirectory() {
        Metadata val = this.cache.get(this.getPath());
        return val.isDirectory();
    }

    @Override
    public boolean isFile() {
        Metadata val = this.cache.get(this.getPath());
        return val.isFile();
    }

    protected void initMetadata() {
        Metadata metadata = this.cache.get(this.getPath());
        if (metadata != null) {
            this.chunk_size = metadata.getChunkSize();
        }
    }

    protected File[] _listFiles(Object filter) {
        String[] files = this._list(filter);
        File[] retval = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            retval[i] = new GridFile(files[i], this.cache, this.chunk_size, this.fs);
        }
        return retval;
    }

    protected String[] _list(Object filter) {
        Cache<String, ReplCache.Value<Metadata>> internal_cache = this.cache.getL2Cache();
        Set keys = internal_cache.getInternalMap().keySet();
        if (keys == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(keys.size());
        for (String str : keys) {
            if (!GridFile.isChildOf(this.getPath(), str) || filter instanceof FilenameFilter && !((FilenameFilter)filter).accept(new File(this.name), GridFile.filename(str)) || filter instanceof FileFilter && !((FileFilter)filter).accept(new File(str))) continue;
            list.add(str);
        }
        String[] retval = new String[list.size()];
        int index = 0;
        for (String tmp : list) {
            retval[index++] = tmp;
        }
        return retval;
    }

    protected static boolean isChildOf(String parent, String child) {
        if (parent == null || child == null) {
            return false;
        }
        if (!child.startsWith(parent)) {
            return false;
        }
        if (child.length() <= parent.length()) {
            return false;
        }
        int from = parent.equals(File.separator) ? parent.length() : parent.length() + 1;
        String[] comps = Util.components(child.substring(from), File.separator);
        return comps != null && comps.length <= 1;
    }

    protected static String filename(String full_path) {
        String[] comps = Util.components(full_path, File.separator);
        return comps != null ? comps[comps.length - 1] : null;
    }

    protected boolean checkParentDirs(String path, boolean create_if_absent) throws IOException {
        String[] components = Util.components(path, File.separator);
        if (components == null) {
            return false;
        }
        if (components.length == 1) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < components.length - 1; ++i) {
            String tmp = components[i];
            if (!tmp.equals(File.separator)) {
                if (first) {
                    first = false;
                } else {
                    sb.append(File.separator);
                }
            }
            sb.append(tmp);
            String comp = sb.toString();
            if (this.exists(comp)) {
                if (!this.isFile(comp)) continue;
                throw new IOException("cannot create " + path + " as component " + comp + " is a file");
            }
            if (create_if_absent) {
                this.cache.put(comp, new Metadata(0, System.currentTimeMillis(), this.chunk_size, 2), (short)-1, 0L);
                continue;
            }
            return false;
        }
        return true;
    }

    protected static String trim(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).equals(File.separator)) {
            return str;
        }
        String[] comps = Util.components(str, File.separator);
        return comps != null && comps.length > 0 ? comps[comps.length - 1] : null;
    }

    private boolean exists(String key) {
        return this.cache.get(key) != null;
    }

    private boolean isFile(String key) {
        Metadata val = this.cache.get(key);
        return val.isFile();
    }

    public static class Metadata
    implements Streamable {
        public static final byte FILE = 1;
        public static final byte DIR = 2;
        private int length = 0;
        private long modification_time = 0L;
        private int chunk_size = 0;
        private byte flags = 0;

        public Metadata() {
        }

        public Metadata(int length, long modification_time, int chunk_size, byte flags) {
            this.length = length;
            this.modification_time = modification_time;
            this.chunk_size = chunk_size;
            this.flags = flags;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public long getModificationTime() {
            return this.modification_time;
        }

        public void setModificationTime(long modification_time) {
            this.modification_time = modification_time;
        }

        public int getChunkSize() {
            return this.chunk_size;
        }

        public boolean isFile() {
            return Util.isFlagSet(this.flags, (byte)1);
        }

        public boolean isDirectory() {
            return Util.isFlagSet(this.flags, (byte)2);
        }

        public String toString() {
            boolean is_file = Util.isFlagSet(this.flags, (byte)1);
            StringBuilder sb = new StringBuilder();
            sb.append(this.getType());
            if (is_file) {
                sb.append(", len=" + Util.printBytes(this.length) + ", chunk_size=" + this.chunk_size);
            }
            sb.append(", mod_time=" + new Date(this.modification_time));
            return sb.toString();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.length);
            out.writeLong(this.modification_time);
            out.writeInt(this.chunk_size);
            out.writeByte(this.flags);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.length = in.readInt();
            this.modification_time = in.readLong();
            this.chunk_size = in.readInt();
            this.flags = in.readByte();
        }

        private String getType() {
            if (Util.isFlagSet(this.flags, (byte)1)) {
                return "file";
            }
            if (Util.isFlagSet(this.flags, (byte)2)) {
                return "dir";
            }
            return "n/a";
        }
    }
}

