/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.as.server.services.net.NetworkInterfaceService;

public class LocalHostControllerInfoImpl
implements LocalHostControllerInfo {
    private final ControlledProcessState processState;
    private String localHostName;
    private boolean master;
    private String nativeManagementInterface;
    private int nativeManagementPort;
    private Map<String, ParsedInterfaceCriteria> parsedInterfaceCriteria = new HashMap<String, ParsedInterfaceCriteria>();
    private ContentRepository contentRepository;
    private String remoteDcHost;
    private int remoteDcPort;
    private String remoteSecurityRealm;
    private String httpManagementInterface;
    private int httpManagementPort;
    private int httpManagementSecurePort;
    private String nativeManagementSecurityRealm;
    private String httpManagementSecurityRealm;

    public LocalHostControllerInfoImpl(ControlledProcessState processState) {
        this.processState = processState;
    }

    public String getLocalHostName() {
        return this.localHostName;
    }

    public ControlledProcessState.State getProcessState() {
        return this.processState.getState();
    }

    public boolean isMasterDomainController() {
        return this.master;
    }

    public String getNativeManagementInterface() {
        return this.nativeManagementInterface;
    }

    public int getNativeManagementPort() {
        return this.nativeManagementPort;
    }

    public String getNativeManagementSecurityRealm() {
        return this.nativeManagementSecurityRealm;
    }

    public String getHttpManagementInterface() {
        return this.httpManagementInterface;
    }

    public int getHttpManagementPort() {
        return this.httpManagementPort;
    }

    public int getHttpManagementSecurePort() {
        return this.httpManagementSecurePort;
    }

    public String getHttpManagementSecurityRealm() {
        return this.httpManagementSecurityRealm;
    }

    public NetworkInterfaceBinding getNetworkInterfaceBinding(String name) throws SocketException, UnknownHostException {
        ParsedInterfaceCriteria criteria = this.parsedInterfaceCriteria.get(name);
        if (criteria == null) {
            throw new IllegalArgumentException(String.format("No interface named %s exists ", name));
        }
        return NetworkInterfaceService.createBinding((String)name, (ParsedInterfaceCriteria)criteria);
    }

    public ContentRepository getContentRepository() {
        return this.contentRepository;
    }

    public String getRemoteDomainControllerHost() {
        return this.remoteDcHost;
    }

    public int getRemoteDomainControllertPort() {
        return this.remoteDcPort;
    }

    public String getRemoteDomainControllerSecurityRealm() {
        return this.remoteSecurityRealm;
    }

    void setContentRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    void setMasterDomainController(boolean master) {
        this.master = master;
    }

    void setLocalHostName(String localHostName) {
        this.localHostName = localHostName;
    }

    void setNativeManagementInterface(String nativeManagementInterface) {
        this.nativeManagementInterface = nativeManagementInterface;
    }

    void setNativeManagementPort(int nativeManagementPort) {
        this.nativeManagementPort = nativeManagementPort;
    }

    void setNativeManagementSecurityRealm(String nativeManagementSecurityRealm) {
        this.nativeManagementSecurityRealm = nativeManagementSecurityRealm;
    }

    void setHttpManagementInterface(String httpManagementInterface) {
        this.httpManagementInterface = httpManagementInterface;
    }

    void setHttpManagementPort(int httpManagementPort) {
        this.httpManagementPort = httpManagementPort;
    }

    void setHttpManagementSecurePort(int httpManagementSecurePort) {
        this.httpManagementSecurePort = httpManagementSecurePort;
    }

    void setHttpManagementSecurityRealm(String httpManagementSecurityRealm) {
        this.httpManagementSecurityRealm = httpManagementSecurityRealm;
    }

    void addNetworkInterfaceBinding(String name, ParsedInterfaceCriteria criteria) {
        this.parsedInterfaceCriteria.put(name, criteria);
    }

    void removeNetworkInterfaceBinding(String name) {
        this.parsedInterfaceCriteria.remove(name);
    }

    void setRemoteDomainControllerHost(String host) {
        this.remoteDcHost = host;
    }

    void setRemoteDomainControllerPort(int port) {
        this.remoteDcPort = port;
    }

    public void setRemoteDomainControllerSecurityRealm(String remoteSecurityRealm) {
        this.remoteSecurityRealm = remoteSecurityRealm;
    }
}

