/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ActivateMethod;
import org.apache.felix.scr.impl.helper.DeactivateMethod;
import org.apache.felix.scr.impl.helper.ModifiedMethod;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentInstance;

public class ImmediateComponentManager
extends AbstractComponentManager {
    private Object m_implementationObject;
    private ComponentContextImpl m_componentContext;
    private ComponentHolder m_componentHolder;
    private ActivateMethod m_activateMethod;
    private DeactivateMethod m_deactivateMethod;
    private ModifiedMethod m_modifyMethod;
    private Dictionary m_factoryProperties;
    private Dictionary m_properties;
    private Dictionary m_configurationProperties;

    public ImmediateComponentManager(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata) {
        super(activator, metadata);
        this.m_componentHolder = componentHolder;
    }

    ComponentHolder getComponentHolder() {
        return this.m_componentHolder;
    }

    void clear() {
        if (this.m_componentHolder != null) {
            this.m_componentHolder.disposed(this);
        }
        super.clear();
    }

    protected boolean createComponent() {
        ComponentContextImpl tmpContext = new ComponentContextImpl(this);
        Object tmpComponent = this.createImplementationObject(tmpContext);
        if (tmpComponent == null) {
            return false;
        }
        this.m_componentContext = tmpContext;
        this.m_implementationObject = tmpComponent;
        return true;
    }

    protected void deleteComponent(int reason) {
        this.disposeImplementationObject(this.m_implementationObject, this.m_componentContext, reason);
        this.m_implementationObject = null;
        this.m_componentContext = null;
        this.m_properties = null;
    }

    ComponentContext getComponentContext() {
        return this.m_componentContext;
    }

    public ComponentInstance getComponentInstance() {
        return this.m_componentContext;
    }

    Object getInstance() {
        return this.m_implementationObject;
    }

    protected Object createImplementationObject(ComponentContext componentContext) {
        DependencyManager dm;
        Object implementationObject;
        Class implementationObjectClass;
        try {
            implementationObjectClass = this.getActivator().getBundleContext().getBundle().loadClass(this.getComponentMetadata().getImplementationClassName());
            implementationObject = implementationObjectClass.newInstance();
        }
        catch (Throwable t) {
            this.log(1, "Error during instantiation of the implementation object", t);
            return null;
        }
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            dm = (DependencyManager)it.next();
            if (dm.open(implementationObject)) continue;
            this.log(1, "Cannot create component instance due to failure to bind reference {0}", new Object[]{dm.getName()}, null);
            it = this.getDependencyManagers();
            while (it.hasNext()) {
                dm = (DependencyManager)it.next();
                dm.close();
            }
            return null;
        }
        if (this.m_activateMethod == null) {
            this.m_activateMethod = new ActivateMethod(this, this.getComponentMetadata().getActivate(), this.getComponentMetadata().isActivateDeclared(), implementationObjectClass);
        }
        if (!this.m_activateMethod.invoke(implementationObject, new ActivateMethod.ActivatorParameter(componentContext, 1), false)) {
            it = this.getDependencyManagers();
            while (it.hasNext()) {
                dm = (DependencyManager)it.next();
                dm.close();
            }
            return null;
        }
        return implementationObject;
    }

    protected void disposeImplementationObject(Object implementationObject, ComponentContext componentContext, int reason) {
        if (this.m_deactivateMethod == null) {
            this.m_deactivateMethod = new DeactivateMethod(this, this.getComponentMetadata().getDeactivate(), this.getComponentMetadata().isDeactivateDeclared(), implementationObject.getClass());
        }
        this.m_deactivateMethod.invoke(implementationObject, new ActivateMethod.ActivatorParameter(componentContext, reason), true);
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            dm.close();
        }
    }

    protected Object getService() {
        return this.m_implementationObject;
    }

    protected void setFactoryProperties(Dictionary dictionary) {
        this.m_factoryProperties = ImmediateComponentManager.copyTo(null, dictionary);
    }

    public boolean hasConfiguration() {
        return this.m_configurationProperties != null;
    }

    void registerComponentId() {
        super.registerComponentId();
        this.m_properties = null;
    }

    void unregisterComponentId() {
        super.unregisterComponentId();
        this.m_properties = null;
    }

    public Dictionary getProperties() {
        if (this.m_properties == null) {
            Dictionary props = ImmediateComponentManager.copyTo(null, this.getComponentMetadata().getProperties());
            List depMetaData = this.getComponentMetadata().getDependencies();
            Iterator di = depMetaData.iterator();
            while (di.hasNext()) {
                ReferenceMetadata rm = (ReferenceMetadata)di.next();
                if (rm.getTarget() == null) continue;
                props.put(rm.getTargetPropertyName(), rm.getTarget());
            }
            ImmediateComponentManager.copyTo(props, this.m_configurationProperties);
            ImmediateComponentManager.copyTo(props, this.m_factoryProperties);
            props.put("component.name", this.getComponentMetadata().getName());
            props.put("component.id", new Long(this.getId()));
            this.m_properties = props;
        }
        return this.m_properties;
    }

    public void reconfigure(Dictionary configuration) {
        if (configuration == null && this.m_configurationProperties == null) {
            this.log(4, "No configuration provided (or deleted), nothing to do", null);
            return;
        }
        this.m_configurationProperties = configuration;
        this.m_properties = null;
        if (this.getState() == 4 && configuration != null && this.getComponentMetadata().isConfigurationRequired()) {
            this.activateInternal();
            return;
        }
        if ((this.getState() & 0x70) == 0) {
            return;
        }
        if (configuration == null && this.getComponentMetadata().isConfigurationRequired()) {
            this.deactivateInternal(4);
        } else if (configuration == null | !this.modify()) {
            this.log(4, "Deactivating and Activating to reconfigure from configuration", null);
            int reason = configuration == null ? 4 : 3;
            this.deactivateInternal(reason);
            this.activateInternal();
        }
    }

    private boolean modify() {
        if (this.getInstance() == null) {
            return false;
        }
        if (this.getComponentMetadata().getModified() == null) {
            return false;
        }
        if (this.m_modifyMethod == null) {
            this.m_modifyMethod = new ModifiedMethod(this, this.getComponentMetadata().getModified(), this.getInstance().getClass());
        }
        Dictionary props = this.getProperties();
        Iterator it = this.getDependencyManagers();
        while (it.hasNext()) {
            DependencyManager dm = (DependencyManager)it.next();
            if (dm.canUpdateDynamically(props)) continue;
            this.log(3, "Cannot dynamically update the configuration due to dependency changes induced on dependency {0}", new Object[]{dm.getName()}, null);
            return false;
        }
        if (!this.m_modifyMethod.invoke(this.getInstance(), new ActivateMethod.ActivatorParameter(this.m_componentContext, -1), true)) {
            this.log(1, "Declared modify method ''{0}'' cannot be found, configuring by reactivation", new Object[]{this.getComponentMetadata().getModified()}, null);
            return false;
        }
        if (!this.verifyDependencyManagers(props)) {
            this.log(1, "Updating the service references caused at least on reference to become unsatisfied, deactivating component", null);
            return false;
        }
        ServiceRegistration sr = this.getServiceRegistration();
        if (sr != null) {
            try {
                Dictionary regProps = this.getServiceProperties();
                if (!this.servicePropertiesMatches(sr, regProps)) {
                    sr.setProperties(regProps);
                }
            }
            catch (IllegalStateException ise) {
            }
            catch (IllegalArgumentException iae) {
                this.log(1, "Unexpected configuration property problem when updating service registration", iae);
            }
            catch (Throwable t) {
                this.log(1, "Unexpected problem when updating service registration", t);
            }
        }
        return true;
    }

    private boolean servicePropertiesMatches(ServiceRegistration reg, Dictionary props) {
        Hashtable<String, Object> regProps = new Hashtable<String, Object>();
        String[] keys = reg.getReference().getPropertyKeys();
        for (int i = 0; keys != null && i < keys.length; ++i) {
            if (keys[i].equals("objectClass") || keys[i].equals("service.id")) continue;
            ((Dictionary)regProps).put(keys[i], reg.getReference().getProperty(keys[i]));
        }
        return ((Object)regProps).equals(props);
    }
}

