/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;

public class ArgumentWithoutValue
implements CommandArgument {
    protected final int index;
    protected final String fullName;
    protected final String shortName;
    protected List<CommandArgument> requiredPreceding;
    protected List<CommandArgument> cantAppearAfter = Collections.emptyList();
    protected boolean exclusive;

    public ArgumentWithoutValue(CommandHandlerWithArguments handler, String fullName) {
        this(handler, -1, fullName);
    }

    public ArgumentWithoutValue(CommandHandlerWithArguments handler, String fullName, String shortName) {
        if (fullName == null || fullName.length() < 1) {
            throw new IllegalArgumentException("Full name is null or an empty string.");
        }
        this.fullName = fullName;
        this.shortName = shortName;
        this.index = -1;
        if (handler == null) {
            throw new IllegalArgumentException("Command handler is null");
        }
        handler.addArgument(this);
    }

    public ArgumentWithoutValue(CommandHandlerWithArguments handler, int index, String fullName) {
        if (fullName == null || fullName.length() < 1) {
            throw new IllegalArgumentException("Full name is null or an empty string.");
        }
        this.fullName = fullName;
        this.shortName = null;
        this.index = index;
        if (handler == null) {
            throw new IllegalArgumentException("Command handler is null");
        }
        handler.addArgument(this);
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void addRequiredPreceding(CommandArgument arg) {
        if (arg == null) {
            throw new IllegalArgumentException("The argument is null.");
        }
        if (this.requiredPreceding == null) {
            this.requiredPreceding = Collections.singletonList(arg);
            return;
        }
        if (this.requiredPreceding.size() == 1) {
            this.requiredPreceding = new ArrayList<CommandArgument>(this.requiredPreceding);
        }
        this.requiredPreceding.add(arg);
    }

    public void addCantAppearAfter(CommandArgument arg) {
        if (this.cantAppearAfter.isEmpty()) {
            this.cantAppearAfter = new ArrayList<CommandArgument>();
        }
        this.cantAppearAfter.add(arg);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public CommandLineCompleter getValueCompleter() {
        return null;
    }

    @Override
    public String getValue(ParsedArguments args) {
        try {
            return this.getValue(args, false);
        }
        catch (CommandFormatException e) {
            return null;
        }
    }

    @Override
    public String getValue(ParsedArguments args, boolean required) throws CommandFormatException {
        if (!required) {
            return null;
        }
        if (this.isPresent(args)) {
            return null;
        }
        throw new CommandFormatException("Required argument '" + this.fullName + "' is missing value.");
    }

    @Override
    public boolean isPresent(ParsedArguments args) throws CommandFormatException {
        if (!args.hasArguments()) {
            return false;
        }
        if (this.index >= 0 && this.index < args.getOtherArguments().size()) {
            return true;
        }
        if (args.hasArgument(this.fullName)) {
            return true;
        }
        return this.shortName != null && args.hasArgument(this.shortName);
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
        ParsedArguments args = ctx.getParsedArguments();
        if (this.exclusive) {
            return !args.hasArguments();
        }
        if (this.isPresent(args)) {
            return false;
        }
        for (CommandArgument arg : this.cantAppearAfter) {
            if (!arg.isPresent(args)) continue;
            return false;
        }
        if (this.requiredPreceding != null) {
            for (CommandArgument arg : this.requiredPreceding) {
                if (!arg.isPresent(args)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueRequired() {
        return false;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }
}

