/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.webservices.parser.WSDeploymentAspectParser;
import org.jboss.ws.common.sort.DeploymentAspectSorter;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

public class DeploymentAspectsProvider {
    private static List<DeploymentAspect> aspects = null;

    public static synchronized List<DeploymentAspect> getSortedDeploymentAspects() {
        if (aspects == null) {
            LinkedList<DeploymentAspect> deploymentAspects = new LinkedList<DeploymentAspect>();
            ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
            deploymentAspects.addAll(DeploymentAspectsProvider.getDeploymentAspects(cl, "/META-INF/stack-agnostic-deployment-aspects.xml"));
            deploymentAspects.addAll(DeploymentAspectsProvider.getDeploymentAspects(cl, "/META-INF/stack-specific-deployment-aspects.xml"));
            aspects = DeploymentAspectSorter.getInstance().sort(deploymentAspects);
        }
        return aspects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<DeploymentAspect> getDeploymentAspects(ClassLoader cl, String resourcePath) {
        List<DeploymentAspect> list;
        Enumeration<URL> urls = DeploymentAspectsProvider.class.getClassLoader().getResources(resourcePath);
        if (urls == null) throw new RuntimeException("Could not load WS deployment aspects from " + resourcePath);
        URL url = urls.nextElement();
        InputStream is = null;
        try {
            is = url.openStream();
            list = WSDeploymentAspectParser.parse(is, cl);
            if (is == null) return list;
        }
        catch (Throwable throwable) {
            try {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load WS deployment aspects from " + resourcePath, e);
            }
        }
        try {
            is.close();
            return list;
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }
}

