/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.messaging.CommonAttributes;

public enum Attribute {
    UNKNOWN((String)null),
    ALLOW_DIRECT_CONNECTIONS_ONLY((AttributeDefinition)CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY),
    CONNECTOR_NAME("connector-name"),
    CONSUME_NAME("consume"),
    CREATEDURABLEQUEUE_NAME("createDurableQueue"),
    CREATE_NON_DURABLE_QUEUE_NAME("createNonDurableQueue"),
    CREATETEMPQUEUE_NAME("createTempQueue"),
    DELETE_NON_DURABLE_QUEUE_NAME("deleteNonDurableQueue"),
    DELETEDURABLEQUEUE_NAME("deleteDurableQueue"),
    DELETETEMPQUEUE_NAME("deleteTempQueue"),
    DISCOVERY_GROUP_NAME((AttributeDefinition)CommonAttributes.DISCOVERY_GROUP_NAME),
    KEY("key"),
    MANAGE_NAME("manage"),
    MATCH("match"),
    NAME("name"),
    PATH("path"),
    RELATIVE_TO("relative-to"),
    ROLES_ATTR_NAME("roles"),
    SEND_NAME("send"),
    SERVER_ID("server-id"),
    SOCKET_BINDING("socket-binding"),
    STRING("string"),
    TYPE_ATTR_NAME("type"),
    VALUE((AttributeDefinition)CommonAttributes.VALUE);

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Attribute> MAP;

    private Attribute(String name) {
        this.name = name;
        this.definition = null;
    }

    private Attribute(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Attribute forName(String localName) {
        Attribute element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute element : Attribute.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

