/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerHandlerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class LoggerAssignHandler
extends AbstractModelUpdateHandler {
    private static final String OPERATION_NAME = "assign-handler";
    private static final LoggerAssignHandler INSTANCE = new LoggerAssignHandler();

    public static String getOperationName() {
        return OPERATION_NAME;
    }

    public static LoggerAssignHandler getInstance() {
        return INSTANCE;
    }

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        String handlerName = this.getHandlerName(operation);
        ModelNode assignedHandlers = this.getAssignedHandlers(model);
        if (assignedHandlers.isDefined() && assignedHandlers.asList().contains(operation.get("name"))) {
            this.opFailed("Handler " + handlerName + " is already assigned.");
        }
        assignedHandlers.add(handlerName);
    }

    protected void opFailed(String description) throws OperationFailedException {
        ModelNode failure = new ModelNode();
        failure.get(new String[]{"failure-description", description});
        throw new OperationFailedException(failure);
    }

    protected String getHandlerName(ModelNode operation) {
        return operation.get("name").asString();
    }

    protected String getLoggerName(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.getLastElement().getValue();
    }

    protected ModelNode getAssignedHandlers(ModelNode model) {
        return model.get("handlers");
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String loggerName = this.getLoggerName(operation);
        String handlerName = this.getHandlerName(operation);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController loggerHandlerController = serviceRegistry.getService(LogServices.loggerHandlerName(loggerName, handlerName));
        ServiceController handlerController = serviceRegistry.getService(LogServices.handlerName(handlerName));
        if (loggerHandlerController != null) {
            this.opFailed("Handler " + handlerName + " is already assigned.");
        }
        if (handlerController == null) {
            this.opFailed("Handler " + handlerName + " not found.");
        }
        ServiceTarget target = context.getServiceTarget();
        LoggerHandlerService service = new LoggerHandlerService(loggerName);
        ServiceBuilder builder = target.addService(LogServices.loggerHandlerName(loggerName, handlerName), (Service)service);
        builder.addDependency(LogServices.loggerName(loggerName));
        builder.addDependency(LogServices.handlerName(handlerName), Handler.class, service.getHandlerInjector());
        builder.addListener((ServiceListener)verificationHandler);
        newControllers.add(builder.install());
    }
}

