/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.CoreServices;
import org.jboss.osgi.framework.internal.DefaultAutoInstallProvider;
import org.jboss.osgi.framework.internal.DefaultBundleInstallProvider;
import org.jboss.osgi.framework.internal.DefaultFrameworkModuleProvider;
import org.jboss.osgi.framework.internal.DefaultModuleLoaderIntegration;
import org.jboss.osgi.framework.internal.DefaultSystemModuleProvider;
import org.jboss.osgi.framework.internal.DefaultSystemServicesProvider;
import org.jboss.osgi.framework.internal.DeploymentFactoryPlugin;
import org.jboss.osgi.framework.internal.FrameworkActivator;
import org.jboss.osgi.framework.internal.FrameworkActive;
import org.jboss.osgi.framework.internal.FrameworkCreate;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkInit;
import org.jboss.osgi.framework.internal.FrameworkProxy;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.PackageAdminPlugin;
import org.jboss.osgi.framework.internal.PersistentBundlesInstaller;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.ServiceManagerPlugin;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.jboss.osgi.framework.internal.SystemBundleService;
import org.jboss.osgi.framework.internal.SystemContextService;
import org.jboss.osgi.framework.internal.SystemPackagesPlugin;
import org.jboss.osgi.framework.internal.URLHandlerPlugin;
import org.jboss.osgi.framework.internal.WebXMLVerifierInterceptor;
import org.osgi.framework.launch.Framework;

public final class FrameworkBuilder {
    private final Map<String, Object> initialProperties = new HashMap<String, Object>();
    private Set<ServiceName> providedServices = new HashSet<ServiceName>();
    private ServiceContainer serviceContainer;
    private ServiceTarget serviceTarget;
    private boolean closed;

    public FrameworkBuilder(Map<String, Object> props) {
        if (props != null) {
            this.initialProperties.putAll(props);
        }
    }

    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    public Object getProperty(String key, Object defaultValue) {
        Object value = this.initialProperties.get(key);
        return value != null ? value : defaultValue;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.initialProperties);
    }

    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public void setServiceContainer(ServiceContainer serviceContainer) {
        this.assertNotClosed();
        this.serviceContainer = serviceContainer;
    }

    public ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    public void setServiceTarget(ServiceTarget serviceTarget) {
        this.assertNotClosed();
        this.serviceTarget = serviceTarget;
    }

    public boolean isProvidedService(ServiceName serviceName) {
        return this.providedServices.contains(serviceName);
    }

    public void addProvidedService(ServiceName serviceName) {
        this.assertNotClosed();
        this.providedServices.add(serviceName);
    }

    public Set<ServiceName> getProvidedServices() {
        return Collections.unmodifiableSet(this.providedServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Framework createFramework() {
        this.assertNotClosed();
        try {
            FrameworkProxy frameworkProxy = new FrameworkProxy(this);
            return frameworkProxy;
        }
        finally {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFrameworkServices(ServiceController.Mode initialMode, boolean firstInit) {
        this.assertNotClosed();
        try {
            this.createFrameworkServicesInternal(this.serviceTarget, initialMode, firstInit);
        }
        finally {
            this.closed = true;
        }
    }

    void createFrameworkServicesInternal(ServiceTarget serviceTarget, ServiceController.Mode initialMode, boolean firstInit) {
        URLHandlerPlugin.addService(serviceTarget);
        BundleManager bundleManager = BundleManager.addService(serviceTarget, this);
        FrameworkState frameworkState = FrameworkCreate.addService(serviceTarget, bundleManager);
        DeploymentFactoryPlugin.addService(serviceTarget);
        BundleStoragePlugin.addService(serviceTarget, firstInit);
        CoreServices.addService(serviceTarget);
        FrameworkActive.addService(serviceTarget);
        FrameworkActivator.addService(serviceTarget, initialMode);
        FrameworkEventsPlugin.addService(serviceTarget);
        FrameworkInit.addService(serviceTarget);
        LifecycleInterceptorPlugin.addService(serviceTarget);
        ModuleManagerPlugin.addService(serviceTarget);
        NativeCodePlugin.addService(serviceTarget);
        PackageAdminPlugin.addService(serviceTarget);
        PersistentBundlesInstaller.addService(serviceTarget);
        ResolverPlugin.addService(serviceTarget);
        ServiceManagerPlugin.addService(serviceTarget);
        StartLevelPlugin.addService(serviceTarget);
        SystemBundleService.addService(serviceTarget, frameworkState);
        SystemContextService.addService(serviceTarget);
        SystemPackagesPlugin.addService(serviceTarget, this);
        WebXMLVerifierInterceptor.addService(serviceTarget);
        if (!this.isProvidedService(Services.AUTOINSTALL_PROVIDER)) {
            DefaultAutoInstallProvider.addService(serviceTarget);
        }
        if (!this.isProvidedService(Services.BUNDLE_INSTALL_PROVIDER)) {
            DefaultBundleInstallProvider.addService(serviceTarget);
        }
        if (!this.isProvidedService(Services.FRAMEWORK_MODULE_PROVIDER)) {
            DefaultFrameworkModuleProvider.addService(serviceTarget);
        }
        if (!this.isProvidedService(Services.MODULE_LOADER_PROVIDER)) {
            DefaultModuleLoaderIntegration.addService(serviceTarget);
        }
        if (!this.isProvidedService(Services.SYSTEM_MODULE_PROVIDER)) {
            DefaultSystemModuleProvider.addService(serviceTarget);
        }
        if (!this.isProvidedService(Services.SYSTEM_SERVICES_PROVIDER)) {
            DefaultSystemServicesProvider.addService(serviceTarget);
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Framework builder already closed");
        }
    }
}

