/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded.ejb3;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.ejb.MessageDriven;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.jboss.as.embedded.ejb3.BundleSymbolicNameExclusionFilter;
import org.jboss.as.embedded.ejb3.ExclusionFilter;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

class ClassPathEjbJarScanner {
    private static final Logger log = Logger.getLogger(ClassPathEjbJarScanner.class);
    private static final String SYS_PROP_KEY_CLASS_PATH = "java.class.path";
    private static final String[] DUMMY = new String[0];
    private static final String PATH_EJB_JAR_XML = "META-INF/ejb-jar.xml";
    private static final String EXTENSION_CLASS = ".class";
    private static final String EXTENSION_JAR = ".jar";
    private static final Class<? extends Annotation>[] EJB_COMPONENT_ANNOTATIONS = new Class[]{Stateless.class, Stateful.class, Singleton.class, MessageDriven.class};
    @Deprecated
    private static final ScheduledExecutorService ses = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private static final String JAVA_HOME = ClassPathEjbJarScanner.getSystemProperty("java.home");
    private static final List<ExclusionFilter> exclusionFilters = new ArrayList<ExclusionFilter>();

    private ClassPathEjbJarScanner() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static String[] getEjbJars(Map<?, ?> properties) {
        ArrayList<String> returnValue = new ArrayList<String>();
        String classPath = ClassPathEjbJarScanner.getSystemProperty("surefire.test.class.path");
        if (classPath == null || classPath.isEmpty()) {
            classPath = ClassPathEjbJarScanner.getSystemProperty(SYS_PROP_KEY_CLASS_PATH);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Class Path: %s", (Object)classPath);
        }
        String[] classPathEntries = classPath.split(File.pathSeparator);
        Object modules = properties != null ? (Object)properties.get("javax.ejb.embeddable.modules") : null;
        HashSet<String> moduleNames = null;
        if (modules != null) {
            if (modules instanceof File[]) {
                for (File file : (File[])modules) {
                    returnValue.add(file.getAbsolutePath());
                }
                return returnValue.toArray(DUMMY);
            }
            if (modules instanceof File) {
                returnValue.add(((File)modules).getAbsolutePath());
                return returnValue.toArray(DUMMY);
            }
            if (modules instanceof String[]) {
                moduleNames = new HashSet<String>();
                moduleNames.addAll(Arrays.asList((String[])modules));
            } else if (modules instanceof String) {
                moduleNames = new HashSet();
                moduleNames.add(modules.toString());
            } else {
                throw new RuntimeException("javax.ejb.embeddable.modules was not of type File[], File, String[] or String, but of type " + modules.getClass());
            }
        }
        for (String classPathEntry : classPathEntries) {
            String moduleName = ClassPathEjbJarScanner.getEjbJar(classPathEntry);
            if (moduleName == null) continue;
            if (moduleNames == null) {
                returnValue.add(classPathEntry);
                continue;
            }
            if (!moduleNames.contains(moduleName)) continue;
            returnValue.add(classPathEntry);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("EJB Modules discovered on ClassPath: " + returnValue));
        }
        return returnValue.toArray(DUMMY);
    }

    private static ClassLoader getTccl() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static String getSystemProperty(final String property) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(property);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getEjbJar(String candidate) {
        if (candidate == null) return null;
        if (candidate.isEmpty()) {
            return null;
        }
        VirtualFile file = VFS.getChild((String)candidate);
        TempFileProvider provider = null;
        for (ExclusionFilter exclusionFilter : exclusionFilters) {
            if (!exclusionFilter.exclude(file)) continue;
            if (!log.isTraceEnabled()) return null;
            log.tracef("%s matched %s for exclusion; skipping", (Object)exclusionFilter, (Object)file);
            return null;
        }
        try {
            Closeable handle;
            if (!file.exists()) {
                log.warn((Object)("File on ClassPath could not be found: " + file));
                return null;
            }
            if (file.isDirectory()) {
                handle = VFS.mountReal((File)file.getPhysicalFile(), (VirtualFile)file);
            } else {
                if (!file.getName().endsWith(EXTENSION_JAR)) {
                    log.warn((Object)("Encountered unknown file type, skipping: " + file));
                    return null;
                }
                if (provider == null) {
                    provider = TempFileProvider.create((String)"jbossejbmodulescanner", (ScheduledExecutorService)ses);
                }
                handle = VFS.mountZip((File)file.getPhysicalFile(), (VirtualFile)file, (TempFileProvider)provider);
            }
            try {
                VirtualFile ejbJarXml = file.getChild(PATH_EJB_JAR_XML);
                if (ejbJarXml.exists()) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Found descriptor %s in %s", (Object)ejbJarXml.getPathNameRelativeTo(file), (Object)file);
                    }
                    String string = ClassPathEjbJarScanner.getModuleNameFromEjbJar(file, ejbJarXml);
                    return string;
                }
                if (ClassPathEjbJarScanner.containsEjbComponentClass(file)) {
                    String string = ClassPathEjbJarScanner.getModuleNameFromFileName(file);
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                try {
                    handle.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Could not close handle to mounted " + file), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not mount file '" + candidate + "'", e);
        }
    }

    private static String getModuleNameFromEjbJar(VirtualFile file, VirtualFile ejbJarXml) {
        return ClassPathEjbJarScanner.getModuleNameFromFileName(file);
    }

    private static String getModuleNameFromFileName(VirtualFile file) {
        String moduleName = file.getName();
        int index = moduleName.lastIndexOf(46);
        if (index != -1) {
            return moduleName.substring(0, index - 1);
        }
        return moduleName;
    }

    @Deprecated
    private static boolean containsEjbComponentClass(VirtualFile file) {
        Indexer indexer = new Indexer();
        ClassPathEjbJarScanner.indexClasses(file, file, indexer);
        Index index = indexer.complete();
        for (Class<? extends Annotation> annotation : EJB_COMPONENT_ANNOTATIONS) {
            DotName annotationName = DotName.createSimple((String)annotation.getName());
            List classes = index.getAnnotations(annotationName);
            if (classes == null || classes.isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void indexClasses(VirtualFile root, VirtualFile file, Indexer indexer) {
        assert (file != null) : "File must be specified";
        for (VirtualFile child : file.getChildren()) {
            String childName;
            if (child.isDirectory()) {
                ClassPathEjbJarScanner.indexClasses(root, child, indexer);
            }
            if (!(childName = child.getPathNameRelativeTo(root)).endsWith(EXTENSION_CLASS)) continue;
            InputStream stream = null;
            try {
                try {
                    stream = child.openStream();
                    indexer.index(stream);
                }
                catch (IOException e) {
                    log.warn((Object)("Could not load class file " + child), (Throwable)e);
                }
            }
            finally {
                try {
                    if (stream == null) continue;
                    stream.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Exception closing file " + child), (Throwable)e);
                }
            }
        }
    }

    static {
        exclusionFilters.add(new BundleSymbolicNameExclusionFilter("org.eclipse", "org.junit"));
        exclusionFilters.add(new ExclusionFilter(){

            @Override
            public boolean exclude(VirtualFile file) throws IllegalArgumentException {
                String pathName = file.getPathName();
                return pathName.startsWith(JAVA_HOME);
            }
        });
    }
}

