/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.merge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.AuthenticationMechanism;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.Icon;
import org.jboss.jca.common.api.metadata.ra.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.ra.LicenseType;
import org.jboss.jca.common.api.metadata.ra.LocalizedXsdString;
import org.jboss.jca.common.api.metadata.ra.MergeableMetadata;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.SecurityPermission;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.common.metadata.merge.DefaultAdminObjectMatcher;
import org.jboss.jca.common.metadata.merge.DefaultConnectionDefinitionMatcher;
import org.jboss.jca.common.metadata.merge.ExtensionMatcher;
import org.jboss.jca.common.metadata.ra.common.AbstractResourceAdapetrImpl;
import org.jboss.jca.common.metadata.ra.common.AdminObjectImpl;
import org.jboss.jca.common.metadata.ra.common.ConfigPropertyImpl;
import org.jboss.jca.common.metadata.ra.common.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.ra.common.OutboundResourceAdapterImpl;
import org.jboss.jca.common.metadata.ra.common.ResourceAdapter1516Impl;
import org.jboss.jca.common.metadata.ra.ra10.Connector10Impl;
import org.jboss.jca.common.metadata.ra.ra10.ResourceAdapter10Impl;
import org.jboss.jca.common.metadata.ra.ra15.Connector15Impl;
import org.jboss.jca.common.metadata.ra.ra16.ConfigProperty16Impl;
import org.jboss.jca.common.metadata.ra.ra16.Connector16Impl;

public class Merger {
    public List<ConfigProperty> mergeConfigProperties(Map<String, String> ijProperties, List<? extends ConfigProperty> original) {
        ArrayList<ConfigProperty> mergedProperties = new ArrayList<ConfigProperty>(original.size());
        for (ConfigProperty configProperty : original) {
            if (ijProperties != null && ijProperties.containsKey(configProperty.getConfigPropertyName().getValue())) {
                if (configProperty instanceof ConfigProperty16) {
                    ConfigProperty16 c16 = (ConfigProperty16)configProperty;
                    XsdString newValue = new XsdString(ijProperties.get(configProperty.getConfigPropertyName().getValue()), configProperty.getConfigPropertyName().getId());
                    ConfigProperty16Impl newProp = new ConfigProperty16Impl(configProperty.getDescriptions(), configProperty.getConfigPropertyName(), configProperty.getConfigPropertyType(), newValue, c16.getConfigPropertyIgnore(), c16.getConfigPropertySupportsDynamicUpdates(), c16.getConfigPropertyConfidential(), configProperty.getId());
                    mergedProperties.add(newProp);
                    continue;
                }
                XsdString newValue = new XsdString(ijProperties.get(configProperty.getConfigPropertyName().getValue()), configProperty.getConfigPropertyName().getId());
                ConfigPropertyImpl newProp = new ConfigPropertyImpl(configProperty.getDescriptions(), configProperty.getConfigPropertyName(), configProperty.getConfigPropertyType(), newValue, configProperty.getId());
                mergedProperties.add(newProp);
                continue;
            }
            mergedProperties.add(configProperty);
        }
        return mergedProperties;
    }

    public Connector mergeConnectorWithCommonIronJacamar(CommonIronJacamar ij, Connector conn) {
        return this.mergeConnectorWithCommonIronJacamar(ij, conn, null, null);
    }

    public Connector mergeConnectorWithCommonIronJacamar(CommonIronJacamar ij, Connector conn, ExtensionMatcher<AdminObject, CommonAdminObject> adminMatcher, ExtensionMatcher<ConnectionDefinition, CommonConnDef> connDefMatcher) {
        if (ij == null) {
            return conn;
        }
        if (adminMatcher == null) {
            adminMatcher = new DefaultAdminObjectMatcher();
        }
        if (connDefMatcher == null) {
            connDefMatcher = new DefaultConnectionDefinitionMatcher();
        }
        this.mergeTransactionSupport(ij, conn);
        List original = conn.getResourceadapter().getConfigProperties();
        List<ConfigProperty> newProperties = this.mergeConfigProperties(ij.getConfigProperties(), original);
        ((AbstractResourceAdapetrImpl)conn.getResourceadapter()).forceNewConfigPropertiesContent(newProperties);
        if (conn.getVersion() != Connector.Version.V_10) {
            Iterator i$;
            ResourceAdapter1516 ra1516 = (ResourceAdapter1516)conn.getResourceadapter();
            if (ra1516 != null && ra1516.getAdminObjects() != null) {
                ArrayList<AdminObject> newAdminObjects = new ArrayList<AdminObject>(ra1516.getAdminObjects().size());
                i$ = ra1516.getAdminObjects().iterator();
                while (i$.hasNext()) {
                    AdminObject adminObj;
                    AdminObject newAdminObj = adminObj = (AdminObject)i$.next();
                    if (ij.getAdminObjects() != null) {
                        for (CommonAdminObject commonAdminObj : ij.getAdminObjects()) {
                            if (!adminMatcher.match(adminObj, commonAdminObj)) continue;
                            newAdminObj = this.mergeAdminObject(commonAdminObj, newAdminObj);
                        }
                    }
                    newAdminObjects.add(newAdminObj);
                }
                ((ResourceAdapter1516Impl)ra1516).forceAdminObjectsContent(newAdminObjects);
            }
            if (ra1516 != null && ra1516.getOutboundResourceadapter() != null && ra1516.getOutboundResourceadapter().getConnectionDefinitions() != null) {
                ArrayList<ConnectionDefinition> newConDefs = new ArrayList<ConnectionDefinition>(ra1516.getOutboundResourceadapter().getConnectionDefinitions().size());
                i$ = ra1516.getOutboundResourceadapter().getConnectionDefinitions().iterator();
                while (i$.hasNext()) {
                    ConnectionDefinition conDef;
                    ConnectionDefinition newConDef = conDef = (ConnectionDefinition)i$.next();
                    if (ij.getConnectionDefinitions() != null) {
                        if (ij.getConnectionDefinitions().size() == 1 && ((CommonConnDef)ij.getConnectionDefinitions().get(0)).isEnabled().booleanValue()) {
                            newConDef = this.mergeConDef((CommonConnDef)ij.getConnectionDefinitions().get(0), newConDef);
                        } else {
                            for (CommonConnDef commonConDef : ij.getConnectionDefinitions()) {
                                if (!connDefMatcher.match(conDef, commonConDef)) continue;
                                newConDef = this.mergeConDef(commonConDef, newConDef);
                            }
                        }
                    }
                    newConDefs.add(newConDef);
                }
                ((OutboundResourceAdapterImpl)ra1516.getOutboundResourceadapter()).forceConnectionDefinitionsContent(newConDefs);
            }
        }
        return conn;
    }

    private ConnectionDefinition mergeConDef(CommonConnDef commonConDef, ConnectionDefinition conDef) {
        List original = conDef.getConfigProperties();
        List<ConfigProperty> newProperties = this.mergeConfigProperties(commonConDef.getConfigProperties(), original);
        ((ConnectionDefinitionImpl)conDef).forceNewConfigPropertiesContent(newProperties);
        return conDef;
    }

    private AdminObject mergeAdminObject(CommonAdminObject commonAdminObj, AdminObject adminObj) {
        List original = adminObj.getConfigProperties();
        List<ConfigProperty> newProperties = this.mergeConfigProperties(commonAdminObj.getConfigProperties(), original);
        ((AdminObjectImpl)adminObj).forceNewConfigPropertiesContent(newProperties);
        return adminObj;
    }

    private void mergeTransactionSupport(CommonIronJacamar ij, Connector conn) {
        if (ij.getTransactionSupport() != null) {
            ResourceAdapter1516 ra1516;
            if (conn.getVersion() == Connector.Version.V_10 && conn.getResourceadapter() != null) {
                ((ResourceAdapter10Impl)conn.getResourceadapter()).forceNewTrasactionSupport(ij.getTransactionSupport());
            } else if (conn.getResourceadapter() != null && (ra1516 = (ResourceAdapter1516)conn.getResourceadapter()).getOutboundResourceadapter() != null) {
                ((OutboundResourceAdapterImpl)ra1516.getOutboundResourceadapter()).forceNewTrasactionSupport(ij.getTransactionSupport());
            }
        }
    }

    public Connector mergeConnectorAndDs(CommonDataSource cds, Connector connector) throws IllegalArgumentException, Exception {
        if (cds == null) {
            return null;
        }
        return this.mergeConnectorWithProperties(connector, Merger.createConfigProperties(cds, this.extractProperties(connector)), null);
    }

    private Connector mergeConnectorWithProperties(Connector connector, List<ConfigProperty> connectioDefProperties, List<ConfigProperty> raConfigProperties) throws IllegalArgumentException, Exception {
        XsdString managedconnectionfactoryClass = null;
        String id = null;
        XsdString connectionfactoryImplClass = null;
        XsdString connectionfactoryInterface = null;
        XsdString connectionImplClass = null;
        XsdString connectionInterface = null;
        List<AuthenticationMechanism> authenticationMechanism = null;
        boolean reauthenticationSupport = false;
        List<SecurityPermission> securityPermissions = null;
        XsdString vendorName = null;
        List<LocalizedXsdString> description = null;
        XsdString resourceadapterVersion = null;
        String moduleName = null;
        XsdString eisType = null;
        LicenseType license = null;
        List<LocalizedXsdString> displayNames = null;
        List<Icon> icons = null;
        List<AdminObject> adminobjects = null;
        TransactionSupportEnum transactionSupport = null;
        if (connector.getVersion() == Connector.Version.V_10) {
            if (raConfigProperties != null) {
                if (connectioDefProperties == null) {
                    connectioDefProperties = raConfigProperties;
                } else {
                    connectioDefProperties.addAll(raConfigProperties);
                }
            }
            ResourceAdapter10Impl resourceadapter = new ResourceAdapter10Impl(managedconnectionfactoryClass, connectionfactoryInterface, connectionfactoryImplClass, connectionInterface, connectionImplClass, transactionSupport, authenticationMechanism, connectioDefProperties, reauthenticationSupport, securityPermissions, id);
            Connector10Impl newConnector = new Connector10Impl(moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, description, displayNames, icons, id);
            return (Connector)newConnector.merge((MergeableMetadata)connector);
        }
        ArrayList<ConnectionDefinition> connectionDefinitions = new ArrayList<ConnectionDefinition>(1);
        ConnectionDefinitionImpl connectionDefinition = new ConnectionDefinitionImpl(managedconnectionfactoryClass, connectioDefProperties, connectionfactoryInterface, connectionfactoryImplClass, connectionInterface, connectionImplClass, id);
        connectionDefinitions.add(connectionDefinition);
        OutboundResourceAdapterImpl outboundResourceadapter = new OutboundResourceAdapterImpl(connectionDefinitions, transactionSupport, authenticationMechanism, reauthenticationSupport, id);
        String resourceadapterClass = null;
        InboundResourceAdapter inboundResourceadapter = null;
        ResourceAdapter1516Impl resourceadapter = new ResourceAdapter1516Impl(resourceadapterClass, raConfigProperties, outboundResourceadapter, inboundResourceadapter, adminobjects, securityPermissions, id);
        if (connector.getVersion() == Connector.Version.V_16) {
            List<String> requiredWorkContexts = null;
            boolean metadataComplete = false;
            Connector16Impl newConnector = new Connector16Impl(moduleName, vendorName, eisType, resourceadapterVersion, license, resourceadapter, requiredWorkContexts, metadataComplete, description, displayNames, icons, id);
            return (Connector)newConnector.merge((MergeableMetadata)connector);
        }
        if (connector.getVersion() == Connector.Version.V_15) {
            Connector15Impl newConnector = new Connector15Impl(vendorName, eisType, resourceadapterVersion, license, resourceadapter, description, displayNames, icons, id);
            return (Connector)newConnector.merge((MergeableMetadata)connector);
        }
        throw new IllegalArgumentException("version= " + connector.getVersion().name());
    }

    private List<? extends ConfigProperty> extractProperties(Connector connector) {
        ResourceAdapter1516 ra1516;
        List originalProperties = null;
        if (connector.getVersion() == Connector.Version.V_10) {
            originalProperties = connector.getResourceadapter().getConfigProperties();
        } else if (connector.getResourceadapter() != null && connector.getResourceadapter() instanceof ResourceAdapter1516 && (ra1516 = (ResourceAdapter1516)connector.getResourceadapter()).getOutboundResourceadapter() != null && ra1516.getOutboundResourceadapter().getConnectionDefinitions() != null) {
            originalProperties = ((ConnectionDefinition)ra1516.getOutboundResourceadapter().getConnectionDefinitions().get(0)).getConfigProperties();
        }
        return originalProperties;
    }

    private static List<ConfigProperty> createConfigProperties(CommonDataSource cds, List<? extends ConfigProperty> originalProperties) {
        DataSource ds = null;
        XaDataSource xads = null;
        if (cds instanceof DataSource) {
            ds = (DataSource)cds;
        }
        if (cds instanceof XaDataSource) {
            xads = (XaDataSource)cds;
        }
        if (originalProperties != null) {
            ConfigPropertyFactory.Prototype prototype;
            ArrayList<ConfigProperty> configProperties = new ArrayList<ConfigProperty>(originalProperties.size());
            block28: for (ConfigProperty configProperty : originalProperties) {
                prototype = ConfigPropertyFactory.Prototype.forName(configProperty.getConfigPropertyName().getValue());
                switch (prototype) {
                    case USERNAME: {
                        if (ds == null) break;
                        DsSecurity security = ds.getSecurity();
                        if (security == null || security.getUserName() == null || security.getUserName().trim().equals("")) continue block28;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, security.getUserName()));
                        break;
                    }
                    case PASSWORD: {
                        if (ds == null) break;
                        DsSecurity security = ds.getSecurity();
                        if (security == null || security.getPassword() == null || security.getPassword().trim().equals("")) continue block28;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, security.getPassword()));
                        break;
                    }
                    case XADATASOURCEPROPERTIES: {
                        if (xads == null || xads.getXaDataSourceProperty() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry xaConfigProperty : xads.getXaDataSourceProperty().entrySet()) {
                            valueBuf.append((String)xaConfigProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append((String)xaConfigProperty.getValue());
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case URLDELIMITER: {
                        if (ds == null || ds.getUrlDelimiter() == null || ds.getUrlDelimiter().trim().equals("")) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getUrlDelimiter()));
                        break;
                    }
                    case URLSELECTORSTRATEGYCLASSNAME: {
                        if (ds == null || ds.getUrlSelectorStrategyClassName() == null || ds.getUrlSelectorStrategyClassName().trim().equals("")) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getUrlSelectorStrategyClassName()));
                        break;
                    }
                    case XADATASOURCECLASS: {
                        if (xads == null || xads.getXaDataSourceClass() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, xads.getXaDataSourceClass()));
                        break;
                    }
                    case TRANSACTIONISOLATION: {
                        if (ds == null || ds.getTransactionIsolation() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getTransactionIsolation().name()));
                        break;
                    }
                    case PREPAREDSTATEMENTCACHESIZE: {
                        if (ds == null || ds.getStatement() == null || ds.getStatement().getPreparedStatementsCacheSize() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getStatement().getPreparedStatementsCacheSize()));
                        break;
                    }
                    case SHAREPREPAREDSTATEMENTS: {
                        if (ds == null || ds.getStatement() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getStatement() != null && ds.getStatement().isSharePreparedStatements() != false));
                        break;
                    }
                    case NEWCONNECTIONSQL: {
                        if (ds == null || ds.getNewConnectionSql() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getNewConnectionSql()));
                        break;
                    }
                    case CHECKVALIDCONNECTIONSQL: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getCheckValidConnectionSql() == null || ds.getValidation().getCheckValidConnectionSql().trim().equals("")) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getValidation().getCheckValidConnectionSql()));
                        break;
                    }
                    case VALIDCONNECTIONCHECKERCLASSNAME: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getValidConnectionChecker() == null || ds.getValidation().getValidConnectionChecker().getClassName() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getValidation().getValidConnectionChecker().getClassName()));
                        break;
                    }
                    case VALIDCONNECTIONCHECKERPROPERTIES: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getValidConnectionChecker() == null || ds.getValidation().getValidConnectionChecker().getClassName() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry connProperty : ds.getValidation().getValidConnectionChecker().getConfigPropertiesMap().entrySet()) {
                            valueBuf.append((String)connProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append((String)connProperty.getValue());
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case EXCEPTIONSORTERCLASSNAME: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getExceptionSorter() == null || ds.getValidation().getExceptionSorter().getClassName() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getValidation().getExceptionSorter().getClassName()));
                        break;
                    }
                    case EXCEPTIONSORTERPROPERTIES: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getExceptionSorter() == null || ds.getValidation().getExceptionSorter().getConfigPropertiesMap() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry connProperty : ds.getValidation().getExceptionSorter().getConfigPropertiesMap().entrySet()) {
                            valueBuf.append((String)connProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append((String)connProperty.getValue());
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case STALECONNECTIONCHECKERCLASSNAME: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getStaleConnectionChecker() == null || ds.getValidation().getStaleConnectionChecker().getClassName() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getValidation().getStaleConnectionChecker().getClassName()));
                        break;
                    }
                    case STALECONNECTIONCHECKERPROPERTIES: {
                        if (ds == null || ds.getValidation() == null || ds.getValidation().getStaleConnectionChecker() == null || ds.getValidation().getStaleConnectionChecker().getConfigPropertiesMap() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry connProperty : ds.getValidation().getStaleConnectionChecker().getConfigPropertiesMap().entrySet()) {
                            valueBuf.append((String)connProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append((String)connProperty.getValue());
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case TRACKSTATEMENTS: {
                        if (ds == null || ds.getStatement() == null || ds.getStatement().getTrackStatements() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getStatement().getTrackStatements().name()));
                        break;
                    }
                    case VALIDATEONMATCH: {
                        if (ds == null || ds.getValidation() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getValidation().isValidateOnMatch()));
                        break;
                    }
                    case TRANSACTIONQUERYTIMEOUT: {
                        if (ds == null || ds.getTimeOut() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getTimeOut().isSetTxQueryTimeout()));
                        break;
                    }
                    case QUERYTIMEOUT: {
                        if (ds == null || ds.getTimeOut() == null || ds.getTimeOut().getQueryTimeout() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getTimeOut().getQueryTimeout()));
                        break;
                    }
                    case USETRYLOCK: {
                        if (ds == null || ds.getTimeOut() == null || ds.getTimeOut().getUseTryLock() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getTimeOut().getUseTryLock()));
                        break;
                    }
                    case DRIVERCLASS: {
                        if (ds == null || ds.getDriverClass() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getDriverClass()));
                        break;
                    }
                    case DATASOURCECLASS: {
                        if (ds == null || ds.getDataSourceClass() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getDataSourceClass()));
                        break;
                    }
                    case URLPROPERTY: 
                    case CONNECTIONPROPERTIES: {
                        if (ds == null || ds.getConnectionProperties() == null) break;
                        StringBuffer valueBuf = new StringBuffer();
                        for (Map.Entry connProperty : ds.getConnectionProperties().entrySet()) {
                            valueBuf.append((String)connProperty.getKey());
                            valueBuf.append("=");
                            valueBuf.append((String)connProperty.getValue());
                            valueBuf.append(";");
                        }
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, valueBuf.toString()));
                        break;
                    }
                    case CONNECTIONURL: {
                        if (ds == null || ds.getConnectionUrl() == null) break;
                        configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, ds.getConnectionUrl()));
                        break;
                    }
                }
            }
            if (ds != null) {
                for (Map.Entry entry : ds.getConnectionProperties().entrySet()) {
                    prototype = ConfigPropertyFactory.Prototype.forName((String)entry.getKey());
                    if (prototype == ConfigPropertyFactory.Prototype.UNKNOWN) continue;
                    configProperties.add(ConfigPropertyFactory.createConfigProperty(prototype, (String)entry.getValue()));
                }
            }
            return configProperties;
        }
        return null;
    }

    protected static class ConfigPropertyFactory {
        protected ConfigPropertyFactory() {
        }

        public static ConfigProperty createConfigProperty(Prototype prototype, String value) {
            return new ConfigPropertyImpl(prototype.getDescription(), prototype.getLocalName(), prototype.getLocalType(), new XsdString(value, null), null);
        }

        public static ConfigProperty createConfigProperty(Prototype prototype, boolean value) {
            return new ConfigPropertyImpl(prototype.getDescription(), prototype.getLocalName(), prototype.getLocalType(), new XsdString(String.valueOf(value), null), null);
        }

        public static ConfigProperty createConfigProperty(Prototype prototype, Number value) {
            return new ConfigPropertyImpl(prototype.getDescription(), prototype.getLocalName(), prototype.getLocalType(), new XsdString(String.valueOf(value), null), null);
        }

        static enum Prototype {
            UNKNOWN(null, null, null),
            DRIVERCLASS("DriverClass", "java.lang.String", "The jdbc driver class."),
            DATASOURCECLASS("DataSourceClass", "java.lang.String", "The jdbc datasource class."),
            CONNECTIONURL("ConnectionURL", "java.lang.String", "The jdbc connection url class."),
            CONNECTIONPROPERTIES("ConnectionProperties", "java.lang.String", "Connection properties for the database."),
            USERNAME("UserName", "java.lang.String", "The default user name used to create JDBC connections."),
            PASSWORD("Password", "java.lang.String", "The default password used to create JDBC connections."),
            XADATASOURCEPROPERTIES("XADataSourceProperties", "java.lang.String", "The properties to set up the XA driver. These properties must be in the form name1=value1;name2=value2;...namen=valuen"),
            URLDELIMITER("URLDelimiter", "java.lang.String", "The jdbc connection url delimeter."),
            URLPROPERTY("URLProperty", "java.lang.String", "The property that contains the list of URLs."),
            URLSELECTORSTRATEGYCLASSNAME("UrlSelectorStrategyClassName", "java.lang.String", "The configurable URLSelectorStrategy class name."),
            XADATASOURCECLASS("XADataSourceClass", "java.lang.String", "The class name of the JDBC XA driver that handlesthis JDBC URL."),
            TRANSACTIONISOLATION("TransactionIsolation", "java.lang.String", "The transaction isolation for new connections. Not necessary: the driver default will be used if ommitted."),
            PREPAREDSTATEMENTCACHESIZE("PreparedStatementCacheSize", "java.lang.Integer", "The number of cached prepared statements per connection."),
            SHAREPREPAREDSTATEMENTS("SharePreparedStatements", "java.lang.Boolean", "Whether to share prepared statements."),
            NEWCONNECTIONSQL("NewConnectionSQL", "java.lang.String", "An SQL statement to be executed when a new connection is created as auxillary setup."),
            CHECKVALIDCONNECTIONSQL("CheckValidConnectionSQL", "java.lang.String", "An SQL statement that may be executed when a managed connection is taken out of the pool and is about to be given to a client: the purpose is to verify that the connection still works."),
            VALIDCONNECTIONCHECKERCLASSNAME("ValidConnectionCheckerClassName", "java.lang.String", "The fully qualified name of a class implementing org.jboss.jca.adapters.jdbc.ValidConnectionChecker that can determine for a particular vender db when a connection is valid."),
            VALIDCONNECTIONCHECKERPROPERTIES("ValidConnectionCheckerProperties", "java.lang.String", "The properties to inect into class implementing org.jboss.jca.adapters.jdbc.ValidConnectionChecker that can determine for a particular vender db when a connection is valid."),
            EXCEPTIONSORTERCLASSNAME("ExceptionSorterClassName", "java.lang.String", "The fully qualified name of a class implementing org.jboss.jca.adapters.jdbc.ExceptionSorter that can determine for a particular vender db which exceptions are fatal and mean a connection should be discarded."),
            EXCEPTIONSORTERPROPERTIES("ExceptionSorterProperties", "java.lang.String", "The properties to inect into  class implementing org.jboss.jca.adapters.jdbc.ExceptionSorter that can determine for a particular vender db which exceptions are fatal and mean a connection should be discarded."),
            STALECONNECTIONCHECKERCLASSNAME("StaleConnectionCheckerClassName", "java.lang.String", "The fully qualified name of a class implementing org.jboss.jca.adapters.jdbc.StaleConnectionChecker that can determine for a particular vender db when a connection is stale."),
            STALECONNECTIONCHECKERPROPERTIES("StaleConnectionCheckerProperties", "java.lang.String", "The properties to inect into  class implementing org.jboss.jca.adapters.jdbc.StaleConnectionChecker that can determine for a particular vender db when a connection is stale."),
            TRACKSTATEMENTS("TrackStatements", "java.lang.String", "Whether to track unclosed statements - false/true/nowarn"),
            VALIDATEONMATCH("ValidateOnMatch", "java.lang.Boolean", "Whether to validate the connection on the ManagedConnectionFactory.matchManagedConnection method"),
            TRANSACTIONQUERYTIMEOUT("TransactionQueryTimeout", "java.lang.Boolean", "Whether to set the query timeout based on the transaction timeout"),
            QUERYTIMEOUT("QueryTimeout", "java.lang.Integer", "A configured query timeout"),
            USETRYLOCK("UseTryLock", "java.lang.Integer", "Maximum wait for a lock");

            private final XsdString localName;
            private final XsdString localType;
            private final ArrayList<LocalizedXsdString> description = new ArrayList(1);
            private static final Map<String, Prototype> MAP;

            private Prototype(String name, String type, String description) {
                this.localName = new XsdString(name, null);
                this.localType = new XsdString(type, null);
                this.description.add(new LocalizedXsdString(description, null));
            }

            public final XsdString getLocalName() {
                return this.localName;
            }

            public final XsdString getLocalType() {
                return this.localType;
            }

            public final List<LocalizedXsdString> getDescription() {
                return this.description;
            }

            public static Prototype forName(String localName) {
                Prototype element = MAP.get(localName);
                return element == null ? UNKNOWN : element;
            }

            static {
                HashMap<String, Prototype> map = new HashMap<String, Prototype>();
                for (Prototype element : Prototype.values()) {
                    String name = element.getLocalName().getValue();
                    if (name == null) continue;
                    map.put(name, element);
                }
                MAP = map;
            }
        }
    }
}

