/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.List;
import java.util.Map;
import org.hibernate.internal.util.Value;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.binder.SingularAttributeSource;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLHibernateMapping;

class VersionAttributeSourceImpl
implements SingularAttributeSource {
    private final XMLHibernateMapping.XMLClass.XMLVersion versionElement;
    private final LocalBindingContext bindingContext;
    private final List<RelationalValueSource> valueSources;
    private final ExplicitHibernateTypeSource typeSource = new ExplicitHibernateTypeSource(){

        @Override
        public String getName() {
            return VersionAttributeSourceImpl.this.versionElement.getType() == null ? "integer" : VersionAttributeSourceImpl.this.versionElement.getType();
        }

        @Override
        public Map<String, String> getParameters() {
            return null;
        }
    };
    private Value<PropertyGeneration> propertyGenerationValue = new Value<3>(new Value.DeferredInitializer<PropertyGeneration>(){

        @Override
        public PropertyGeneration initialize() {
            PropertyGeneration propertyGeneration;
            PropertyGeneration propertyGeneration2 = propertyGeneration = VersionAttributeSourceImpl.this.versionElement.getGenerated() == null ? PropertyGeneration.NEVER : PropertyGeneration.parse(VersionAttributeSourceImpl.this.versionElement.getGenerated().value());
            if (propertyGeneration == PropertyGeneration.INSERT) {
                throw new MappingException("'generated' attribute cannot be 'insert' for versioning property", VersionAttributeSourceImpl.this.bindingContext.getOrigin());
            }
            return propertyGeneration;
        }
    });

    VersionAttributeSourceImpl(final XMLHibernateMapping.XMLClass.XMLVersion versionElement, LocalBindingContext bindingContext) {
        this.versionElement = versionElement;
        this.bindingContext = bindingContext;
        this.valueSources = Helper.buildValueSources(new Helper.ValueSourcesAdapter(){

            @Override
            public String getColumnAttribute() {
                return versionElement.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return null;
            }

            @Override
            public List getColumnOrFormulaElements() {
                return versionElement.getColumn();
            }

            @Override
            public String getContainingTableName() {
                return null;
            }

            @Override
            public boolean isIncludedInInsertByDefault() {
                return Helper.getBooleanValue(versionElement.isInsert(), true);
            }

            @Override
            public boolean isIncludedInUpdateByDefault() {
                return true;
            }
        }, bindingContext);
    }

    @Override
    public String getName() {
        return this.versionElement.getName();
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return this.typeSource;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.versionElement.getAccess();
    }

    @Override
    public boolean isInsertable() {
        return Helper.getBooleanValue(this.versionElement.isInsert(), true);
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public PropertyGeneration getGeneration() {
        return this.propertyGenerationValue.getValue();
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return false;
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.BASIC;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return true;
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return true;
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return true;
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return this.valueSources;
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.versionElement.getMeta());
    }
}

