/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.Timer;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class EjbComponentInstance
extends BasicComponentInstance {
    private final Map<Method, Interceptor> timeoutInterceptors;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    protected EjbComponentInstance(BasicComponent component, AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Method, Interceptor> timeoutInterceptors) {
        super(component, instanceReference, preDestroyInterceptor, methodInterceptors);
        this.timeoutInterceptors = timeoutInterceptors;
    }

    public void invokeTimeoutMethod(Method method, Timer timer) {
        Interceptor interceptor = this.timeoutInterceptors.get(method);
        if (interceptor == null) {
            throw new RuntimeException("Unknown timeout method " + method);
        }
        try {
            InterceptorContext context = this.prepareInterceptorContext();
            context.setMethod(method);
            context.setTimer((Object)timer);
            context.setTarget(this.getInstance());
            Object[] params = method.getParameterTypes().length == 1 ? new Object[]{timer} : EMPTY_OBJECT_ARRAY;
            context.setParameters(params);
            interceptor.processInvocation(context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void invokeTimeoutMethod(Timer timer) {
        EJBComponent component = (EJBComponent)this.getComponent();
        Method method = component.getTimeoutMethod();
        if (method == null) {
            throw new IllegalArgumentException("Component " + component.getComponentName() + " does not have a timeout method");
        }
        this.invokeTimeoutMethod(method, timer);
    }
}

