/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class StatefulComponentInstanceInterceptor
extends AbstractEJBInterceptor {
    private static final Logger log = Logger.getLogger(StatefulComponentInstanceInterceptor.class);
    private final AtomicReference<Serializable> sessionIdReference;

    public StatefulComponentInstanceInterceptor(AtomicReference<Serializable> sessionIdReference) {
        this.sessionIdReference = sessionIdReference;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionComponent component = StatefulComponentInstanceInterceptor.getComponent(context, StatefulSessionComponent.class);
        Serializable sessionId = this.sessionIdReference.get();
        if (sessionId == null) {
            throw new IllegalStateException("Session id hasn't been set for stateful component: " + component.getComponentName());
        }
        log.debug((Object)("Looking for stateful component instance with session id: " + sessionId));
        StatefulSessionComponentInstance instance = component.getCache().get(sessionId);
        try {
            context.putPrivateData(ComponentInstance.class, (Object)instance);
            Object object = context.proceed();
            return object;
        }
        catch (Exception ex) {
            if (component.getApplicationException(ex.getClass(), context.getMethod()) != null) {
                throw ex;
            }
            if (ex instanceof ConcurrentAccessTimeoutException || ex instanceof ConcurrentAccessException) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing bean " + sessionId + " because of exception"), (Throwable)ex);
                }
                component.getCache().discard(sessionId);
            }
            throw ex;
        }
        catch (Error e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing bean " + sessionId + " because of error"), (Throwable)e);
            }
            component.getCache().discard(sessionId);
            throw e;
        }
        catch (Throwable t) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing bean " + sessionId + " because of Throwable"), t);
            }
            component.getCache().discard(sessionId);
            throw new RuntimeException(t);
        }
        finally {
            context.putPrivateData(ComponentInstance.class, null);
        }
    }

    static StatefulSessionComponentInstance getComponentInstance(InterceptorContext context) {
        return (StatefulSessionComponentInstance)context.getPrivateData(ComponentInstance.class);
    }
}

