/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.Random;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.channels.ConnectedMessageChannel;

final class RemoteReadListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnectionHandler handler;
    private final RemoteConnection connection;

    RemoteReadListener(final RemoteConnectionHandler handler, final RemoteConnection connection) {
        connection.getChannel().getCloseSetter().set((ChannelListener)new ChannelListener<Channel>(){

            public void handleEvent(Channel channel) {
                connection.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        handler.handleClose();
                    }
                });
            }
        });
        this.handler = handler;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleEvent(ConnectedMessageChannel channel) {
        try {
            pooled = this.connection.allocate();
            buffer = (ByteBuffer)pooled.getResource();
            ** try [egrp 1[TRYBLOCK] [14 : 19->56)] { 
lbl5:
            // 1 sources

            ** GOTO lbl-1000
lbl6:
            // 1 sources

            finally {
                pooled.free();
            }
        }
        catch (IOException e) {
            this.connection.handleException(e);
            return;
        }
lbl-1000:
        // 1 sources

        {
            while (true) {
                try {
                    block45: while (true) {
                        if ((res = channel.receive(buffer)) == -1) {
                            RemoteLogger.log.trace("Received connection end-of-stream");
                            this.connection.handleIncomingCloseRequest();
                            return;
                        }
                        if (res == 0) {
                            return;
                        }
                        buffer.flip();
                        protoId = buffer.get();
                        try {
                            switch (protoId) {
                                case -16: {
                                    break;
                                }
                                case -1: {
                                    RemoteLogger.log.trace("Received connection close request");
                                    this.connection.handleIncomingCloseRequest();
                                    return;
                                }
                                case 16: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    inboundWindow = 16384;
                                    outboundWindow = 16384;
                                    inboundMessages = 4;
                                    outboundMessages = 4;
                                    serviceType = null;
                                    block46: while (true) {
                                        b = buffer.get() & 255;
                                        switch (b) {
                                            case 0: {
                                                break block46;
                                            }
                                            case 1: {
                                                serviceType = ProtocolUtils.readString(buffer);
                                                continue block46;
                                            }
                                            case 128: {
                                                outboundWindow = ProtocolUtils.readInt(buffer);
                                                continue block46;
                                            }
                                            case 129: {
                                                outboundMessages = ProtocolUtils.readUnsignedShort(buffer);
                                                continue block46;
                                            }
                                            default: {
                                                Buffers.skip((Buffer)buffer, (int)(buffer.get() & 255));
                                                continue block46;
                                            }
                                        }
                                        break;
                                    }
                                    if (serviceType == null) {
                                        // empty if block
                                    }
                                    connectionChannel = new RemoteConnectionChannel(this.handler.getConnectionContext().getConnectionProviderContext().getExecutor(), this.connection, channelId, new Random(), outboundWindow, inboundWindow, outboundMessages, inboundMessages);
                                    this.handler.addChannel(connectionChannel);
                                    this.handler.getConnectionContext().openService(connectionChannel, serviceType);
                                    pooledReply = this.connection.allocate();
                                    try {
                                        replyBuffer = (ByteBuffer)pooledReply.getResource();
                                        replyBuffer.clear();
                                        replyBuffer.put((byte)17);
                                        replyBuffer.putInt(channelId);
                                        ProtocolUtils.writeInt(replyBuffer, 128, outboundWindow);
                                        ProtocolUtils.writeShort(replyBuffer, 129, outboundMessages);
                                        replyBuffer.put((byte)0);
                                        replyBuffer.flip();
                                        this.connection.send(pooledReply);
                                        continue block45;
                                    }
                                    finally {
                                        pooledReply.free();
                                        continue block45;
                                    }
                                }
                                case 48: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) {
                                        this.connection.handleException(new IOException("Message data for non-existent channel"));
                                        break;
                                    }
                                    connectionChannel.handleMessageData(pooled);
                                    pooled = this.connection.allocate();
                                    buffer = (ByteBuffer)pooled.getResource();
                                    break;
                                }
                                case 49: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) {
                                        this.connection.handleException(new IOException("Window open for non-existent channel"));
                                        break;
                                    }
                                    connectionChannel.handleWindowOpen(pooled);
                                    break;
                                }
                                case 50: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) break;
                                    connectionChannel.handleAsyncClose(pooled);
                                    break;
                                }
                                case 33: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) break;
                                    connectionChannel.handleRemoteClose();
                                    break;
                                }
                                case 32: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    connectionChannel = this.handler.getChannel(channelId);
                                    if (connectionChannel == null) break;
                                    connectionChannel.handleWriteShutdown();
                                    break;
                                }
                                case 17: {
                                    channelId = buffer.getInt() ^ -2147483648;
                                    if ((channelId & -2147483648) == 0 || (pendingChannel = this.handler.removePendingChannel(channelId)) == null) break;
                                    outboundWindow = pendingChannel.getOutboundWindowSize();
                                    inboundWindow = pendingChannel.getInboundWindowSize();
                                    outboundMessageCount = pendingChannel.getOutboundMessageCount();
                                    inboundMessageCount = pendingChannel.getInboundMessageCount();
                                    block47: while (true) {
                                        switch (buffer.get() & 255) {
                                            case 128: {
                                                outboundWindow = ProtocolUtils.readInt(buffer);
                                                continue block47;
                                            }
                                            case 129: {
                                                outboundMessageCount = ProtocolUtils.readUnsignedShort(buffer);
                                                continue block47;
                                            }
                                            case 0: {
                                                break block47;
                                            }
                                            default: {
                                                Buffers.skip((Buffer)buffer, (int)(buffer.get() & 255));
                                                continue block47;
                                            }
                                        }
                                        break;
                                    }
                                    newChannel = new RemoteConnectionChannel(this.handler.getConnectionContext().getConnectionProviderContext().getExecutor(), this.connection, channelId, new Random(), outboundWindow, inboundWindow, outboundMessageCount, inboundMessageCount);
                                    this.handler.putChannel(newChannel);
                                    pendingChannel.getResult().setResult((Object)newChannel);
                                    break;
                                }
                                default: {
                                    RemoteLogger.log.unknownProtocolId(protoId);
                                }
                            }
                        }
                        catch (BufferUnderflowException e) {
                            RemoteLogger.log.bufferUnderflow(protoId);
                        }
                    }
                }
                catch (BufferUnderflowException e) {
                    RemoteLogger.log.bufferUnderflowRaw();
                    continue;
                }
                finally {
                    buffer.clear();
                    continue;
                }
                break;
            }
        }
    }
}

