/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.server.services.path.RelativePathService;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemDescriptions;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.WebVirtualHostService;
import org.jboss.as.web.WelcomeContextService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class WebVirtualHostAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static final WebVirtualHostAdd INSTANCE = new WebVirtualHostAdd();
    private static final String DEFAULT_RELATIVE_TO = "jboss.server.log.dir";
    private static final String TEMP_DIR = "jboss.server.temp.dir";
    private static final String HOME_DIR = "jboss.home.dir";
    private static final String[] NO_ALIASES = new String[0];

    private WebVirtualHostAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("alias").set(operation.get("alias"));
        model.get("access-log").set(operation.get("access-log"));
        model.get("rewrite").set(operation.get("rewrite"));
        model.get("sso").set(operation.get("sso"));
        model.get("default-web-module").set(operation.get("default-web-module"));
        boolean welcome = operation.hasDefined("enable-welcome-root") && operation.get("enable-welcome-root").asBoolean();
        model.get("enable-welcome-root").set(welcome);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        boolean welcome = operation.hasDefined("enable-welcome-root") && operation.get("enable-welcome-root").asBoolean();
        ServiceTarget serviceTarget = context.getServiceTarget();
        WebVirtualHostService service = new WebVirtualHostService(name, WebVirtualHostAdd.aliases(operation), welcome);
        ServiceBuilder serviceBuilder = serviceTarget.addService(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name}), (Service)service).addDependency(AbstractPathService.pathNameOf((String)TEMP_DIR), String.class, service.getTempPathInjector()).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getWebServer());
        if (operation.hasDefined("access-log")) {
            ModelNode accessLog = operation.get("access-log");
            service.setAccessLog(accessLog.clone());
            WebVirtualHostAdd.accessLogService(name, accessLog, serviceTarget);
            serviceBuilder.addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name, "access-log"}), String.class, service.getAccessLogPathInjector());
        }
        if (operation.hasDefined("rewrite")) {
            service.setRewrite(operation.get("rewrite").clone());
        }
        if (operation.hasDefined("sso")) {
            service.setSso(operation.get("sso").clone());
        }
        if (operation.hasDefined("default-web-module")) {
            if (welcome) {
                throw new OperationFailedException(new ModelNode().set("A default module can not be specified when the welcome root is enabled."));
            }
            service.setDefaultWebModule(operation.get("default-web-module").asString());
        }
        serviceBuilder.addListener((ServiceListener)verificationHandler);
        newControllers.add(serviceBuilder.install());
        if (welcome) {
            WelcomeContextService welcomeService = new WelcomeContextService();
            newControllers.add(context.getServiceTarget().addService(WebSubsystemServices.JBOSS_WEB.append(new String[]{name}).append(new String[]{"welcome"}), (Service)welcomeService).addDependency(AbstractPathService.pathNameOf((String)HOME_DIR), String.class, welcomeService.getPathInjector()).addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name}), VirtualHost.class, welcomeService.getHostInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, HttpManagementService.SERVICE_NAME, HttpManagement.class, welcomeService.getHttpManagementInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        }
    }

    static String[] aliases(ModelNode node) {
        if (node.hasDefined("alias")) {
            ModelNode aliases = node.require("alias");
            int size = aliases.asInt();
            String[] array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = aliases.get(i).asString();
            }
            return array;
        }
        return NO_ALIASES;
    }

    static void accessLogService(String hostName, ModelNode element, ServiceTarget target) {
        if (element.has("access-log")) {
            ModelNode accessLog = element.get("access-log");
            String relativeTo = accessLog.has("relative-to") ? accessLog.get("relative-to").asString() : DEFAULT_RELATIVE_TO;
            String path = accessLog.has("path") ? accessLog.get("path").asString() : hostName;
            RelativePathService.addService((ServiceName)WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{hostName, "access-log"}), (String)path, (String)relativeTo, (ServiceTarget)target);
        } else {
            RelativePathService.addService((ServiceName)WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{hostName, "access-log"}), (String)hostName, (String)DEFAULT_RELATIVE_TO, (ServiceTarget)target);
        }
    }

    static ModelNode getAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        if (subModel.hasDefined("alias")) {
            operation.get("alias").set(subModel.get("alias"));
        }
        if (subModel.hasDefined("access-log")) {
            operation.get("access-log").set(subModel.get("access-log"));
        }
        if (subModel.hasDefined("rewrite")) {
            operation.get("rewrite").set(subModel.get("rewrite"));
        }
        if (subModel.hasDefined("sso")) {
            operation.get("sso").set(subModel.get("sso"));
        }
        if (subModel.hasDefined("enable-welcome-root")) {
            operation.get("enable-welcome-root").set(subModel.get("enable-welcome-root"));
        }
        return operation;
    }

    public ModelNode getModelDescription(Locale locale) {
        return WebSubsystemDescriptions.getVirtualServerAdd(locale);
    }
}

