/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.HashMap;
import java.util.Map;

enum JacORBAttribute {
    UNKNOWN(null, null),
    ORB_NAME("name", "jacorb.implname"),
    ORB_PRINT_VERSION("print-version", "jacorb.orb.print_version"),
    ORB_USE_IMR("use-imr", "jacorb.use_imr"),
    ORB_USE_BOM("use-bom", "jacorb.use_bom"),
    ORB_CACHE_TYPECODES("cache-typecodes", "jacorb.cacheTypecodes"),
    ORB_CACHE_POA_NAMES("cache-poa-names", "jacorb.cachePoaNames"),
    ORB_GIOP_MINOR_VERSION("giop-minor-version", "jacorb.giop_minor_version"),
    ORB_CONN_RETRIES("retries", "jacorb.retries"),
    ORB_CONN_RETRY_INTERVAL("retry-interval", "jacorb.retry_interval"),
    ORB_CONN_CLIENT_TIMEOUT("client-timeout", "jacorb.connection.client.idle_timeout"),
    ORB_CONN_SERVER_TIMEOUT("server-timeout", "jacorb.connection.server.timeout"),
    ORB_CONN_MAX_SERVER_CONNECTIONS("max-server-connections", "jacorb.connection.max_server_connections"),
    ORB_CONN_MAX_MANAGED_BUF_SIZE("max-managed-buf-size", "jacorb.maxManagedBufSize"),
    ORB_CONN_OUTBUF_SIZE("outbuf-size", "jacorb.outbuf_size"),
    ORB_CONN_OUTBUF_CACHE_TIMEOUT("outbuf-cache-timeout", "jacorb.bufferManagerMaxFlush"),
    ORB_NAMING_EXPORT_CORBALOC("export-corbaloc", null),
    ORB_NAMING_ROOT_CONTEXT("root-context", null),
    POA_MONITORING("monitoring", "jacorb.poa.monitoring"),
    POA_QUEUE_WAIT("queue-wait", "jacorb.poa.queue_wait"),
    POA_QUEUE_MIN("queue-min", "jacorb.poa.queue_min"),
    POA_QUEUE_MAX("queue-max", "jacorb.poa.queue.max"),
    POA_REQUEST_PROC_POOL_SIZE("pool-size", "jacorb.poa.thread_pool_min"),
    POA_REQUEST_PROC_MAX_THREADS("max-threads", "jacorb.poa.thread_pool_max"),
    INTEROP_SUN("sun", "jacorb.interop.sun"),
    INTEROP_COMET("comet", "jacorb.interop.comet"),
    INTEROP_CHUNK_RMI_VALUETYPES("chunk-custom-rmi-valuetypes", "jacorb.interop.chunk_custom_rmi_valuetypes"),
    INTEROP_LAX_BOOLEAN_ENCODING("lax-boolean-encoding", "jacorb.interop.lax_boolean_encoding"),
    INTEROP_INDIRECTION_ENCODING_DISABLE("indirection-encoding-disable", "jacorb.interop.indirection_encoding_disable"),
    INTEROP_STRICT_CHECK_ON_TC_CREATION("strict-check-on-tc-creation", "jacorb.interop.strict_check_on_tc_creation"),
    SECURITY_SUPPORT_SSL("support-ssl", "jacorb.security.support_ssl"),
    SECURITY_ADD_COMPONENT_INTERCEPTOR("add-component-via-interceptor", "jacorb.security.ssl_components_added_by_ior_interceptor"),
    SECURITY_CLIENT_SUPPORTS("client-supports", "jacorb.security.ssl.client.supported_options"),
    SECURITY_CLIENT_REQUIRES("client-requires", "jacorb.security.ssl.client.required_options"),
    SECURITY_SERVER_SUPPORTS("server-supports", "jacorb.security.ssl.server.supported_options"),
    SECURITY_SERVER_REQUIRES("server-requires", "jacorb.security.ssl.server.required_options"),
    SECURITY_USE_DOMAIN_SF("use-domain-socket-factory", null),
    SECURITY_USE_DOMAIN_SSF("use-domain-server-socket-factory", null),
    PROP_KEY("key", null),
    PROP_VALUE("value", null);

    private final String name;
    private final String jacorbName;
    private static final Map<String, JacORBAttribute> MAP;

    private JacORBAttribute(String name, String jacORBName) {
        this.name = name;
        this.jacorbName = jacORBName;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getJacORBName() {
        return this.jacorbName;
    }

    public static JacORBAttribute forName(String localName) {
        JacORBAttribute attribute = MAP.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, JacORBAttribute> map = new HashMap<String, JacORBAttribute>();
        for (JacORBAttribute attribute : JacORBAttribute.values()) {
            String name = attribute.name;
            if (name == null) continue;
            map.put(name, attribute);
        }
        MAP = map;
    }
}

