/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MessagingDescriptions {
    static final String RESOURCE_NAME = MessagingDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private MessagingDescriptions() {
    }

    public static ModelNode getRootResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("messaging"));
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "messaging", node);
        }
        node.get(new String[]{"attributes", "acceptor", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "acceptor", "description"}).set(bundle.getString("acceptor"));
        node.get(new String[]{"attributes", "address-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "address-setting", "description"}).set(bundle.getString("address-setting"));
        node.get(new String[]{"attributes", "bindings-directory"}).set(MessagingDescriptions.getPathDescription("bindings.directory", bundle));
        node.get(new String[]{"attributes", "journal-directory"}).set(MessagingDescriptions.getPathDescription("journal.directory", bundle));
        node.get(new String[]{"attributes", "large-messages-directory"}).set(MessagingDescriptions.getPathDescription("large.messages.directory", bundle));
        node.get(new String[]{"attributes", "paging-directory"}).set(MessagingDescriptions.getPathDescription("paging.directory", bundle));
        node.get(new String[]{"attributes", "connector", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "connector", "description"}).set(bundle.getString("connector"));
        node.get(new String[]{"attributes", "security-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "security-setting", "description"}).set(bundle.getString("security-setting"));
        node.get("operations");
        node.get(new String[]{"children", "broadcast-group", "description"}).set(bundle.getString("broadcast-group"));
        node.get(new String[]{"children", "broadcast-group", "min-occurs"}).set(0);
        node.get(new String[]{"children", "broadcast-group", "model-description"});
        node.get(new String[]{"children", "discovery-group", "description"}).set(bundle.getString("discovery-group"));
        node.get(new String[]{"children", "discovery-group", "min-occurs"}).set(0);
        node.get(new String[]{"children", "discovery-group", "model-description"});
        node.get(new String[]{"children", "divert", "description"}).set(bundle.getString("divert"));
        node.get(new String[]{"children", "divert", "min-occurs"}).set(0);
        node.get(new String[]{"children", "divert", "model-description"});
        node.get(new String[]{"children", "queue", "description"}).set(bundle.getString("queue"));
        node.get(new String[]{"children", "queue", "min-occurs"}).set(0);
        node.get(new String[]{"children", "queue", "model-description"});
        node.get(new String[]{"children", "grouping-handler", "description"}).set(bundle.getString("grouping-handler"));
        node.get(new String[]{"children", "grouping-handler", "min-occurs"}).set(0);
        node.get(new String[]{"children", "grouping-handler", "max-occurs"}).set(1);
        node.get(new String[]{"children", "grouping-handler", "model-description"});
        node.get(new String[]{"children", "bridge", "description"}).set(bundle.getString("bridge"));
        node.get(new String[]{"children", "bridge", "min-occurs"}).set(0);
        node.get(new String[]{"children", "bridge", "model-description"});
        node.get(new String[]{"children", "cluster-connection", "description"}).set(bundle.getString("cluster-connection"));
        node.get(new String[]{"children", "cluster-connection", "min-occurs"}).set(0);
        node.get(new String[]{"children", "cluster-connection", "model-description"});
        node.get(new String[]{"children", "queue", "description"}).set(bundle.getString("queue"));
        node.get(new String[]{"children", "queue", "min-occurs"}).set(0);
        node.get(new String[]{"children", "queue", "model-description"});
        node.get(new String[]{"children", "connector-service", "description"}).set(bundle.getString("connector-service"));
        node.get(new String[]{"children", "connector-service", "min-occurs"}).set(0);
        node.get(new String[]{"children", "connector-service", "model-description"});
        node.get(new String[]{"children", "connection-factory", "description"}).set(bundle.getString("connection-factory"));
        node.get(new String[]{"children", "connection-factory", "min-occurs"}).set(0);
        node.get(new String[]{"children", "connection-factory", "model-description"});
        node.get(new String[]{"children", "pooled-connection-factory", "description"}).set(bundle.getString("pooled-connection-factory"));
        node.get(new String[]{"children", "pooled-connection-factory", "min-occurs"}).set(0);
        node.get(new String[]{"children", "pooled-connection-factory", "model-description"});
        node.get(new String[]{"children", "jms-queue", "description"}).set(bundle.getString("jms-queue"));
        node.get(new String[]{"children", "jms-queue", "min-occurs"}).set(0);
        node.get(new String[]{"children", "jms-queue", "model-description"});
        node.get(new String[]{"children", "jms-topic", "description"}).set(bundle.getString("topic"));
        node.get(new String[]{"children", "jms-topic", "min-occurs"}).set(0);
        node.get(new String[]{"children", "jms-topic", "model-description"});
        return node;
    }

    public static ModelNode getSubsystemAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("messaging.add"));
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "messaging", node);
        }
        node.get(new String[]{"request-properties", "acceptor", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "acceptor", "description"}).set(bundle.getString("acceptor"));
        node.get(new String[]{"request-properties", "address-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "address-setting", "description"}).set(bundle.getString("address-setting"));
        node.get(new String[]{"request-properties", "bindings-directory"}).set(MessagingDescriptions.getPathDescription("bindings.directory", bundle));
        node.get(new String[]{"request-properties", "bindings-directory", "required"}).set(false);
        node.get(new String[]{"request-properties", "journal-directory"}).set(MessagingDescriptions.getPathDescription("journal.directory", bundle));
        node.get(new String[]{"request-properties", "journal-directory", "required"}).set(false);
        node.get(new String[]{"request-properties", "large-messages-directory"}).set(MessagingDescriptions.getPathDescription("large.messages.directory", bundle));
        node.get(new String[]{"request-properties", "large-messages-directory", "required"}).set(false);
        node.get(new String[]{"request-properties", "paging-directory"}).set(MessagingDescriptions.getPathDescription("paging.directory", bundle));
        node.get(new String[]{"request-properties", "paging-directory", "required"}).set(false);
        node.get(new String[]{"request-properties", "connector", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "connector", "description"}).set(bundle.getString("connector"));
        node.get(new String[]{"request-properties", "security-setting", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"request-properties", "security-setting", "description"}).set(bundle.getString("security-setting"));
        return node;
    }

    public static ModelNode getSubsystemRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("divert.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    public static ModelNode getQueueResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString("queue"));
        for (AttributeDefinition attr : CommonAttributes.CORE_QUEUE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "queue", node);
        }
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getQueueAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("queue.add"));
        for (AttributeDefinition attr : CommonAttributes.CORE_QUEUE_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "queue", node);
        }
        return node;
    }

    public static ModelNode getQueueRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle.getString("queue.remove"));
        return node;
    }

    static ModelNode getJmsQueueResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("jms-queue"));
        for (AttributeDefinition attr : CommonAttributes.JMS_QUEUE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "jms-queue", node);
        }
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getJmsQueueAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("jms-queue.add"));
        for (AttributeDefinition attr : CommonAttributes.JMS_QUEUE_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "jms-queue", node);
        }
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getJmsQueueRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("jms-queue.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getTopic(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("topic"));
        CommonAttributes.ENTRIES.addResourceAttributeDescription(bundle, "topic", node);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getTopicAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("topic.add"));
        CommonAttributes.ENTRIES.addOperationParameterDescription(bundle, "topic", node);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getTopicRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("topic.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectionFactory(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("connection-factory"));
        MessagingDescriptions.addConnectionFactoryProperties(bundle, node, true);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    static ModelNode getConnectionFactoryAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("connection-factory.add"));
        MessagingDescriptions.addConnectionFactoryProperties(bundle, node, false);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    static ModelNode getPooledConnectionFactory(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle.getString("pooled-connection-factory"));
        MessagingDescriptions.addPooledConnectionFactoryProperties(bundle, node, true);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    static ModelNode getPooledConnectionFactoryAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle.getString("pooled-connection-factory.add"));
        MessagingDescriptions.addPooledConnectionFactoryProperties(bundle, node, false);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static void addPooledConnectionFactoryProperties(ResourceBundle bundle, ModelNode node, boolean resource) {
        for (AttributeDefinition attr : JMSServices.POOLED_CONNECTION_FACTORY_ATTRS) {
            if (resource) {
                attr.addResourceAttributeDescription(bundle, "pooled-connection-factory", node);
            } else {
                attr.addOperationParameterDescription(bundle, "pooled-connection-factory", node);
            }
            if (!attr.getName().equals("connector")) continue;
            String propType = resource ? "attributes" : "request-properties";
            node.get(new String[]{propType, attr.getName(), "value-type"}).set(MessagingDescriptions.getConnectionFactoryConnectionValueType(bundle, propType));
        }
    }

    static ModelNode getPooledConnectionFactoryRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("pooled-connection-factory.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    private static void addConnectionFactoryProperties(ResourceBundle bundle, ModelNode node, boolean resource) {
        for (AttributeDefinition attr : JMSServices.CONNECTION_FACTORY_ATTRS) {
            if (resource) {
                attr.addResourceAttributeDescription(bundle, "connection-factory", node);
            } else {
                attr.addOperationParameterDescription(bundle, "connection-factory", node);
            }
            if (!attr.getName().equals("connector")) continue;
            String propType = resource ? "attributes" : "request-properties";
            node.get(new String[]{propType, attr.getName(), "value-type"}).set(MessagingDescriptions.getConnectionFactoryConnectionValueType(bundle, propType));
        }
    }

    private static ModelNode getConnectionFactoryConnectionValueType(ResourceBundle bundle, String propType) {
        ModelNode node = new ModelNode().set("TBD");
        return node;
    }

    static ModelNode getConnectionFactoryRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("connection-factory.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getDivertResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("divert"));
        for (AttributeDefinition attr : CommonAttributes.DIVERT_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "divert", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    static ModelNode getDivertAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("divert.add"));
        for (AttributeDefinition attr : CommonAttributes.DIVERT_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "divert", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getDivertRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("divert.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getBroadcastGroupResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("broadcast-group"));
        for (AttributeDefinition attr : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "broadcast-group", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    static ModelNode getBroadcastGroupAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("broadcast-group.add"));
        for (AttributeDefinition attr : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "broadcast-group", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getBroadcastGroupRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("broadcast-group.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getDiscoveryGroupResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("discovery-group"));
        for (AttributeDefinition attr : CommonAttributes.DISCOVERY_GROUP_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "discovery-group", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    static ModelNode getDiscoveryGroupAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("discovery-group.add"));
        for (AttributeDefinition attr : CommonAttributes.DISCOVERY_GROUP_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "discovery-group", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getDiscoveryGroupRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("discovery-group.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getGroupingHandlerResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("grouping-handler"));
        for (AttributeDefinition attr : CommonAttributes.GROUPING_HANDLER_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "grouping-handler", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getGroupingHandlerAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("grouping-handler.add"));
        for (AttributeDefinition attr : CommonAttributes.GROUPING_HANDLER_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "grouping-handler", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getGroupingHandlerRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("grouping-handler.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getBridgeResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("bridge"));
        for (AttributeDefinition attr : CommonAttributes.BRIDGE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "bridge", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getBridgeAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("bridge.add"));
        for (AttributeDefinition attr : CommonAttributes.BRIDGE_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "bridge", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getBridgeRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("bridge.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getClusterConnectionResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("cluster-connection"));
        for (AttributeDefinition attr : CommonAttributes.CLUSTER_CONNECTION_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "cluster-connection", root);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getClusterConnectionAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("cluster-connection.add"));
        for (AttributeDefinition attr : CommonAttributes.CLUSTER_CONNECTION_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "cluster-connection", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getClusterConnectionRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("cluster-connection.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectorServiceResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("connector-service"));
        for (AttributeDefinition attr : CommonAttributes.CONNECTOR_SERVICE_ATTRIBUTES) {
            attr.addResourceAttributeDescription(bundle, "connector-service", root);
        }
        root.get("operations");
        root.get(new String[]{"children", "param", "description"}).set(bundle.getString("connector-service.param"));
        root.get(new String[]{"children", "param", "min-occurs"}).set(0);
        root.get(new String[]{"children", "param", "model-description"});
        return root;
    }

    public static ModelNode getConnectorServiceAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("connector-service.add"));
        for (AttributeDefinition attr : CommonAttributes.CONNECTOR_SERVICE_ATTRIBUTES) {
            attr.addOperationParameterDescription(bundle, "connector-service", op);
        }
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectorServiceRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("connector-service.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectorServiceParamResource(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("connector-service.param"));
        CommonAttributes.VALUE.addResourceAttributeDescription(bundle, "connector-service.param", root);
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static ModelNode getConnectorServiceParamAdd(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("connector-service.param.add"));
        CommonAttributes.VALUE.addOperationParameterDescription(bundle, "connector-service.param", op);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectorServiceParamRemove(Locale locale) {
        ResourceBundle bundle = MessagingDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("connector-service.param.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    private static ModelNode getPathDescription(String description, ResourceBundle bundle) {
        ModelNode node = new ModelNode();
        node.get("type").set(ModelType.OBJECT);
        node.get("description").set(bundle.getString(description));
        node.get(new String[]{"attributes", "path", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "path", "description"}).set(bundle.getString("path.path"));
        node.get(new String[]{"attributes", "path", "required"}).set(false);
        node.get(new String[]{"attributes", "relative-to", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "relative-to", "description"}).set(bundle.getString("path.relative-to"));
        node.get(new String[]{"attributes", "relative-to", "required"}).set(false);
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

