/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.batch;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.factories.annotations.Inject;

public class BatchContainer {
    TransactionManager transactionManager;
    private BatchDetailsTl batchDetailsTl = new BatchDetailsTl();

    @Inject
    void inject(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public boolean startBatch() throws CacheException {
        return this.startBatch(false);
    }

    public boolean startBatch(boolean autoBatch) throws CacheException {
        BatchDetails bd = (BatchDetails)this.batchDetailsTl.get();
        try {
            if (this.transactionManager.getTransaction() == null && bd.tx == null) {
                this.transactionManager.begin();
                bd.nestedInvocationCount = 1;
                bd.suspendTxAfterInvocation = !autoBatch;
                bd.thread = Thread.currentThread();
                bd.tx = autoBatch ? this.transactionManager.getTransaction() : this.transactionManager.suspend();
                boolean bl = true;
                return bl;
            }
            ++bd.nestedInvocationCount;
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new CacheException("Unable to start batch", e);
        }
        finally {
            this.batchDetailsTl.set(bd);
        }
    }

    public void endBatch(boolean success) {
        this.endBatch(false, success);
    }

    public void endBatch(boolean autoBatch, boolean success) {
        BatchDetails bd = (BatchDetails)this.batchDetailsTl.get();
        if (bd.tx == null) {
            return;
        }
        if (autoBatch) {
            --bd.nestedInvocationCount;
        }
        if (!autoBatch || bd.nestedInvocationCount == 0) {
            Transaction existingTx = null;
            try {
                existingTx = this.transactionManager.getTransaction();
                if (existingTx == null && !autoBatch || !bd.tx.equals(existingTx)) {
                    this.transactionManager.resume(bd.tx);
                }
                this.resolveTransaction(bd, success);
            }
            catch (Exception e) {
                throw new CacheException("Unable to end batch", e);
            }
            finally {
                this.batchDetailsTl.remove();
                try {
                    if (!autoBatch && existingTx != null) {
                        this.transactionManager.resume(existingTx);
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Failed resuming existing transaction " + existingTx, e);
                }
            }
        }
        this.batchDetailsTl.set(bd);
    }

    private void resolveTransaction(BatchDetails bd, boolean success) throws Exception {
        Thread currentThread = Thread.currentThread();
        if (bd.thread.equals(currentThread)) {
            if (success) {
                this.transactionManager.commit();
            } else {
                this.transactionManager.rollback();
            }
        } else if (success) {
            bd.tx.commit();
        } else {
            bd.tx.rollback();
        }
    }

    public Transaction getBatchTransaction() {
        return ((BatchDetails)this.batchDetailsTl.get()).tx;
    }

    public boolean isSuspendTxAfterInvocation() {
        return ((BatchDetails)this.batchDetailsTl.get()).suspendTxAfterInvocation;
    }

    private static class BatchDetails {
        int nestedInvocationCount;
        boolean suspendTxAfterInvocation;
        Transaction tx;
        Thread thread;

        private BatchDetails() {
        }
    }

    private static class BatchDetailsTl
    extends ThreadLocal<BatchDetails> {
        private BatchDetailsTl() {
        }

        @Override
        protected BatchDetails initialValue() {
            return new BatchDetails();
        }
    }
}

