/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionLoggerImpl
implements TransactionLogger {
    private static final Log log = LogFactory.getLog(TransactionLoggerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int DRAIN_LOCK_THRESHOLD = 25;
    private static final int GROWTH_COUNT_THRESHOLD = 3;
    private int previousSize;
    private int growthCount;
    private volatile boolean loggingEnabled;
    private ReentrantReadWriteLock txLock = new ReentrantReadWriteLock();
    private ReclosableLatch txLockLatch = new ReclosableLatch(true);
    final BlockingQueue<WriteCommand> commandQueue = new LinkedBlockingQueue<WriteCommand>();
    final Map<GlobalTransaction, PrepareCommand> uncommittedPrepares = new ConcurrentHashMap<GlobalTransaction, PrepareCommand>();
    private final CommandsFactory cf;
    private long lockTimeout;

    public TransactionLoggerImpl(CommandsFactory cf, Configuration config) {
        this.cf = cf;
        this.lockTimeout = config.getRehashWaitTime();
    }

    @Override
    public void enable() {
        this.loggingEnabled = true;
    }

    @Override
    public List<WriteCommand> drain() {
        ArrayList<WriteCommand> list = new ArrayList<WriteCommand>();
        this.commandQueue.drainTo(list);
        return list;
    }

    @Override
    public List<WriteCommand> drainAndLock() throws InterruptedException {
        this.blockNewTransactions();
        return this.drain();
    }

    @Override
    public void unlockAndDisable() {
        this.loggingEnabled = false;
        this.uncommittedPrepares.clear();
        this.unblockNewTransactions();
    }

    @Override
    public void afterCommand(InvocationContext ctx, WriteCommand command) throws InterruptedException {
        if (ctx.isInTxScope()) {
            return;
        }
        if (!ctx.hasFlag(Flag.SKIP_LOCKING)) {
            this.releaseLockForTx();
        }
        if (this.loggingEnabled && command.isSuccessful()) {
            this.commandQueue.put(command);
        }
    }

    @Override
    public void afterCommand(TxInvocationContext ctx, PrepareCommand command) throws InterruptedException {
        if (!ctx.hasFlag(Flag.SKIP_LOCKING)) {
            this.releaseLockForTx();
        }
        if (this.loggingEnabled) {
            if (command.isOnePhaseCommit()) {
                this.logModificationsInTransaction(command);
            } else {
                this.uncommittedPrepares.put(command.getGlobalTransaction(), command);
            }
        }
    }

    @Override
    public void afterCommand(TxInvocationContext ctx, CommitCommand command) throws InterruptedException {
        if (!ctx.hasFlag(Flag.SKIP_LOCKING)) {
            this.releaseLockForTx();
        }
        if (this.loggingEnabled) {
            PrepareCommand pc = this.uncommittedPrepares.remove(command.getGlobalTransaction());
            if (pc == null) {
                this.logModifications(ctx.getModifications());
            } else {
                this.logModificationsInTransaction(pc);
            }
        }
    }

    @Override
    public void afterCommand(TxInvocationContext ctx, RollbackCommand command) {
        if (this.loggingEnabled) {
            this.uncommittedPrepares.remove(command.getGlobalTransaction());
        }
    }

    @Override
    public void afterCommand(TxInvocationContext ctx, LockControlCommand command) {
        if (!command.isUnlock()) {
            this.releaseLockForTx();
        }
    }

    private void logModificationsInTransaction(PrepareCommand command) throws InterruptedException {
        this.logModifications(Arrays.asList(command.getModifications()));
    }

    private void logModifications(Collection<WriteCommand> mods) throws InterruptedException {
        for (WriteCommand wc : mods) {
            this.commandQueue.put(wc);
        }
    }

    @Override
    public boolean beforeCommand(InvocationContext ctx, WriteCommand command) throws InterruptedException, TimeoutException {
        if (ctx.isInTxScope() || ctx.hasFlag(Flag.SKIP_LOCKING)) {
            return true;
        }
        return this.acquireLockForTx(ctx);
    }

    @Override
    public boolean beforeCommand(TxInvocationContext ctx, PrepareCommand command) throws InterruptedException, TimeoutException {
        if (ctx.hasFlag(Flag.SKIP_LOCKING)) {
            return true;
        }
        return this.acquireLockForTx(ctx);
    }

    @Override
    public boolean beforeCommand(TxInvocationContext ctx, CommitCommand command) throws InterruptedException, TimeoutException {
        GlobalTransaction gtx;
        if (!ctx.hasFlag(Flag.SKIP_LOCKING) && !this.acquireLockForTx(ctx)) {
            return false;
        }
        if (this.loggingEnabled && !this.uncommittedPrepares.containsKey(gtx = ctx.getGlobalTransaction())) {
            this.uncommittedPrepares.put(gtx, this.cf.buildPrepareCommand(gtx, ctx.getModifications(), false));
        }
        return true;
    }

    @Override
    public boolean beforeCommand(TxInvocationContext ctx, RollbackCommand command) throws InterruptedException, TimeoutException {
        return true;
    }

    @Override
    public boolean beforeCommand(TxInvocationContext ctx, LockControlCommand cmd) throws TimeoutException, InterruptedException {
        if (cmd.isUnlock()) {
            return true;
        }
        return this.acquireLockForTx(ctx);
    }

    @Override
    public void suspendTransactionLock(InvocationContext ctx) {
        this.releaseLockForTx();
    }

    @Override
    public void resumeTransactionLock(InvocationContext ctx) throws TimeoutException, InterruptedException {
        this.acquireLockForTx(ctx);
    }

    private int size() {
        return this.loggingEnabled ? this.commandQueue.size() : 0;
    }

    @Override
    public boolean isEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public boolean shouldDrainWithoutLock() {
        if (this.loggingEnabled) {
            boolean shouldLock;
            int sz = this.size();
            boolean bl = shouldLock = this.previousSize > 0 && this.growthCount > 3 || sz < 25;
            if (!shouldLock) {
                if (sz > this.previousSize && this.previousSize > 0) {
                    ++this.growthCount;
                }
                this.previousSize = sz;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Collection<PrepareCommand> getPendingPrepares() {
        HashSet<PrepareCommand> commands = new HashSet<PrepareCommand>(this.uncommittedPrepares.values());
        this.uncommittedPrepares.clear();
        return commands;
    }

    @Override
    public void blockNewTransactions() throws InterruptedException {
        if (!this.txLock.isWriteLockedByCurrentThread()) {
            if (trace) {
                log.debug("Blocking new transactions");
            }
            this.txLockLatch.close();
            this.txLock.writeLock().lockInterruptibly();
        } else if (trace) {
            log.debug("New transactions were not unblocked by the previous rehash");
        }
    }

    @Override
    public void unblockNewTransactions() {
        if (trace) {
            log.debug("Unblocking new transactions");
        }
        this.txLock.writeLock().unlock();
        this.txLockLatch.open();
    }

    @Override
    public boolean areTransactionsBlocked() {
        try {
            return this.txLockLatch.await(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private boolean acquireLockForTx(InvocationContext ctx) throws InterruptedException, TimeoutException {
        if (this.txLockLatch.await(0L, TimeUnit.MILLISECONDS) && this.txLock.readLock().tryLock(0L, TimeUnit.MILLISECONDS)) {
            return true;
        }
        if (!ctx.isOriginLocal()) {
            return false;
        }
        boolean hasAcquiredLocks = ctx.getLockedKeys().size() > 0;
        long timeout = hasAcquiredLocks ? this.lockTimeout / 100L : this.lockTimeout;
        long endTime = System.currentTimeMillis() + timeout;
        do {
            if (!this.txLockLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                return false;
            }
            if (!this.txLock.readLock().tryLock(0L, TimeUnit.MILLISECONDS)) continue;
            return true;
        } while ((timeout = endTime - System.currentTimeMillis()) >= 0L);
        return false;
    }

    private void releaseLockForTx() {
        this.txLock.readLock().unlock();
    }

    public String toString() {
        return "TransactionLoggerImpl{commandQueue=" + this.commandQueue + ", uncommittedPrepares=" + this.uncommittedPrepares + '}';
    }
}

