/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.config.ConfigurationException;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.Proxies;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ModuleProperties
extends Properties {
    private static final long serialVersionUID = 2558131508076199744L;
    private static final Log log = LogFactory.getLog(ModuleProperties.class);
    public static final String MODULE_PROPERTIES_FILENAME = "infinispan-module.properties";
    public static final String MODULE_NAME_KEY = "infinispan.module.name";
    public static final String MODULE_CONFIGURATION_CLASS = "infinispan.module.configurationClassName";
    public static final String MODULE_LIFECYCLE = "infinispan.module.lifecycle";
    public static final String MODULE_COMMAND_INITIALIZER = "infinispan.module.command.initializer";
    public static final String MODULE_COMMAND_FACTORY = "infinispan.module.command.factory";
    private static final ReentrantLock modulePropertiesGuard = new ReentrantLock();
    @GuardedBy(value="modulePropertiesGuard")
    private static Map<String, ModuleProperties> moduleProperties;
    private static final ReentrantLock moduleCommandsGuard;
    @GuardedBy(value="moduleCommandsGuard")
    private static Map<Byte, ModuleCommandFactory> commandFactories;
    @GuardedBy(value="moduleCommandsGuard")
    private static Map<Byte, Class<? extends ModuleCommandInitializer>> commandInitializers;
    @GuardedBy(value="moduleCommandsGuard")
    private static Collection<Class<? extends ReplicableCommand>> moduleCommands;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleProperties loadModuleProperties(String moduleName, ClassLoader cl) throws IOException {
        Collection<URL> resources = FileLookupFactory.newInstance().lookupFileLocations(MODULE_PROPERTIES_FILENAME, cl);
        if (resources == null) {
            throw new IOException("Could not find infinispan-module.properties files on classpath for module " + moduleName);
        }
        for (URL url : resources) {
            ModuleProperties props = new ModuleProperties();
            InputStream inStream = url.openStream();
            try {
                props.load(inStream);
            }
            finally {
                Util.close((Closeable)inStream);
            }
            props.verify();
            if (!props.getName().equalsIgnoreCase(moduleName)) continue;
            return props;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ModuleProperties> loadModuleProperties(ClassLoader cl) throws IOException {
        HashMap<String, ModuleProperties> map = new HashMap<String, ModuleProperties>();
        Collection<URL> resources = FileLookupFactory.newInstance().lookupFileLocations(MODULE_PROPERTIES_FILENAME, cl);
        for (URL url : resources) {
            try {
                ModuleProperties props = new ModuleProperties();
                InputStream inStream = url.openStream();
                try {
                    props.load(inStream);
                }
                finally {
                    Util.close((Closeable)inStream);
                }
                props.verify();
                map.put(props.getName(), props);
            }
            catch (Exception e) {
                log.couldNotLoadModuleAtUrl(url, e);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ModuleProperties> getModuleProperties(ClassLoader cl) throws IOException {
        modulePropertiesGuard.lock();
        try {
            if (moduleProperties == null) {
                moduleProperties = ModuleProperties.loadModuleProperties(cl);
            }
            Map<String, ModuleProperties> map = moduleProperties;
            return map;
        }
        finally {
            modulePropertiesGuard.unlock();
        }
    }

    public static List<ModuleLifecycle> resolveModuleLifecycles(ClassLoader cl) {
        try {
            ArrayList<ModuleLifecycle> lifecycles = new ArrayList<ModuleLifecycle>();
            Map<String, ModuleProperties> p = ModuleProperties.getModuleProperties(cl);
            for (Map.Entry<String, ModuleProperties> m : p.entrySet()) {
                try {
                    String lifecycleClassName = m.getValue().getLifecycleClassName();
                    if (lifecycleClassName == null || lifecycleClassName.isEmpty()) continue;
                    Class loadClass = Util.loadClassStrict(lifecycleClassName, cl);
                    Object proxy = Proxies.newCatchThrowableProxy(loadClass.newInstance());
                    ModuleLifecycle ml = (ModuleLifecycle)proxy;
                    lifecycles.add(ml);
                }
                catch (Exception e) {
                    log.couldNotInitializeModule(m.getKey(), e);
                }
            }
            return lifecycles;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public String getName() {
        return super.getProperty(MODULE_NAME_KEY);
    }

    public String getConfigurationClassName() {
        return super.getProperty(MODULE_CONFIGURATION_CLASS);
    }

    public String getLifecycleClassName() {
        return super.getProperty(MODULE_LIFECYCLE);
    }

    public String getCommandInitializerClassName() {
        return super.getProperty(MODULE_COMMAND_INITIALIZER);
    }

    public String getCommandFactoryClassName() {
        return super.getProperty(MODULE_COMMAND_FACTORY);
    }

    protected void verify() {
        if (this.getName() == null) {
            throw new ConfigurationException("Module properties does not specify module name. Module name should be specified using key infinispan.module.name");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadModuleCommandHandlers(ClassLoader cl) {
        try {
            commandFactories = new HashMap<Byte, ModuleCommandFactory>(1);
            commandInitializers = new HashMap<Byte, Class<? extends ModuleCommandInitializer>>(1);
            moduleCommands = new HashSet<Class<? extends ReplicableCommand>>(1);
            Map<String, ModuleProperties> p = ModuleProperties.getModuleProperties(cl);
            for (Map.Entry<String, ModuleProperties> module : p.entrySet()) {
                String factClass = module.getValue().getCommandFactoryClassName();
                String initClass = module.getValue().getCommandInitializerClassName();
                if (factClass == null || initClass == null) continue;
                try {
                    ModuleCommandFactory fact = (ModuleCommandFactory)Util.getInstance(factClass, cl);
                    Class initClazz = Util.loadClass(initClass, cl);
                    for (Map.Entry<Byte, Class<? extends ReplicableCommand>> entry : fact.getModuleCommands().entrySet()) {
                        byte id = entry.getKey();
                        if (commandFactories.containsKey(id)) {
                            throw new IllegalArgumentException("Module " + module.getKey() + " cannot use id " + id + " for commands, as it is already in use by " + commandFactories.get(id).getClass().getName());
                        }
                        commandFactories.put(id, fact);
                        commandInitializers.put(id, initClazz);
                        moduleCommands.add(entry.getValue());
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Unable to load factory class " + factClass + " for module " + module.getKey());
                    return;
                }
            }
        }
        catch (IOException ioe) {
            commandInitializers = Collections.emptyMap();
            commandFactories = Collections.emptyMap();
            throw new CacheException("IO Exception reading module properties file!", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Class<? extends ReplicableCommand>> moduleCommands(ClassLoader cl) {
        moduleCommandsGuard.lock();
        try {
            if (moduleCommands == null) {
                ModuleProperties.loadModuleCommandHandlers(cl);
            }
            Collection<Class<? extends ReplicableCommand>> collection = moduleCommands;
            return collection;
        }
        finally {
            moduleCommandsGuard.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Byte, ModuleCommandFactory> moduleCommandFactories(ClassLoader cl) {
        moduleCommandsGuard.lock();
        try {
            if (commandFactories == null) {
                ModuleProperties.loadModuleCommandHandlers(cl);
            }
            Map<Byte, ModuleCommandFactory> map = commandFactories;
            return map;
        }
        finally {
            moduleCommandsGuard.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Byte, ModuleCommandInitializer> moduleCommandInitializers(ClassLoader cl) {
        moduleCommandsGuard.lock();
        try {
            if (commandInitializers == null) {
                ModuleProperties.loadModuleCommandHandlers(cl);
            }
            if (commandInitializers.isEmpty()) {
                Map<Byte, ModuleCommandInitializer> map = Collections.emptyMap();
                return map;
            }
            HashMap<Byte, ModuleCommandInitializer> initializers = new HashMap<Byte, ModuleCommandInitializer>(commandInitializers.size());
            for (Map.Entry<Byte, Class<? extends ModuleCommandInitializer>> e : commandInitializers.entrySet()) {
                initializers.put(e.getKey(), Util.getInstance(e.getValue()));
            }
            HashMap<Byte, ModuleCommandInitializer> hashMap = initializers;
            return hashMap;
        }
        finally {
            moduleCommandsGuard.unlock();
        }
    }

    static {
        moduleCommandsGuard = new ReentrantLock();
    }
}

