/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.AbstractDelegatingAdvancedCache;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.config.ConfigurationException;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.Event;
import org.jboss.util.loading.ContextClassLoaderSwitcher;

public class ClassLoaderAwareCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    static final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    final WeakReference<ClassLoader> classLoaderRef;
    static final Map<Event.Type, Class<? extends Annotation>> events = new EnumMap<Event.Type, Class<? extends Annotation>>(Event.Type.class);

    public ClassLoaderAwareCache(AdvancedCache<K, V> cache, ClassLoader classLoader) {
        super(cache);
        this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        try {
            cache.addInterceptor((CommandInterceptor)new ClassLoaderAwareCommandInterceptor((AdvancedCache<?, ?>)this), 0);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return this;
    }

    public void addInterceptor(CommandInterceptor interceptor, int position) {
        super.addInterceptor(interceptor, position > 0 ? position : 1);
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderRef.get();
    }

    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    public void addListener(Object listener) {
        super.addListener((Object)new ClassLoaderAwareListener(listener, (AdvancedCache<?, ?>)this));
    }

    static {
        events.put(Event.Type.CACHE_ENTRY_ACTIVATED, CacheEntryActivated.class);
        events.put(Event.Type.CACHE_ENTRY_CREATED, CacheEntryCreated.class);
        events.put(Event.Type.CACHE_ENTRY_INVALIDATED, CacheEntryInvalidated.class);
        events.put(Event.Type.CACHE_ENTRY_LOADED, CacheEntryLoaded.class);
        events.put(Event.Type.CACHE_ENTRY_MODIFIED, CacheEntryModified.class);
        events.put(Event.Type.CACHE_ENTRY_PASSIVATED, CacheEntryPassivated.class);
        events.put(Event.Type.CACHE_ENTRY_REMOVED, CacheEntryRemoved.class);
        events.put(Event.Type.CACHE_ENTRY_VISITED, CacheEntryVisited.class);
    }

    @Listener
    public static class ClassLoaderAwareListener {
        private final Object listener;
        private final Map<Event.Type, List<Method>> methods = new EnumMap<Event.Type, List<Method>>(Event.Type.class);
        private final AdvancedCache<?, ?> cache;

        public ClassLoaderAwareListener(Object listener, AdvancedCache<?, ?> cache) {
            this.listener = listener;
            this.cache = cache;
            for (Method method : listener.getClass().getMethods()) {
                for (Map.Entry<Event.Type, Class<? extends Annotation>> entry : events.entrySet()) {
                    Class<? extends Annotation> annotation = entry.getValue();
                    if (!method.isAnnotationPresent(annotation)) continue;
                    List<Method> methods = this.methods.get(entry.getValue());
                    if (methods == null) {
                        methods = new LinkedList<Method>();
                        this.methods.put(entry.getKey(), methods);
                    }
                    methods.add(method);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @CacheEntryActivated
        @CacheEntryCreated
        @CacheEntryInvalidated
        @CacheEntryLoaded
        @CacheEntryModified
        @CacheEntryPassivated
        @CacheEntryRemoved
        @CacheEntryVisited
        public <K, V> void event(Event<K, V> event) throws Throwable {
            List<Method> methods = this.methods.get(event.getType());
            if (methods == null) return;
            ClassLoader classLoader = this.cache.getClassLoader();
            ContextClassLoaderSwitcher.SwitchContext context = classLoader != null ? switcher.getSwitchContext(classLoader) : null;
            try {
                for (Method method : this.methods.get(event.getType())) {
                    try {
                        method.invoke(this.listener, event);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                        return;
                    }
                }
            }
            finally {
                if (context != null) {
                    context.reset();
                }
            }
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof ClassLoaderAwareListener) {
                ClassLoaderAwareListener listener = (ClassLoaderAwareListener)object;
                return this.listener.equals(listener.listener);
            }
            return this.listener.equals(object);
        }
    }

    class ClassLoaderAwareCommandInterceptor
    extends CommandInterceptor {
        private final AdvancedCache<?, ?> cache;

        ClassLoaderAwareCommandInterceptor(AdvancedCache<?, ?> cache) {
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            ClassLoader classLoader = this.cache.getClassLoader();
            ContextClassLoaderSwitcher.SwitchContext context = classLoader != null ? switcher.getSwitchContext(classLoader) : null;
            try {
                Object object = super.handleDefault(ctx, command);
                return object;
            }
            finally {
                if (context != null) {
                    context.reset();
                }
            }
        }
    }
}

