/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;

public class EEResourceReferenceProcessorRegistry {
    private static final Map<String, EEResourceReferenceProcessor> resourceReferenceProcessors = new ConcurrentHashMap<String, EEResourceReferenceProcessor>();

    public static void registerResourceReferenceProcessor(EEResourceReferenceProcessor resourceReferenceProcessor) {
        if (resourceReferenceProcessor == null) {
            throw new IllegalArgumentException("Cannot register a null resource reference processor");
        }
        String resourceReferenceType = resourceReferenceProcessor.getResourceReferenceType();
        if (resourceReferenceType == null || resourceReferenceType.trim().isEmpty()) {
            throw new IllegalArgumentException("Resource reference type of resource reference processor cannot be null or empty");
        }
        resourceReferenceProcessors.put(resourceReferenceType, resourceReferenceProcessor);
    }

    public static void unregisterResourceReferenceProcessor(String resourceReferenceType) {
        if (resourceReferenceType == null || resourceReferenceType.trim().isEmpty()) {
            throw new IllegalArgumentException("Resource reference type of resource reference processor cannot be null or empty");
        }
        if (!resourceReferenceProcessors.containsKey(resourceReferenceType)) {
            throw new IllegalArgumentException("Resource reference for type: " + resourceReferenceType + " is not registered. Cannot unregister");
        }
        resourceReferenceProcessors.remove(resourceReferenceType);
    }

    public static EEResourceReferenceProcessor getResourceReferenceProcessor(String resourceReferenceType) {
        return resourceReferenceProcessors.get(resourceReferenceType);
    }
}

