/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.SecurityActions;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.SystemExiter;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.log4j.BridgeRepositorySelector;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;

public final class Main {
    public static void usage() {
        System.out.println("Usage: ./standalone.sh [args...]\n");
        System.out.println("where args include:");
        System.out.println("    -b=<value>                         Set system property jboss.bind.address to the given value");
        System.out.println("    -b <value>                         Set system property jboss.bind.address to the given value");
        System.out.println("    -b<interface>=<value>              Set system property jboss.bind.address.<interface> to the given value");
        System.out.println("    -D<name>[=<value>]                 Set a system property");
        System.out.println("    -h                                 Display this message and exit");
        System.out.println("    --help                             Display this message and exit");
        System.out.println("    -P=<url>                           Load system properties from the given url");
        System.out.println("    -P <url>                           Load system properties from the given url");
        System.out.println("    --properties=<url>                 Load system properties from the given url");
        System.out.println("    --server-config=<config>           Name of the server configuration file to use (default is \"standalone.xml\")");
        System.out.println("    -V                                 Print version and exit");
        System.out.println("    -v                                 Print version and exit");
        System.out.println("    --version                          Print version and exit");
        System.out.println();
    }

    private Main() {
    }

    public static void main(String[] args) {
        SecurityActions.setSystemProperty("log4j.defaultInitOverride", "true");
        new BridgeRepositorySelector().start();
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (java.util.logging.Level)Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (java.util.logging.Level)Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        try {
            Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
            ServerEnvironment serverEnvironment = Main.determineEnvironment(args, new Properties(SecurityActions.getSystemProperties()), SecurityActions.getSystemEnvironment(), ServerEnvironment.LaunchType.STANDALONE);
            if (serverEnvironment != null) {
                Bootstrap bootstrap = Bootstrap.Factory.newInstance();
                Bootstrap.Configuration configuration = new Bootstrap.Configuration();
                configuration.setServerEnvironment(serverEnvironment);
                configuration.setModuleLoader(Module.getBootModuleLoader());
                bootstrap.bootstrap(configuration, Collections.<ServiceActivator>emptyList()).get();
                return;
            }
            Main.abort(null);
        }
        catch (Throwable t) {
            Main.abort(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void abort(Throwable t) {
        try {
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
        finally {
            SystemExiter.exit(1);
        }
    }

    public static ServerEnvironment determineEnvironment(String[] args, Properties systemProperties, Map<String, String> systemEnvironment, ServerEnvironment.LaunchType launchType) {
        int argsLength = args.length;
        String serverConfig = null;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                String value;
                if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
                    System.out.println("JBoss Application Server " + org.jboss.as.process.Main.getVersionString());
                    return null;
                }
                if ("--help".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                    Main.usage();
                    return null;
                }
                if ("--server-config".equals(arg) || "-server-config".equals(arg)) {
                    serverConfig = args[++i];
                    continue;
                }
                if (arg.startsWith("--server-config")) {
                    serverConfig = Main.parseValue(arg, "--server-config");
                    if (serverConfig != null) continue;
                    return null;
                }
                if (arg.startsWith("-server-config")) {
                    serverConfig = Main.parseValue(arg, "-server-config");
                    if (serverConfig != null) continue;
                    return null;
                }
                if ("--properties".equals(arg) || "-properties".equals(arg) || "-P".equals(arg)) {
                    if (Main.processProperties(arg, args[++i])) continue;
                    return null;
                }
                if (arg.startsWith("--properties")) {
                    String urlSpec = Main.parseValue(arg, "--properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.startsWith("-P")) {
                    String urlSpec = Main.parseValue(arg, "-P");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.startsWith("-properties")) {
                    String urlSpec = Main.parseValue(arg, "-properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.startsWith("-D")) {
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1, arg.length());
                    }
                    systemProperties.setProperty(name, value);
                    SecurityActions.setSystemProperty(name, value);
                    continue;
                }
                if (arg.startsWith("-b")) {
                    int idx = arg.indexOf(61);
                    if (idx == arg.length() - 1) {
                        System.err.printf("Argument expected for option %s\n", arg);
                        Main.usage();
                        return null;
                    }
                    value = idx > -1 ? arg.substring(idx + 1) : args[++i];
                    String propertyName = null;
                    propertyName = idx < 0 ? (arg.length() == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2)) : (idx == 2 ? "jboss.bind.address" : "jboss.bind.address." + arg.substring(2, idx));
                    systemProperties.setProperty(propertyName, value);
                    SecurityActions.setSystemProperty(propertyName, value);
                    continue;
                }
                System.err.printf("Invalid option '%s'\n", arg);
                Main.usage();
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                Main.usage();
                return null;
            }
        }
        return new ServerEnvironment(systemProperties, systemEnvironment, serverConfig, launchType);
    }

    private static String parseValue(String arg, String key) {
        String value = null;
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            Main.usage();
        } else {
            value = arg.substring(splitPos + 1);
        }
        return value;
    }

    private static boolean processProperties(String arg, String urlSpec) {
        URL url = null;
        try {
            url = Main.makeURL(urlSpec);
            Properties props = System.getProperties();
            props.load(url.openConnection().getInputStream());
            return true;
        }
        catch (MalformedURLException e) {
            System.err.printf("Malformed URL provided for option %s\n", arg);
            Main.usage();
            return false;
        }
        catch (IOException e) {
            System.err.printf("Unable to load properties from URL %s\n", url);
            Main.usage();
            return false;
        }
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }
}

