/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.ha.rpc;

import java.io.Serializable;
import java.net.InetSocketAddress;
import net.jcip.annotations.Immutable;
import org.jboss.ha.framework.interfaces.ClusterNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class MCMPServerDiscoveryEvent
implements Serializable,
Comparable<MCMPServerDiscoveryEvent> {
    private static final long serialVersionUID = -4615651826967237065L;
    private final ClusterNode sender;
    private final InetSocketAddress mcmpServer;
    private final boolean addition;
    private final int eventIndex;

    public MCMPServerDiscoveryEvent(ClusterNode sender, InetSocketAddress mcmpServer, boolean addition, int eventIndex) {
        assert (sender != null) : "sender is null";
        assert (mcmpServer != null) : "mcmpServer is null";
        this.sender = sender;
        this.mcmpServer = mcmpServer;
        this.addition = addition;
        this.eventIndex = eventIndex;
    }

    public MCMPServerDiscoveryEvent(MCMPServerDiscoveryEvent toRecreate, int newEventIndex) {
        this(toRecreate.getSender(), toRecreate.getMCMPServer(), toRecreate.isAddition(), newEventIndex);
    }

    public ClusterNode getSender() {
        return this.sender;
    }

    public InetSocketAddress getMCMPServer() {
        return this.mcmpServer;
    }

    public boolean isAddition() {
        return this.addition;
    }

    public int getEventIndex() {
        return this.eventIndex;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{sender=").append(this.sender);
        builder.append(", mcmpServer=").append(this.mcmpServer);
        builder.append(", addition=").append(this.addition);
        builder.append(", eventIndex=").append(this.eventIndex);
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int compareTo(MCMPServerDiscoveryEvent event) {
        return this.eventIndex - event.eventIndex;
    }
}

