/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.local;

import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.ChannelConfig;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DefaultChannelConfig;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.channel.local.LocalChannel;
import org.jboss.netty.channel.local.LocalChannelRegistry;
import org.jboss.netty.channel.local.LocalServerChannel;
import org.jboss.netty.util.internal.LinkedTransferQueue;
import org.jboss.netty.util.internal.ThreadLocalBoolean;

final class DefaultLocalChannel
extends AbstractChannel
implements LocalChannel {
    private final ChannelConfig config;
    private final ThreadLocalBoolean delivering = new ThreadLocalBoolean();
    final AtomicBoolean bound = new AtomicBoolean();
    final Queue<MessageEvent> writeBuffer = new LinkedTransferQueue<MessageEvent>();
    volatile DefaultLocalChannel pairedChannel;
    volatile LocalAddress localAddress;
    volatile LocalAddress remoteAddress;

    DefaultLocalChannel(LocalServerChannel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, DefaultLocalChannel pairedChannel) {
        super(parent, factory, pipeline, sink);
        this.pairedChannel = pairedChannel;
        this.config = new DefaultChannelConfig();
        Channels.fireChannelOpen(this);
    }

    public ChannelConfig getConfig() {
        return this.config;
    }

    public boolean isBound() {
        return this.bound.get() && this.isOpen();
    }

    public boolean isConnected() {
        return this.pairedChannel != null && this.isOpen();
    }

    public LocalAddress getLocalAddress() {
        return this.localAddress;
    }

    public LocalAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void closeNow(ChannelFuture future) {
        LocalAddress localAddress;
        block8: {
            block7: {
                block6: {
                    localAddress = this.localAddress;
                    try {
                        if (!this.setClosed()) {
                            Object var6_3 = null;
                            future.setSuccess();
                            break block6;
                        }
                        DefaultLocalChannel pairedChannel = this.pairedChannel;
                        if (pairedChannel != null) {
                            this.pairedChannel = null;
                            Channels.fireChannelDisconnected(this);
                            Channels.fireChannelUnbound(this);
                        }
                        Channels.fireChannelClosed(this);
                        if (pairedChannel == null) break block7;
                        if (!pairedChannel.setClosed()) {
                            break block7;
                        }
                        DefaultLocalChannel me = pairedChannel.pairedChannel;
                        if (me != null) {
                            pairedChannel.pairedChannel = null;
                            Channels.fireChannelDisconnected(pairedChannel);
                            Channels.fireChannelUnbound(pairedChannel);
                        }
                        Channels.fireChannelClosed(pairedChannel);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        future.setSuccess();
                        if (localAddress == null) throw throwable;
                        if (this.getParent() != null) throw throwable;
                        LocalChannelRegistry.unregister(localAddress);
                        throw throwable;
                    }
                }
                if (localAddress == null) return;
                if (this.getParent() != null) return;
                LocalChannelRegistry.unregister(localAddress);
                return;
            }
            Object var6_4 = null;
            future.setSuccess();
            if (localAddress == null) return;
            if (this.getParent() != null) return;
            LocalChannelRegistry.unregister(localAddress);
            return;
        }
        Object var6_5 = null;
        future.setSuccess();
        if (localAddress == null) return;
        if (this.getParent() != null) return;
        LocalChannelRegistry.unregister(localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushWriteBuffer() {
        DefaultLocalChannel pairedChannel = this.pairedChannel;
        if (pairedChannel != null) {
            if (pairedChannel.isConnected() && !((Boolean)this.delivering.get()).booleanValue()) {
                this.delivering.set(true);
                try {
                    MessageEvent e;
                    while ((e = this.writeBuffer.poll()) != null) {
                        e.getFuture().setSuccess();
                        Channels.fireMessageReceived(pairedChannel, e.getMessage());
                        Channels.fireWriteComplete(this, 1L);
                    }
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.delivering.set(false);
                    throw throwable;
                }
                this.delivering.set(false);
                {
                }
            }
        } else {
            MessageEvent e;
            Exception cause = this.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
            while ((e = this.writeBuffer.poll()) != null) {
                e.getFuture().setFailure(cause);
                Channels.fireExceptionCaught(this, (Throwable)cause);
            }
        }
    }
}

