/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller;

import java.util.EnumSet;
import org.jboss.as.controller.CompositeOperationHandler;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ExtensionContextImpl;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.operations.common.ExtensionAddHandler;
import org.jboss.as.controller.operations.common.ExtensionRemoveHandler;
import org.jboss.as.controller.operations.common.InterfaceAddHandler;
import org.jboss.as.controller.operations.common.JVMHandlers;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.common.PathAddHandler;
import org.jboss.as.controller.operations.common.PathRemoveHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationRemoveHandler;
import org.jboss.as.controller.operations.common.SnapshotDeleteHandler;
import org.jboss.as.controller.operations.common.SnapshotListHandler;
import org.jboss.as.controller.operations.common.SnapshotTakeHandler;
import org.jboss.as.controller.operations.common.SocketBindingAddHandler;
import org.jboss.as.controller.operations.common.SocketBindingGroupIncludeAddHandler;
import org.jboss.as.controller.operations.common.SocketBindingGroupIncludeRemoveHandler;
import org.jboss.as.controller.operations.common.SocketBindingGroupRemoveHandler;
import org.jboss.as.controller.operations.common.SocketBindingRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.SystemPropertyRemoveHandler;
import org.jboss.as.controller.operations.common.SystemPropertyValueWriteAttributeHandler;
import org.jboss.as.controller.operations.common.XmlMarshallingHandler;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.as.domain.controller.UnregisteredHostChannelRegistry;
import org.jboss.as.domain.controller.descriptions.DomainDescriptionProviders;
import org.jboss.as.domain.controller.operations.ApplyRemoteMasterDomainModelHandler;
import org.jboss.as.domain.controller.operations.ProcessTypeHandler;
import org.jboss.as.domain.controller.operations.ProfileAddHandler;
import org.jboss.as.domain.controller.operations.ProfileDescribeHandler;
import org.jboss.as.domain.controller.operations.ProfileRemoveHandler;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelHandler;
import org.jboss.as.domain.controller.operations.ServerGroupAddHandler;
import org.jboss.as.domain.controller.operations.ServerGroupRemoveHandler;
import org.jboss.as.domain.controller.operations.SocketBindingGroupAddHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentAddHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentFullReplaceHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentRemoveHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadBytesHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadStreamAttachmentHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadURLHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentAddHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentDeployHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentRedeployHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentRemoveHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentReplaceHandler;
import org.jboss.as.domain.controller.operations.deployment.ServerGroupDeploymentUndeployHandler;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DomainModelUtil {
    public static void updateCoreModel(ModelNode rootModel) {
        rootModel.get("namespaces").setEmptyList();
        rootModel.get("schema-locations").setEmptyList();
        rootModel.get("extension");
        rootModel.get("path");
        rootModel.get("system-property");
        rootModel.get("profile");
        rootModel.get("interface");
        rootModel.get("socket-binding-group");
        rootModel.get("deployment");
        rootModel.get("server-group");
        rootModel.get("host");
    }

    public static ExtensionContext initializeMasterDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepository, FileRepository fileRepository, DomainController domainController, UnregisteredHostChannelRegistry registry) {
        return DomainModelUtil.initializeDomainRegistry(root, configurationPersister, contentRepository, fileRepository, true, domainController, registry);
    }

    public static ExtensionContext initializeSlaveDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, FileRepository fileRepository) {
        return DomainModelUtil.initializeDomainRegistry(root, configurationPersister, null, fileRepository, false, null, null);
    }

    private static ExtensionContext initializeDomainRegistry(ManagementResourceRegistration root, ExtensibleConfigurationPersister configurationPersister, ContentRepository contentRepo, FileRepository fileRepository, boolean isMaster, DomainController domainController, UnregisteredHostChannelRegistry registry) {
        EnumSet<OperationEntry.Flag> readOnly = EnumSet.of(OperationEntry.Flag.READ_ONLY);
        EnumSet<OperationEntry.Flag> deploymentUpload = EnumSet.of(OperationEntry.Flag.DEPLOYMENT_UPLOAD);
        root.registerOperationHandler("composite", (OperationStepHandler)CompositeOperationHandler.INSTANCE, (DescriptionProvider)CompositeOperationHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        XmlMarshallingHandler xmh = new XmlMarshallingHandler((ConfigurationPersister)configurationPersister);
        root.registerOperationHandler("read-config-as-xml", (OperationStepHandler)xmh, (DescriptionProvider)xmh, false, OperationEntry.EntryType.PUBLIC, readOnly);
        root.registerOperationHandler("add-namespace", (OperationStepHandler)NamespaceAddHandler.INSTANCE, (DescriptionProvider)NamespaceAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-namespace", (OperationStepHandler)NamespaceRemoveHandler.INSTANCE, (DescriptionProvider)NamespaceRemoveHandler.INSTANCE, false);
        root.registerOperationHandler("add-schema-location", (OperationStepHandler)SchemaLocationAddHandler.INSTANCE, (DescriptionProvider)SchemaLocationAddHandler.INSTANCE, false);
        root.registerOperationHandler("remove-schema-location", (OperationStepHandler)SchemaLocationRemoveHandler.INSTANCE, (DescriptionProvider)SchemaLocationRemoveHandler.INSTANCE, false);
        DeploymentUploadBytesHandler dubh = new DeploymentUploadBytesHandler(contentRepo);
        root.registerOperationHandler("upload-deployment-bytes", (OperationStepHandler)dubh, (DescriptionProvider)dubh, false, OperationEntry.EntryType.PUBLIC, deploymentUpload);
        DeploymentUploadURLHandler duuh = new DeploymentUploadURLHandler(contentRepo);
        root.registerOperationHandler("upload-deployment-url", (OperationStepHandler)duuh, (DescriptionProvider)duuh, false, OperationEntry.EntryType.PUBLIC, deploymentUpload);
        DeploymentUploadStreamAttachmentHandler dush = new DeploymentUploadStreamAttachmentHandler(contentRepo);
        root.registerOperationHandler("upload-deployment-stream", (OperationStepHandler)dush, (DescriptionProvider)dush, false, OperationEntry.EntryType.PUBLIC, deploymentUpload);
        DeploymentFullReplaceHandler dfrh = isMaster ? new DeploymentFullReplaceHandler(contentRepo) : new DeploymentFullReplaceHandler(fileRepository);
        root.registerOperationHandler("full-replace-deployment", (OperationStepHandler)dfrh, (DescriptionProvider)dfrh);
        SnapshotDeleteHandler snapshotDelete = new SnapshotDeleteHandler((ConfigurationPersister)configurationPersister);
        root.registerOperationHandler("delete-snapshot", (OperationStepHandler)snapshotDelete, (DescriptionProvider)snapshotDelete, false);
        SnapshotListHandler snapshotList = new SnapshotListHandler((ConfigurationPersister)configurationPersister);
        root.registerOperationHandler("list-snapshots", (OperationStepHandler)snapshotList, (DescriptionProvider)snapshotList, false);
        SnapshotTakeHandler snapshotTake = new SnapshotTakeHandler((ConfigurationPersister)configurationPersister);
        root.registerOperationHandler("take-snapshot", (OperationStepHandler)snapshotTake, (DescriptionProvider)snapshotTake, false);
        root.registerReadOnlyAttribute("process-type", (OperationStepHandler)(isMaster ? ProcessTypeHandler.MASTER : ProcessTypeHandler.SLAVE), AttributeAccess.Storage.RUNTIME);
        root.registerOperationHandler("validate-address", GlobalOperationHandlers.VALIDATE_ADDRESS, CommonProviders.VALIDATE_ADDRESS_PROVIDER, true);
        ManagementResourceRegistration systemProperties = root.registerSubModel(PathElement.pathElement((String)"system-property"), DomainDescriptionProviders.SYSTEM_PROPERTY_PROVIDER);
        systemProperties.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, false);
        systemProperties.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        systemProperties.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        systemProperties.registerReadWriteAttribute("boot-time", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration interfaces = root.registerSubModel(PathElement.pathElement((String)"interface"), CommonProviders.NAMED_INTERFACE_PROVIDER);
        interfaces.registerOperationHandler("add", (OperationStepHandler)InterfaceAddHandler.NAMED_INSTANCE, (DescriptionProvider)InterfaceAddHandler.NAMED_INSTANCE, false);
        interfaces.registerOperationHandler("remove", (OperationStepHandler)InterfaceAddHandler.NAMED_INSTANCE, (DescriptionProvider)InterfaceAddHandler.NAMED_INSTANCE, false);
        ManagementResourceRegistration profile = root.registerSubModel(PathElement.pathElement((String)"profile"), DomainDescriptionProviders.PROFILE);
        profile.registerOperationHandler("add", (OperationStepHandler)ProfileAddHandler.INSTANCE, (DescriptionProvider)ProfileAddHandler.INSTANCE, false);
        profile.registerOperationHandler("remove", (OperationStepHandler)ProfileRemoveHandler.INSTANCE, (DescriptionProvider)ProfileRemoveHandler.INSTANCE, false);
        profile.registerOperationHandler("describe", (OperationStepHandler)ProfileDescribeHandler.INSTANCE, (DescriptionProvider)ProfileDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE, readOnly);
        ManagementResourceRegistration paths = root.registerSubModel(PathElement.pathElement((String)"path"), DomainDescriptionProviders.PATH_DESCRIPTION);
        paths.registerOperationHandler("add", (OperationStepHandler)PathAddHandler.NAMED_INSTANCE, (DescriptionProvider)PathAddHandler.NAMED_INSTANCE, false);
        paths.registerOperationHandler("remove", (OperationStepHandler)PathRemoveHandler.INSTANCE, (DescriptionProvider)PathRemoveHandler.INSTANCE, false);
        ManagementResourceRegistration socketBindingGroup = root.registerSubModel(PathElement.pathElement((String)"socket-binding-group"), DomainDescriptionProviders.SOCKET_BINDING_GROUP);
        socketBindingGroup.registerOperationHandler("add", (OperationStepHandler)SocketBindingGroupAddHandler.INSTANCE, (DescriptionProvider)SocketBindingGroupAddHandler.INSTANCE, false);
        socketBindingGroup.registerOperationHandler("remove", (OperationStepHandler)SocketBindingGroupRemoveHandler.INSTANCE, (DescriptionProvider)SocketBindingGroupRemoveHandler.INSTANCE, false);
        socketBindingGroup.registerReadWriteAttribute("port-offset", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, 65535, true, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindingGroup.registerReadWriteAttribute("default-interface", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, false, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindingGroup.registerReadWriteAttribute("includes", null, (OperationStepHandler)new WriteAttributeHandlers.ListValidatatingHandler((ParameterValidator)new StringLengthValidator(1, false), true, 0, Integer.MAX_VALUE), AttributeAccess.Storage.CONFIGURATION);
        socketBindingGroup.registerOperationHandler("add-include", (OperationStepHandler)SocketBindingGroupIncludeAddHandler.INSTANCE, (DescriptionProvider)SocketBindingGroupIncludeAddHandler.INSTANCE);
        socketBindingGroup.registerOperationHandler("remove-included-group", (OperationStepHandler)SocketBindingGroupIncludeRemoveHandler.INSTANCE, (DescriptionProvider)SocketBindingGroupIncludeRemoveHandler.INSTANCE);
        ManagementResourceRegistration socketBindings = socketBindingGroup.registerSubModel(PathElement.pathElement((String)"socket-binding"), DomainDescriptionProviders.SOCKET_BINDING);
        socketBindings.registerOperationHandler("add", (OperationStepHandler)SocketBindingAddHandler.INSTANCE, (DescriptionProvider)SocketBindingAddHandler.INSTANCE, false);
        socketBindings.registerOperationHandler("remove", (OperationStepHandler)SocketBindingRemoveHandler.INSTANCE, (DescriptionProvider)SocketBindingRemoveHandler.INSTANCE, false);
        socketBindings.registerReadWriteAttribute("interface", null, (OperationStepHandler)new WriteAttributeHandlers.StringLengthValidatingHandler(1, true, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindings.registerReadWriteAttribute("port", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, 65535, false, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindings.registerReadWriteAttribute("fixed-port", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN, true, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindings.registerReadWriteAttribute("multicast-address", null, (OperationStepHandler)new WriteAttributeHandlers.InetAddressValidatingHandler(true, true), AttributeAccess.Storage.CONFIGURATION);
        socketBindings.registerReadWriteAttribute("multicast-port", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(0, 65535, true, true), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration serverGroups = root.registerSubModel(PathElement.pathElement((String)"server-group"), DomainDescriptionProviders.SERVER_GROUP);
        serverGroups.registerOperationHandler("add", (OperationStepHandler)ServerGroupAddHandler.INSTANCE, (DescriptionProvider)ServerGroupAddHandler.INSTANCE, false);
        serverGroups.registerOperationHandler("remove", (OperationStepHandler)ServerGroupRemoveHandler.INSTANCE, (DescriptionProvider)ServerGroupRemoveHandler.INSTANCE, false);
        serverGroups.registerReadWriteAttribute("socket-binding-group", null, (OperationStepHandler)WriteAttributeHandlers.WriteAttributeOperationHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        serverGroups.registerReadWriteAttribute("socket-binding-port-offset", null, (OperationStepHandler)new WriteAttributeHandlers.IntRangeValidatingHandler(1), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration groupVMs = serverGroups.registerSubModel(PathElement.pathElement((String)"jvm"), CommonProviders.JVM_PROVIDER);
        JVMHandlers.register((ManagementResourceRegistration)groupVMs);
        ServerGroupDeploymentReplaceHandler sgdrh = new ServerGroupDeploymentReplaceHandler(fileRepository);
        serverGroups.registerOperationHandler("replace-deployment", (OperationStepHandler)sgdrh, (DescriptionProvider)sgdrh);
        ManagementResourceRegistration serverGroupDeployments = serverGroups.registerSubModel(PathElement.pathElement((String)"deployment"), DomainDescriptionProviders.SERVER_GROUP_DEPLOYMENT);
        ServerGroupDeploymentAddHandler sgdah = new ServerGroupDeploymentAddHandler(fileRepository);
        serverGroupDeployments.registerOperationHandler("add", (OperationStepHandler)sgdah, (DescriptionProvider)sgdah);
        serverGroupDeployments.registerOperationHandler("deploy", (OperationStepHandler)ServerGroupDeploymentDeployHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentDeployHandler.INSTANCE);
        serverGroupDeployments.registerOperationHandler("redeploy", (OperationStepHandler)ServerGroupDeploymentRedeployHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentRedeployHandler.INSTANCE);
        serverGroupDeployments.registerOperationHandler("undeploy", (OperationStepHandler)ServerGroupDeploymentUndeployHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentUndeployHandler.INSTANCE);
        serverGroupDeployments.registerOperationHandler("remove", (OperationStepHandler)ServerGroupDeploymentRemoveHandler.INSTANCE, (DescriptionProvider)ServerGroupDeploymentRemoveHandler.INSTANCE);
        ManagementResourceRegistration serverGroupSystemProperties = serverGroups.registerSubModel(PathElement.pathElement((String)"system-property"), DomainDescriptionProviders.SERVER_GROUP_SYSTEM_PROPERTY_PROVIDER);
        serverGroupSystemProperties.registerOperationHandler("add", (OperationStepHandler)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, (DescriptionProvider)SystemPropertyAddHandler.INSTANCE_WITH_BOOTTIME, false);
        serverGroupSystemProperties.registerOperationHandler("remove", (OperationStepHandler)SystemPropertyRemoveHandler.INSTANCE, (DescriptionProvider)SystemPropertyRemoveHandler.INSTANCE, false);
        serverGroupSystemProperties.registerReadWriteAttribute("value", null, (OperationStepHandler)SystemPropertyValueWriteAttributeHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        serverGroupSystemProperties.registerReadWriteAttribute("boot-time", null, (OperationStepHandler)new WriteAttributeHandlers.ModelTypeValidatingHandler(ModelType.BOOLEAN), AttributeAccess.Storage.CONFIGURATION);
        ManagementResourceRegistration deployments = root.registerSubModel(PathElement.pathElement((String)"deployment"), DomainDescriptionProviders.DEPLOYMENT_PROVIDER);
        DeploymentAddHandler dah = new DeploymentAddHandler(contentRepo);
        deployments.registerOperationHandler("add", (OperationStepHandler)dah, (DescriptionProvider)dah);
        deployments.registerOperationHandler("remove", (OperationStepHandler)DeploymentRemoveHandler.INSTANCE, (DescriptionProvider)DeploymentRemoveHandler.INSTANCE);
        ManagementResourceRegistration extensions = root.registerSubModel(PathElement.pathElement((String)"extension"), CommonProviders.EXTENSION_PROVIDER);
        ExtensionContextImpl extensionContext = new ExtensionContextImpl(profile, deployments, (SubsystemXmlWriterRegistry)configurationPersister);
        ExtensionAddHandler addExtensionHandler = new ExtensionAddHandler((ExtensionContext)extensionContext);
        extensions.registerOperationHandler("add", (OperationStepHandler)addExtensionHandler, (DescriptionProvider)addExtensionHandler, false);
        extensions.registerOperationHandler("remove", (OperationStepHandler)ExtensionRemoveHandler.INSTANCE, (DescriptionProvider)ExtensionRemoveHandler.INSTANCE, false);
        if (!isMaster) {
            ApplyRemoteMasterDomainModelHandler armdmh = new ApplyRemoteMasterDomainModelHandler((ExtensionContext)extensionContext);
            root.registerOperationHandler("apply-remote-domain-model", (OperationStepHandler)armdmh, (DescriptionProvider)armdmh, false, OperationEntry.EntryType.PRIVATE);
        } else {
            ReadMasterDomainModelHandler rmdmh = new ReadMasterDomainModelHandler(domainController, registry);
            root.registerOperationHandler("read-master-domain-model", (OperationStepHandler)rmdmh, (DescriptionProvider)rmdmh, false, OperationEntry.EntryType.PRIVATE, EnumSet.of(OperationEntry.Flag.READ_ONLY));
        }
        return extensionContext;
    }
}

