/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.deployment;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.metadata.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.services.ResourceAdapterService;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class ResourceAdapterDeploymentService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.connector");
    private final Module module;
    private final ConnectorXmlDescriptor connectorXmlDescriptor;
    private final Connector cmd;
    private final IronJacamar ijmd;

    public ResourceAdapterDeploymentService(ConnectorXmlDescriptor connectorXmlDescriptor, Connector cmd, IronJacamar ijmd, Module module) {
        this.connectorXmlDescriptor = connectorXmlDescriptor;
        this.cmd = cmd;
        this.ijmd = ijmd;
        this.module = module;
    }

    public void start(StartContext context) throws StartException {
        ServiceContainer container = context.getController().getServiceContainer();
        URL url = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getUrl();
        String deploymentName = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getDeploymentName();
        File root = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getRoot();
        CommonDeployment raDeployment = null;
        AS7RaDeployer raDeployer = new AS7RaDeployer(context.getChildTarget(), url, deploymentName, root, (ClassLoader)this.module.getClassLoader(), this.cmd, this.ijmd);
        raDeployer.setConfiguration((Configuration)this.config.getValue());
        try {
            raDeployment = raDeployer.doDeploy();
        }
        catch (Throwable t) {
            throw new StartException("Failed to start RA deployment [" + deploymentName + "]", t);
        }
        this.value = new ResourceAdapterDeployment(raDeployment);
        ((ManagementRepository)this.managementRepository.getValue()).getConnectors().add(this.value.getDeployment().getConnector());
        if (raDeployment.getResourceAdapter() != null) {
            ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
            log.debugf("Starting sevice %s", (Object)ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{this.value.getDeployment().getDeploymentName()}));
            context.getChildTarget().addService(ServiceName.of((String[])new String[]{this.value.getDeployment().getDeploymentName()}), (Service)new ResourceAdapterService(this.value.getDeployment().getResourceAdapter())).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }

    @Override
    public void stop(StopContext context) {
        log.debugf("Stopping sevice %s", (Object)ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{this.value.getDeployment().getDeploymentName()}));
        ((ManagementRepository)this.managementRepository.getValue()).getConnectors().remove(this.value.getDeployment().getConnector());
        super.stop(context);
    }

    private class AS7RaDeployer
    extends AbstractResourceAdapterDeploymentService.AbstractAS7RaDeployer {
        private final IronJacamar ijmd;

        public AS7RaDeployer(ServiceTarget serviceContainer, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, IronJacamar ijmd) {
            super(serviceContainer, url, deploymentName, root, cl, cmd);
            this.ijmd = ijmd;
        }

        @Override
        public CommonDeployment doDeploy() throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterDeploymentService.this.getConfig().getValue());
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(this.url, this.deploymentName, this.root, this.cl, this.cmd, this.ijmd);
            return dep;
        }

        @Override
        protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
            if (cmd != null) {
                HashSet<String> raMcfClasses = new HashSet<String>();
                HashSet<String> raAoClasses = new HashSet<String>();
                if (cmd.getVersion() == Connector.Version.V_10) {
                    ResourceAdapter10 ra10 = (ResourceAdapter10)cmd.getResourceadapter();
                    raMcfClasses.add(ra10.getManagedConnectionFactoryClass().getValue());
                } else {
                    List aoMetas;
                    List cdMetas;
                    ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                    if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                        for (ConnectionDefinition cdMeta : cdMetas) {
                            raMcfClasses.add(cdMeta.getManagedConnectionFactoryClass().getValue());
                        }
                    }
                    if (ra != null && ra.getAdminObjects() != null && (aoMetas = ra.getAdminObjects()).size() > 0) {
                        for (AdminObject aoMeta : aoMetas) {
                            raAoClasses.add(aoMeta.getAdminobjectClass().getValue());
                        }
                    }
                    if (raMcfClasses.size() == 0 && raAoClasses.size() == 0) {
                        return true;
                    }
                }
                if (ijmd != null) {
                    String clz;
                    Iterator it;
                    String clz2;
                    HashSet<String> ijMcfClasses = new HashSet<String>();
                    HashSet<String> ijAoClasses = new HashSet<String>();
                    boolean mcfSingle = false;
                    boolean aoSingle = false;
                    boolean mcfOk = true;
                    boolean aoOk = true;
                    if (ijmd.getConnectionDefinitions() != null) {
                        for (CommonConnDef def : ijmd.getConnectionDefinitions()) {
                            clz2 = def.getClassName();
                            if (clz2 == null) {
                                if (raMcfClasses.size() != 1) continue;
                                mcfSingle = true;
                                continue;
                            }
                            ijMcfClasses.add(clz2);
                        }
                    }
                    if (!mcfSingle) {
                        it = raMcfClasses.iterator();
                        while (mcfOk && it.hasNext()) {
                            clz = (String)it.next();
                            if (ijMcfClasses.contains(clz)) continue;
                            mcfOk = false;
                        }
                    }
                    if (ijmd.getAdminObjects() != null) {
                        for (CommonConnDef def : ijmd.getAdminObjects()) {
                            clz2 = def.getClassName();
                            if (clz2 == null) {
                                if (raAoClasses.size() != 1) continue;
                                aoSingle = true;
                                continue;
                            }
                            ijAoClasses.add(clz2);
                        }
                    }
                    if (!aoSingle) {
                        it = raAoClasses.iterator();
                        while (aoOk && it.hasNext()) {
                            clz = (String)it.next();
                            if (ijAoClasses.contains(clz)) continue;
                            aoOk = false;
                        }
                    }
                    return mcfOk && aoOk;
                }
            }
            return false;
        }

        protected DeployersLogger getLogger() {
            return (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)AS7RaDeployer.class.getName());
        }
    }
}

