/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourceModelNodeUtil;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceService;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class XaDataSourceAdd
extends AbstractDataSourceAdd {
    static final XaDataSourceAdd INSTANCE = new XaDataSourceAdd();

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) {
        XaDataSourceAdd.populateAddModel(operation, model, "xa-data-source-properties", DataSourcesSubsystemProviders.XA_DATASOURCE_ATTRIBUTE);
    }

    @Override
    protected AbstractDataSourceService createDataSourceService(String jndiName) throws OperationFailedException {
        XaDataSourceService service = new XaDataSourceService(jndiName);
        return service;
    }

    @Override
    protected ServiceController<?> startConfigAndAddDependency(ServiceBuilder<?> dataSourceServiceBuilder, AbstractDataSourceService dataSourceService, String jndiName, ServiceTarget serviceTarget, ModelNode operation) throws OperationFailedException {
        XaDataSource dataSourceConfig;
        try {
            dataSourceConfig = DataSourceModelNodeUtil.xaFrom(operation);
        }
        catch (ValidateException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to create XaDataSource instance for [" + operation + "]\n reason:" + e.getLocalizedMessage()));
        }
        ServiceName dataSourceCongServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        XADataSourceConfigService configService = new XADataSourceConfigService(dataSourceConfig);
        ServiceController svcController = serviceTarget.addService(dataSourceCongServiceName, (Service)configService).setInitialMode(ServiceController.Mode.ACTIVE).install();
        dataSourceServiceBuilder.addDependency(dataSourceCongServiceName, XaDataSource.class, ((XaDataSourceService)dataSourceService).getDataSourceConfigInjector());
        return svcController;
    }
}

