/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public final class EntityPrinter {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EntityPrinter.class.getName());
    private SessionFactoryImplementor factory;

    public String toString(Object entity) throws HibernateException {
        EntityPersister entityPersister = this.factory.getEntityPersister(entity.getClass().getName());
        if (entityPersister == null) {
            return entity.getClass().getName();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (entityPersister.hasIdentifierProperty()) {
            result.put(entityPersister.getIdentifierPropertyName(), entityPersister.getIdentifierType().toLoggableString(entityPersister.getIdentifier(entity), this.factory));
        }
        Type[] types = entityPersister.getPropertyTypes();
        String[] names = entityPersister.getPropertyNames();
        Object[] values = entityPersister.getPropertyValues(entity);
        for (int i = 0; i < types.length; ++i) {
            if (names[i].startsWith("_")) continue;
            String strValue = values[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? values[i].toString() : types[i].toLoggableString(values[i], this.factory);
            result.put(names[i], strValue);
        }
        return entityPersister.getEntityName() + ((Object)result).toString();
    }

    public String toString(Type[] types, Object[] values) throws HibernateException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null) continue;
            buffer.append(types[i].toLoggableString(values[i], this.factory)).append(", ");
        }
        return buffer.toString();
    }

    public String toString(Map<String, TypedValue> namedTypedValues) throws HibernateException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, TypedValue> entry : namedTypedValues.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getType().toLoggableString(entry.getValue().getValue(), this.factory));
        }
        return ((Object)result).toString();
    }

    public void toString(Iterator iterator) throws HibernateException {
        if (!LOG.isDebugEnabled() || !iterator.hasNext()) {
            return;
        }
        LOG.debugf("Listing entities:", new Object[0]);
        int i = 0;
        while (iterator.hasNext()) {
            if (i++ > 20) {
                LOG.debugf("More......", new Object[0]);
                break;
            }
            LOG.debugf(this.toString(iterator.next()), new Object[0]);
        }
    }

    public EntityPrinter(SessionFactoryImplementor factory) {
        this.factory = factory;
    }
}

