/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.metamodel.Metadata;
import org.hibernate.metamodel.MetadataBuilder;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.MappingNotFoundException;
import org.hibernate.metamodel.source.Origin;
import org.hibernate.metamodel.source.SourceType;
import org.hibernate.metamodel.source.internal.JaxbHelper;
import org.hibernate.metamodel.source.internal.JaxbRoot;
import org.hibernate.metamodel.source.internal.MetadataBuilderImpl;
import org.hibernate.service.BasicServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class MetadataSources {
    private static final Logger LOG = Logger.getLogger(MetadataSources.class);
    private List<JaxbRoot> jaxbRootList = new ArrayList<JaxbRoot>();
    private LinkedHashSet<Class<?>> annotatedClasses = new LinkedHashSet();
    private LinkedHashSet<String> annotatedPackages = new LinkedHashSet();
    private final JaxbHelper jaxbHelper;
    private final BasicServiceRegistry serviceRegistry;
    private final EntityResolver entityResolver;
    private final NamingStrategy namingStrategy;
    private final MetadataBuilderImpl metadataBuilder;

    public MetadataSources(BasicServiceRegistry serviceRegistry) {
        this(serviceRegistry, EJB3DTDEntityResolver.INSTANCE, EJB3NamingStrategy.INSTANCE);
    }

    public MetadataSources(BasicServiceRegistry serviceRegistry, EntityResolver entityResolver, NamingStrategy namingStrategy) {
        this.serviceRegistry = serviceRegistry;
        this.entityResolver = entityResolver;
        this.namingStrategy = namingStrategy;
        this.jaxbHelper = new JaxbHelper(this);
        this.metadataBuilder = new MetadataBuilderImpl(this);
    }

    public List<JaxbRoot> getJaxbRootList() {
        return this.jaxbRootList;
    }

    public Iterable<String> getAnnotatedPackages() {
        return this.annotatedPackages;
    }

    public Iterable<Class<?>> getAnnotatedClasses() {
        return this.annotatedClasses;
    }

    public BasicServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public MetadataBuilder getMetadataBuilder() {
        return this.metadataBuilder;
    }

    public Metadata buildMetadata() {
        return this.getMetadataBuilder().buildMetadata();
    }

    public MetadataSources addAnnotatedClass(Class annotatedClass) {
        this.annotatedClasses.add(annotatedClass);
        return this;
    }

    public MetadataSources addPackage(String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("The specified package name cannot be null");
        }
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        this.annotatedPackages.add(packageName);
        return this;
    }

    public MetadataSources addResource(String name) {
        LOG.tracef("reading mappings from resource : %s", (Object)name);
        Origin origin = new Origin(SourceType.RESOURCE, name);
        InputStream resourceInputStream = this.classLoaderService().locateResourceStream(name);
        if (resourceInputStream == null) {
            throw new MappingNotFoundException(origin);
        }
        this.add(resourceInputStream, origin, true);
        return this;
    }

    private ClassLoaderService classLoaderService() {
        return this.serviceRegistry.getService(ClassLoaderService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JaxbRoot add(InputStream inputStream, Origin origin, boolean close) {
        try {
            JaxbRoot jaxbRoot = this.jaxbHelper.unmarshal(inputStream, origin);
            this.jaxbRootList.add(jaxbRoot);
            JaxbRoot jaxbRoot2 = jaxbRoot;
            return jaxbRoot2;
        }
        finally {
            if (close) {
                try {
                    inputStream.close();
                }
                catch (IOException ignore) {
                    LOG.trace((Object)"Was unable to close input stream");
                }
            }
        }
    }

    public MetadataSources addClass(Class entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("The specified class cannot be null");
        }
        LOG.debugf("adding resource mappings from class convention : %s", (Object)entityClass.getName());
        String mappingResourceName = entityClass.getName().replace('.', '/') + ".hbm.xml";
        this.addResource(mappingResourceName);
        return this;
    }

    public MetadataSources addFile(String path) {
        return this.addFile(new File(path));
    }

    public MetadataSources addFile(File file) {
        String name = file.getAbsolutePath();
        LOG.tracef("reading mappings from file : %s", (Object)name);
        Origin origin = new Origin(SourceType.FILE, name);
        try {
            this.add(new FileInputStream(file), origin, true);
        }
        catch (FileNotFoundException e) {
            throw new MappingNotFoundException(e, origin);
        }
        return this;
    }

    public MetadataSources addCacheableFile(String path) {
        return this;
    }

    public MetadataSources addCacheableFile(File file) {
        return this;
    }

    public MetadataSources addInputStream(InputStream xmlInputStream) {
        this.add(xmlInputStream, new Origin(SourceType.INPUT_STREAM, "<unknown>"), false);
        return this;
    }

    public MetadataSources addURL(URL url) {
        String urlExternalForm = url.toExternalForm();
        LOG.debugf("Reading mapping document from URL : %s", (Object)urlExternalForm);
        Origin origin = new Origin(SourceType.URL, urlExternalForm);
        try {
            this.add(url.openStream(), origin, true);
        }
        catch (IOException e) {
            throw new MappingNotFoundException("Unable to open url stream [" + urlExternalForm + "]", e, origin);
        }
        return this;
    }

    public MetadataSources addDocument(Document document) {
        Origin origin = new Origin(SourceType.DOM, "<unknown>");
        JaxbRoot jaxbRoot = this.jaxbHelper.unmarshal(document, origin);
        this.jaxbRootList.add(jaxbRoot);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetadataSources addJar(File jar) {
        LOG.debugf("Seeking mapping documents in jar file : %s", (Object)jar.getName());
        Origin origin = new Origin(SourceType.JAR, jar.getAbsolutePath());
        try {
            JarFile jarFile = new JarFile(jar);
            try {
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    ZipEntry zipEntry = jarEntries.nextElement();
                    if (!zipEntry.getName().endsWith(".hbm.xml")) continue;
                    LOG.tracef("found mapping document : %s", (Object)zipEntry.getName());
                    try {
                        this.add(jarFile.getInputStream(zipEntry), origin, true);
                    }
                    catch (Exception e) {
                        throw new MappingException("could not read mapping documents", e, origin);
                        return this;
                    }
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception ignore) {}
            }
        }
        catch (IOException e) {
            throw new MappingNotFoundException(e, origin);
        }
    }

    public MetadataSources addDirectory(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.addDirectory(file);
                continue;
            }
            if (!file.getName().endsWith(".hbm.xml")) continue;
            this.addFile(file);
        }
        return this;
    }
}

