/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.standalone;

import java.io.Serializable;
import java.util.UUID;
import org.jboss.as.controller.client.helpers.standalone.ServerUpdateActionResult;

public abstract class AbstractServerUpdateActionResult<T extends ServerUpdateActionResult>
implements ServerUpdateActionResult,
Serializable {
    private static final long serialVersionUID = -4692787126053225682L;
    private final UUID id;
    private ServerUpdateActionResult.Result result;
    private final Throwable deploymentException;
    private T rollbackResult;

    protected AbstractServerUpdateActionResult() {
        this.id = null;
        this.deploymentException = null;
    }

    public AbstractServerUpdateActionResult(UUID id, ServerUpdateActionResult.Result result) {
        this(id, result, null);
    }

    public AbstractServerUpdateActionResult(UUID id, Throwable deploymentException) {
        this(id, ServerUpdateActionResult.Result.FAILED, deploymentException);
    }

    public AbstractServerUpdateActionResult(UUID id, ServerUpdateActionResult.Result result, Throwable deploymentException) {
        if (id == null) {
            throw new IllegalStateException("id is null");
        }
        if (result == null) {
            throw new IllegalStateException("result is null");
        }
        this.id = id;
        this.result = result;
        this.deploymentException = deploymentException;
    }

    @Override
    public UUID getUpdateActionId() {
        return this.id;
    }

    @Override
    public Throwable getDeploymentException() {
        return this.deploymentException;
    }

    @Override
    public ServerUpdateActionResult.Result getResult() {
        if (this.rollbackResult != null) {
            return this.result == ServerUpdateActionResult.Result.FAILED ? this.result : ServerUpdateActionResult.Result.ROLLED_BACK;
        }
        return this.result;
    }

    public T getRollbackResult() {
        return this.rollbackResult;
    }

    protected abstract Class<T> getRollbackResultClass();

    public static <R extends ServerUpdateActionResult> void installRollbackResult(AbstractServerUpdateActionResult<R> update, ServerUpdateActionResult rollback) {
        ServerUpdateActionResult cast = (ServerUpdateActionResult)update.getRollbackResultClass().cast(rollback);
        update.rollbackResult = cast;
    }
}

