/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.commands.RemoveCacheCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.ConfigurationValidatingVisitor;
import org.infinispan.config.DelegatingConfigurationVisitor;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.config.TimeoutConfigurationValidatingVisitor;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.InternalCacheFactory;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.Lifecycle;
import org.infinispan.manager.CacheManager;
import org.infinispan.manager.CacheWrapper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.ReflectionCache;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.Immutables;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;
import org.rhq.helpers.pluginAnnotations.agent.Parameter;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
@MBean(objectName="CacheManager", description="Component that acts as a manager, factory and container for caches in the system.")
public class DefaultCacheManager
implements EmbeddedCacheManager,
CacheManager {
    public static final String OBJECT_NAME = "CacheManager";
    private static final Log log = LogFactory.getLog(DefaultCacheManager.class);
    private final DelegatingConfigurationVisitor configurationValidator = new DelegatingConfigurationVisitor(new ConfigurationBeanVisitor[]{new ConfigurationValidatingVisitor(), new TimeoutConfigurationValidatingVisitor()});
    protected final GlobalConfiguration globalConfiguration;
    protected final Configuration defaultConfiguration;
    private final ConcurrentMap<String, CacheWrapper> caches = new ConcurrentHashMap<String, CacheWrapper>();
    private final ConcurrentMap<String, Configuration> configurationOverrides = new ConcurrentHashMap<String, Configuration>();
    private final GlobalComponentRegistry globalComponentRegistry;
    private final ReentrantLock cacheCreateLock;
    private final ReflectionCache reflectionCache = new ReflectionCache();
    private volatile boolean stopping;

    public DefaultCacheManager() {
        this(null, null, true);
    }

    public DefaultCacheManager(boolean start) {
        this(null, null, start);
    }

    public DefaultCacheManager(Configuration defaultConfiguration) {
        this(null, defaultConfiguration, true);
    }

    public DefaultCacheManager(Configuration defaultConfiguration, boolean start) {
        this(null, defaultConfiguration, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration) {
        this(globalConfiguration, null, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, boolean start) {
        this(globalConfiguration, null, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
        this(globalConfiguration, defaultConfiguration, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration, boolean start) {
        this.globalConfiguration = globalConfiguration == null ? new GlobalConfiguration() : globalConfiguration.clone();
        this.globalConfiguration.accept(this.configurationValidator);
        this.defaultConfiguration = defaultConfiguration == null ? new Configuration() : defaultConfiguration.clone();
        this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.reflectionCache, this.caches.keySet());
        this.cacheCreateLock = new ReentrantLock();
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(String configurationFile) throws IOException {
        this(configurationFile, true);
    }

    public DefaultCacheManager(String configurationFile, boolean start) throws IOException {
        try {
            InfinispanConfiguration configuration = InfinispanConfiguration.newInfinispanConfiguration(configurationFile, InfinispanConfiguration.resolveSchemaPath(), Thread.currentThread().getContextClassLoader());
            this.globalConfiguration = configuration.parseGlobalConfiguration();
            this.globalConfiguration.accept(this.configurationValidator);
            this.defaultConfiguration = configuration.parseDefaultConfiguration();
            for (Map.Entry<String, Configuration> entry : configuration.parseNamedConfigurations().entrySet()) {
                Configuration c = this.defaultConfiguration.clone();
                c.applyOverrides(entry.getValue());
                this.configurationOverrides.put(entry.getKey(), c);
            }
            this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.reflectionCache, this.caches.keySet());
            this.cacheCreateLock = new ReentrantLock();
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(InputStream configurationStream) throws IOException {
        this(configurationStream, true);
    }

    public DefaultCacheManager(InputStream configurationStream, boolean start) throws IOException {
        InputStream schemaInputStream = InfinispanConfiguration.findSchemaInputStream();
        try {
            InfinispanConfiguration configuration = InfinispanConfiguration.newInfinispanConfiguration(configurationStream, schemaInputStream);
            this.globalConfiguration = configuration.parseGlobalConfiguration();
            this.globalConfiguration.accept(this.configurationValidator);
            this.defaultConfiguration = configuration.parseDefaultConfiguration();
            for (Map.Entry<String, Configuration> entry : configuration.parseNamedConfigurations().entrySet()) {
                Configuration c = this.defaultConfiguration.clone();
                c.applyOverrides(entry.getValue());
                this.configurationOverrides.put(entry.getKey(), c);
            }
            this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.reflectionCache, this.caches.keySet());
            this.cacheCreateLock = new ReentrantLock();
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        finally {
            Util.close((Closeable)schemaInputStream);
        }
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(String globalConfigurationFile, String defaultConfigurationFile, String namedCacheFile, boolean start) throws IOException {
        try {
            InfinispanConfiguration gconfiguration = InfinispanConfiguration.newInfinispanConfiguration(globalConfigurationFile, InfinispanConfiguration.resolveSchemaPath(), Thread.currentThread().getContextClassLoader());
            this.globalConfiguration = gconfiguration.parseGlobalConfiguration();
            this.globalConfiguration.accept(this.configurationValidator);
            InfinispanConfiguration dconfiguration = InfinispanConfiguration.newInfinispanConfiguration(defaultConfigurationFile, InfinispanConfiguration.resolveSchemaPath(), Thread.currentThread().getContextClassLoader());
            this.defaultConfiguration = dconfiguration.parseDefaultConfiguration();
            if (namedCacheFile != null) {
                InfinispanConfiguration NCconfiguration = InfinispanConfiguration.newInfinispanConfiguration(namedCacheFile, InfinispanConfiguration.resolveSchemaPath(), Thread.currentThread().getContextClassLoader());
                for (Map.Entry<String, Configuration> entry : NCconfiguration.parseNamedConfigurations().entrySet()) {
                    Configuration c = this.defaultConfiguration.clone();
                    c.applyOverrides(entry.getValue());
                    this.configurationOverrides.put(entry.getKey(), c);
                }
            }
            this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this, this.reflectionCache, this.caches.keySet());
            this.cacheCreateLock = new ReentrantLock();
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        if (start) {
            this.start();
        }
    }

    @Override
    public Configuration defineConfiguration(String cacheName, Configuration configurationOverride) {
        return this.defineConfiguration(cacheName, configurationOverride, this.defaultConfiguration, true);
    }

    @Override
    public Configuration defineConfiguration(String cacheName, String templateName, Configuration configurationOverride) {
        if (templateName != null) {
            Configuration c = (Configuration)this.configurationOverrides.get(templateName);
            if (c != null) {
                return this.defineConfiguration(cacheName, configurationOverride, c, false);
            }
            return this.defineConfiguration(cacheName, configurationOverride);
        }
        return this.defineConfiguration(cacheName, configurationOverride);
    }

    private Configuration defineConfiguration(String cacheName, Configuration configOverride, Configuration defaultConfigIfNotPresent, boolean checkExisting) {
        Configuration existing;
        this.assertIsNotTerminated();
        if (cacheName == null || configOverride == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if (cacheName.equals("___defaultcache")) {
            throw new IllegalArgumentException("Cache name cannot be used as it is a reserved, internal name");
        }
        if (checkExisting && (existing = (Configuration)this.configurationOverrides.get(cacheName)) != null) {
            existing.applyOverrides(configOverride);
            return existing.clone();
        }
        Configuration configuration = defaultConfigIfNotPresent.clone();
        configuration.applyOverrides(configOverride.clone());
        this.configurationOverrides.put(cacheName, configuration);
        this.setConfigurationName(cacheName, configuration);
        return configuration;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return this.getCache("___defaultcache");
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.assertIsNotTerminated();
        if (cacheName == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        CacheWrapper cw = (CacheWrapper)this.caches.get(cacheName);
        if (cw != null) {
            return cw.getCache();
        }
        if (this.caches.size() > 0) {
            log.shouldBeUsingStartCache(cacheName);
        }
        return this.createCache(cacheName);
    }

    @Override
    public boolean cacheExists(String cacheName) {
        return this.caches.containsKey(cacheName);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName, boolean createIfAbsent) {
        boolean cacheExists = this.cacheExists(cacheName);
        if (!cacheExists && !createIfAbsent) {
            return null;
        }
        return this.getCache(cacheName);
    }

    @Override
    public EmbeddedCacheManager startCaches(String ... cacheNames) {
        ArrayList<1> threads = new ArrayList<1>(cacheNames.length);
        boolean haveStoppedCaches = false;
        boolean haveRunningCaches = false;
        for (final String cacheName : cacheNames) {
            if (this.isRunning(cacheName)) {
                haveRunningCaches = true;
                continue;
            }
            haveStoppedCaches = true;
            String threadName = "CacheStartThread," + this.globalConfiguration.getClusterName() + "," + cacheName;
            Thread thread = new Thread(threadName){

                @Override
                public void run() {
                    DefaultCacheManager.this.createCache(cacheName);
                }
            };
            thread.start();
            threads.add(thread);
        }
        if (haveStoppedCaches && haveRunningCaches) {
            log.asymmetricClusterWarning();
        }
        try {
            for (Thread thread : threads) {
                thread.join(this.defaultConfiguration.getLockAcquisitionTimeout());
            }
        }
        catch (InterruptedException e) {
            throw new CacheException("Interrupted while waiting for the caches to start");
        }
        return this;
    }

    @Override
    public void removeCache(String cacheName) {
        RemoveCacheCommand cmd = new RemoveCacheCommand(this, this.globalComponentRegistry);
        cmd.injectComponents(null, this.globalComponentRegistry.getNamedComponentRegistry(cacheName));
        cmd.setCacheName(cacheName);
        Transport transport = this.getTransport();
        try {
            if (transport != null) {
                Configuration c = this.getConfiguration(cacheName);
                transport.invokeRemotely(null, cmd, ResponseMode.SYNCHRONOUS, c.getSyncReplTimeout(), false, null, false);
            }
            cmd.perform(null);
        }
        catch (Throwable t) {
            throw new CacheException("Error removing cache", t);
        }
    }

    @Override
    public String getClusterName() {
        return this.globalConfiguration.getClusterName();
    }

    @Override
    public List<Address> getMembers() {
        Transport t = this.getTransport();
        return t == null ? null : t.getMembers();
    }

    @Override
    public Address getAddress() {
        Transport t = this.getTransport();
        return t == null ? null : t.getAddress();
    }

    @Override
    public Address getCoordinator() {
        Transport t = this.getTransport();
        return t == null ? null : t.getCoordinator();
    }

    @Override
    public boolean isCoordinator() {
        Transport t = this.getTransport();
        return t != null && t.isCoordinator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache createCache(String cacheName) {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(cacheName, trace);
        try {
            Cache cache = this.wireCache(cacheName);
            if (cache == null) {
                Cache cache2 = ((CacheWrapper)this.caches.get(cacheName)).getCache();
                return cache2;
            }
            try {
                cache.start();
            }
            finally {
                ((CacheWrapper)this.caches.get((Object)cacheName)).latch.countDown();
            }
            Cache cache3 = cache;
            return cache3;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    private Cache wireCache(String cacheName) {
        boolean acquired = false;
        try {
            if (!this.cacheCreateLock.tryLock(this.defaultConfiguration.getLockAcquisitionTimeout(), TimeUnit.MILLISECONDS)) {
                throw new CacheException("Unable to acquire lock on cache with name " + cacheName);
            }
            acquired = true;
            CacheWrapper existingCache = (CacheWrapper)this.caches.get(cacheName);
            if (existingCache != null) {
                Cache cache = null;
                return cache;
            }
            Configuration c = this.getConfiguration(cacheName);
            this.setConfigurationName(cacheName, c);
            c.setGlobalConfiguration(this.globalConfiguration);
            c.accept(this.configurationValidator);
            c.assertValid();
            Cache cache = new InternalCacheFactory().createCache(c, this.globalComponentRegistry, cacheName, this.reflectionCache);
            CacheWrapper cw = new CacheWrapper(cache);
            existingCache = this.caches.put(cacheName, cw);
            if (existingCache != null) {
                throw new IllegalStateException("attempt to initialize the cache twice");
            }
            this.globalComponentRegistry.start();
            Cache cache2 = cache;
            return cache2;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException("Interrupted while trying to get lock on cache with cache name " + cacheName, e);
        }
        finally {
            if (acquired) {
                this.cacheCreateLock.unlock();
            }
        }
    }

    private Configuration getConfiguration(String cacheName) {
        Configuration c = cacheName.equals("___defaultcache") || !this.configurationOverrides.containsKey(cacheName) ? this.defaultConfiguration.clone() : (Configuration)this.configurationOverrides.get(cacheName);
        return c;
    }

    @Override
    public void start() {
        this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).start();
        log.debugf("Started cache manager %s on %s", this.globalConfiguration.getClusterName(), this.getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.stopping) {
            DefaultCacheManager defaultCacheManager = this;
            synchronized (defaultCacheManager) {
                if (!this.stopping) {
                    log.debugf("Stopping cache manager %s on %s", this.globalConfiguration.getClusterName(), this.getAddress());
                    this.stopping = true;
                    Lifecycle defaultCache = null;
                    for (Map.Entry entry : this.caches.entrySet()) {
                        if (((String)entry.getKey()).equals("___defaultcache")) {
                            defaultCache = ((CacheWrapper)entry.getValue()).cache;
                            continue;
                        }
                        Cache c = ((CacheWrapper)entry.getValue()).cache;
                        if (c == null) continue;
                        this.unregisterCacheMBean(c);
                        c.stop();
                    }
                    if (defaultCache != null) {
                        this.unregisterCacheMBean((Cache)defaultCache);
                        defaultCache.stop();
                    }
                    this.globalComponentRegistry.getComponent(CacheManagerJmxRegistration.class).stop();
                    this.globalComponentRegistry.stop();
                    this.reflectionCache.stop();
                } else if (log.isTraceEnabled()) {
                    log.trace("Ignore call to stop as the cache manager is stopping");
                }
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Ignore call to stop as the cache manager is stopping");
        }
    }

    private void unregisterCacheMBean(Cache cache) {
        if (cache.getConfiguration().isExposeJmxStatistics()) {
            cache.getAdvancedCache().getComponentRegistry().getComponent(CacheJmxRegistration.class).unregisterCacheMBean();
        }
    }

    @Override
    public void addListener(Object listener) {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        return notifier.getListeners();
    }

    @Override
    public ComponentStatus getStatus() {
        return this.globalComponentRegistry.getStatus();
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    @Override
    public Configuration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    @Override
    public Set<String> getCacheNames() {
        HashSet names = new HashSet(this.configurationOverrides.keySet());
        names.addAll(Immutables.immutableSetConvert(this.caches.keySet()));
        names.remove("___defaultcache");
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    @Override
    public boolean isRunning(String cacheName) {
        CacheWrapper w = (CacheWrapper)this.caches.get(cacheName);
        try {
            return w != null && w.latch.await(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean isDefaultRunning() {
        return this.isRunning("___defaultcache");
    }

    @ManagedAttribute(description="The status of the cache manager instance.")
    @Metric(displayName="Cache manager status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheManagerStatus() {
        return this.getStatus().toString();
    }

    @ManagedAttribute(description="The defined cache names and their statuses.  The default cache is not included in this representation.")
    @Metric(displayName="List of defined caches", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getDefinedCacheNames() {
        StringBuilder result = new StringBuilder("[");
        for (String cacheName : this.getCacheNames()) {
            boolean started = this.caches.containsKey(cacheName);
            result.append(cacheName).append(started ? "(created)" : "(not created)");
        }
        result.append("]");
        return result.toString();
    }

    @ManagedAttribute(description="The total number of defined caches, excluding the default cache.")
    @Metric(displayName="Number of caches defined", displayType=DisplayType.SUMMARY)
    public String getDefinedCacheCount() {
        return String.valueOf(this.configurationOverrides.keySet().size());
    }

    @ManagedAttribute(description="The total number of created caches, including the default cache.")
    @Metric(displayName="Number of caches created", displayType=DisplayType.SUMMARY)
    public String getCreatedCacheCount() {
        return String.valueOf(this.caches.keySet().size());
    }

    @ManagedAttribute(description="The total number of running caches, including the default cache.")
    @Metric(displayName="Number of running caches", displayType=DisplayType.SUMMARY)
    public String getRunningCacheCount() {
        int running = 0;
        for (CacheWrapper cachew : this.caches.values()) {
            Cache cache = cachew.cache;
            if (cache == null || cache.getStatus() != ComponentStatus.RUNNING) continue;
            ++running;
        }
        return String.valueOf(running);
    }

    @ManagedAttribute(description="Infinispan version.")
    @Metric(displayName="Infinispan version", displayType=DisplayType.SUMMARY, dataType=DataType.TRAIT)
    public String getVersion() {
        return Version.printVersion();
    }

    @ManagedAttribute(description="The name of this cache manager")
    @Metric(displayName="Cache manager name", displayType=DisplayType.SUMMARY, dataType=DataType.TRAIT)
    public String getName() {
        return this.globalConfiguration.getCacheManagerName();
    }

    @ManagedOperation(description="Starts the default cache associated with this cache manager")
    @Operation(displayName="Starts the default cache")
    public void startCache() {
        this.getCache();
    }

    @ManagedOperation(description="Starts a named cache from this cache manager")
    @Operation(name="startCacheWithCacheName", displayName="Starts a cache with the given name")
    public void startCache(@Parameter(name="cacheName", description="Name of cache to start") String cacheName) {
        this.getCache(cacheName);
    }

    @ManagedAttribute(description="The network address associated with this instance")
    @Metric(displayName="Network address", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getNodeAddress() {
        return this.getLogicalAddressString();
    }

    @ManagedAttribute(description="The physical network addresses associated with this instance")
    @Metric(displayName="Physical network addresses", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getPhysicalAddresses() {
        Transport t = this.getTransport();
        if (t == null) {
            return "local";
        }
        List<Address> address = t.getPhysicalAddresses();
        return address == null ? "local" : address.toString();
    }

    @ManagedAttribute(description="List of members in the cluster")
    @Metric(displayName="Cluster members", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getClusterMembers() {
        Transport t = this.getTransport();
        if (t == null) {
            return "local";
        }
        List<Address> addressList = t.getMembers();
        return addressList.toString();
    }

    @ManagedAttribute(description="Size of the cluster in number of nodes")
    @Metric(displayName="Cluster size", displayType=DisplayType.SUMMARY)
    public int getClusterSize() {
        Transport t = this.getTransport();
        if (t == null) {
            return 1;
        }
        return t.getMembers().size();
    }

    private String getLogicalAddressString() {
        return this.getAddress() == null ? "local" : this.getAddress().toString();
    }

    private void assertIsNotTerminated() {
        if (this.globalComponentRegistry.getStatus().isTerminated()) {
            throw new IllegalStateException("Cache container has been stopped and cannot be reused. Recreate the cache container.");
        }
    }

    private Transport getTransport() {
        if (this.globalComponentRegistry == null) {
            return null;
        }
        return this.globalComponentRegistry.getComponent(Transport.class);
    }

    public String toString() {
        return super.toString() + "@Address:" + this.getAddress();
    }

    private void setConfigurationName(String cacheName, Configuration configuration) {
        ReflectionUtil.setValue(configuration, "name", cacheName);
    }
}

