/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

public class SlaveRegistrationError {
    private static final String SEPARATOR = "-$-";
    private final ErrorCode errorCode;
    private final String errorMessage;

    private SlaveRegistrationError(ErrorCode errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public static SlaveRegistrationError parse(String raw) {
        int index = raw.indexOf(SEPARATOR);
        if (index == -1) {
            return new SlaveRegistrationError(ErrorCode.NONE, raw);
        }
        ErrorCode code = ErrorCode.parseCode(Integer.valueOf(raw.substring(0, index)));
        String msg = raw.substring(index + SEPARATOR.length());
        return new SlaveRegistrationError(code, msg);
    }

    public static String formatHostAlreadyExists(String msg) {
        return new SlaveRegistrationError(ErrorCode.HOST_ALREADY_EXISTS, msg).toString();
    }

    public String toString() {
        return this.errorCode.getCode() + SEPARATOR + this.errorMessage;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum ErrorCode {
        NONE(0),
        HOST_ALREADY_EXISTS(1);

        private final int code;

        private ErrorCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }

        static ErrorCode parseCode(int code) {
            if (code == NONE.getCode()) {
                return NONE;
            }
            if (code == HOST_ALREADY_EXISTS.getCode()) {
                return HOST_ALREADY_EXISTS;
            }
            throw new IllegalArgumentException("Invalid code " + code);
        }
    }
}

