/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Locale;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQServerAdd;
import org.jboss.as.messaging.HornetQServerControlHandler;
import org.jboss.as.messaging.HornetQServerControlWriteHandler;
import org.jboss.as.messaging.HornetQServerRemove;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.JMSServerControlHandler;
import org.jboss.dmr.ModelNode;

public class HornetQServerResourceDefinition
extends SimpleResourceDefinition {
    private static final PathElement HORNETQ_SERVER_PATH = PathElement.pathElement((String)"hornetq-server");
    public static final HornetQServerResourceDefinition INSTANCE = new HornetQServerResourceDefinition();

    private HornetQServerResourceDefinition() {
        super(HORNETQ_SERVER_PATH, MessagingExtension.getResourceDescriptionResolver("hornetq-server"), (OperationStepHandler)HornetQServerAdd.INSTANCE, (OperationStepHandler)HornetQServerRemove.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        HornetQServerControlHandler.INSTANCE.registerOperations(resourceRegistration);
        JMSServerControlHandler.INSTANCE.registerOperations(resourceRegistration);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        HornetQServerControlWriteHandler.INSTANCE.registerAttributes(resourceRegistration);
        HornetQServerControlHandler.INSTANCE.registerAttributes(resourceRegistration);
    }

    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
        return new DefaultResourceDescriptionProvider(resourceRegistration, this.getResourceDescriptionResolver()){

            public ModelNode getModelDescription(Locale locale) {
                ModelNode result = super.getModelDescription(locale);
                String path = CommonAttributes.PATH.getName();
                result.get(new String[]{"children", path, "min-occurs"}).set(4);
                result.get(new String[]{"children", path, "max-occurs"}).set(4);
                return result;
            }
        };
    }
}

