/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ejb.FinderException;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.AliasManager;
import org.jboss.as.cmp.jdbc.JDBCAbstractQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.QueryParameter;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCTypeMappingMetaData;

public final class JDBCFindByPrimaryKeyQuery
extends JDBCAbstractQueryCommand {
    private JDBCStoreManager manager;
    private boolean rowLocking;

    public JDBCFindByPrimaryKeyQuery(JDBCStoreManager manager, JDBCQueryMetaData q) {
        super(manager, q);
        this.manager = manager;
        this.rowLocking = manager.getMetaData().hasRowLocking();
        JDBCEntityBridge entity = (JDBCEntityBridge)manager.getEntityBridge();
        JDBCTypeMappingMetaData typeMapping = this.manager.getJDBCTypeFactory().getTypeMapping();
        AliasManager aliasManager = new AliasManager(typeMapping.getAliasHeaderPrefix(), typeMapping.getAliasHeaderSuffix(), typeMapping.getAliasMaxLength());
        String alias = aliasManager.getAlias(entity.getEntityName());
        StringBuffer select = new StringBuffer(200);
        SQLUtil.getColumnNamesClause(entity.getPrimaryKeyFields(), alias, select);
        StringBuffer from = new StringBuffer();
        from.append(entity.getQualifiedTableName()).append(' ').append(alias);
        JDBCReadAheadMetaData readAhead = q.getReadAhead();
        if (readAhead.isOnFind()) {
            this.setEagerLoadGroup(readAhead.getEagerLoadGroup());
            if (this.getEagerLoadMask() != null) {
                SQLUtil.appendColumnNamesClause(entity.getTableFields(), this.getEagerLoadMask(), alias, select);
                List<JDBCAbstractQueryCommand.LeftJoinCMRNode> onFindCMRList = JDBCAbstractQueryCommand.getLeftJoinCMRNodes(entity, entity.getQualifiedTableName(), readAhead.getLeftJoins(), null);
                if (!onFindCMRList.isEmpty()) {
                    this.setOnFindCMRList(onFindCMRList);
                    JDBCAbstractQueryCommand.leftJoinCMRNodes(alias, onFindCMRList, aliasManager, from);
                    JDBCAbstractQueryCommand.appendLeftJoinCMRColumnNames(onFindCMRList, aliasManager, select);
                }
            }
        }
        StringBuffer where = new StringBuffer();
        SQLUtil.getWhereClause(entity.getPrimaryKeyFields(), alias, where);
        StringBuffer sql = new StringBuffer(300);
        if (this.rowLocking && readAhead.isOnFind() && this.getEagerLoadMask() != null) {
            JDBCFunctionMappingMetaData rowLockingTemplate = typeMapping.getRowLockingTemplate();
            rowLockingTemplate.getFunctionSql(new Object[]{select, from, where.length() == 0 ? null : where, null}, sql);
        } else {
            sql.append("SELECT ").append(select).append(" FROM ").append(from).append(" WHERE ").append(where);
        }
        this.setSQL(sql.toString());
        this.setParameterList(QueryParameter.createPrimaryKeyParameters(0, entity));
    }

    @Override
    public Collection execute(Method finderMethod, Object[] args, CmpEntityBeanContext ctx, JDBCQueryCommand.EntityProxyFactory factory) throws FinderException {
        if (this.manager.getReadAheadCache().getPreloadDataMap(args[0], false) != null) {
            Object pk = null;
            JDBCFieldBridge[] pkFields = this.manager.getEntityBridge().getPrimaryKeyFields();
            for (int i = 0; i < pkFields.length; ++i) {
                JDBCAbstractCMPFieldBridge pkField = (JDBCAbstractCMPFieldBridge)pkFields[i];
                Object fieldValue = pkField.getPrimaryKeyValue(args[0]);
                pk = pkField.setPrimaryKeyValue(pk, fieldValue);
            }
            return Collections.singletonList(factory.getEntityObject(pk));
        }
        return super.execute(finderMethod, args, ctx, factory);
    }
}

